/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.VirtualConfigurationType;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0015\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0012\u0010\u0017\u001a\u00020\b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/impl/RunConfigurationTemplatesConfigurable;", "Lcom/intellij/execution/impl/RunConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "configurationType", "Lcom/intellij/execution/configurations/ConfigurationType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationType;)V", "addRunConfigurationsToModel", "", "model", "Ljavax/swing/tree/DefaultMutableTreeNode;", "apply", "createComponent", "Ljavax/swing/JComponent;", "createLeftPanel", "expandTemplatesNode", "templatesNode", "getDisplayName", "", "postInit", "disposable", "Lcom/intellij/openapi/Disposable;", "postInit$intellij_platform_execution_impl", "selectTypeNode", "intellij.platform.execution.impl"})
public final class RunConfigurationTemplatesConfigurable
extends RunConfigurable {
    private final ConfigurationType configurationType;

    public final void postInit$intellij_platform_execution_impl(@NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.initTreeSelectionListener(disposable2);
        this.selectTypeNode(this.configurationType);
    }

    private final void selectTypeNode(ConfigurationType configurationType) {
        block2: {
            TreeNode node2;
            ConfigurationType configurationType2 = configurationType;
            if (configurationType2 == null) break block2;
            ConfigurationType configurationType3 = configurationType2;
            boolean bl = false;
            boolean bl2 = false;
            ConfigurationType it = configurationType3;
            boolean bl3 = false;
            TreeNode treeNode2 = TreeUtil.findNodeWithObject((Object)it, (TreeModel)this.getTree().getModel(), (Object)this.getRoot());
            if (treeNode2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)treeNode2, (String)"TreeUtil.findNodeWithObj\u2026ee.model, root) ?: return");
            TreeNode treeNode3 = node2 = treeNode2;
            if (treeNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            this.expandTemplatesNode((DefaultMutableTreeNode)treeNode3);
        }
    }

    private final void expandTemplatesNode(DefaultMutableTreeNode templatesNode) {
        TreePath treePath = TreeUtil.getPath((TreeNode)this.getRoot(), (TreeNode)templatesNode);
        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"TreeUtil.getPath(root, templatesNode)");
        TreePath path2 = treePath;
        this.getTree().expandPath(path2);
        TreeUtil.selectInTree((DefaultMutableTreeNode)templatesNode, (boolean)true, (JTree)((JTree)this.getTree()));
        this.getTree().scrollPathToVisible(path2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addRunConfigurationsToModel(@NotNull DefaultMutableTreeNode model2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        ExtensionPointName extensionPointName = ConfigurationType.CONFIGURATION_TYPE_EP;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ConfigurationType.CONFIGURATION_TYPE_EP");
        List list2 = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ConfigurationType.CONFIG\u2026ION_TYPE_EP.extensionList");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfigurationType it = (ConfigurationType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof VirtualConfigurationType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            ConfigurationType type;
            ConfigurationType configurationType = type = (ConfigurationType)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"type");
            ConfigurationFactory[] configurationFactories = configurationType.getConfigurationFactories();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            this.getRoot().add(typeNode);
            if (configurationFactories.length == 1) continue;
            for (ConfigurationFactory factory2 : configurationFactories) {
                typeNode.add(new DefaultMutableTreeNode(factory2));
            }
        }
    }

    @Override
    public void apply() {
        this.applyTemplates();
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JComponent component2 = super.createComponent();
        JLabel label2 = new JLabel(ExecutionBundle.message((String)"templates.disclaimer", (Object[])new Object[0]));
        label2.setBorder(JBUI.Borders.empty((int)10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)label2, "West");
        panel2.setBorder(IdeBorderFactory.createBorder((int)8));
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        panel2.setBackground(editorColorsManager.getGlobalScheme().getColor(HintUtil.PROMOTION_PANE_KEY));
        JComponent jComponent = component2;
        Intrinsics.checkNotNull((Object)jComponent);
        jComponent.add((Component)panel2, "North");
        return component2;
    }

    @Override
    @NotNull
    protected JComponent createLeftPanel() {
        JComponent leftPanel = super.createLeftPanel();
        leftPanel.setMinimumSize(new Dimension(250, 100));
        return leftPanel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = ExecutionBundle.message((String)"configurable.name.run.debug.configuration.templates", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecutionBundle.message(\u2026configuration.templates\")");
        return string;
    }

    public RunConfigurationTemplatesConfigurable(@NotNull Project project, @Nullable ConfigurationType configurationType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, null, 2, null);
        this.configurationType = configurationType;
    }
}

