/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.application.Topics;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runToolbar.ActiveListener;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarSlotManager;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarComponentService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "extraSlots", "Lcom/intellij/execution/runToolbar/RunToolbarSlotManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "isRelevant", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "processNotStarted", "", "env", "start", "terminated", "terminating", "Companion", "intellij.platform.execution.impl"})
public final class RunToolbarComponentService {
    private final RunToolbarSlotManager extraSlots;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final void start(ExecutionEnvironment env) {
        if (this.isRelevant(env)) {
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                StringBuilder stringBuilder = new StringBuilder().append("new active: ");
                Executor executor = env.getExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
                LOG.info(stringBuilder.append(executor.getId()).append(' ').append(env).append(", slot manager ").append(this.extraSlots.getActive$intellij_platform_execution_impl() ? "ENABLED" : "DISABLED").append(" RunToolbar").toString());
            }
            if (this.extraSlots.getActive$intellij_platform_execution_impl()) {
                this.extraSlots.processStarted$intellij_platform_execution_impl(env);
            }
        }
    }

    private final void processNotStarted(ExecutionEnvironment env) {
        if (RunToolbarDataKt.getRunToolbarProcess(env) != null) {
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                StringBuilder stringBuilder = new StringBuilder().append("Not started: ");
                Executor executor = env.getExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
                LOG.info(stringBuilder.append(executor.getId()).append(' ').append(env).append(" RunToolbar").toString());
            }
            if (this.extraSlots.getActive$intellij_platform_execution_impl()) {
                this.extraSlots.processNotStarted$intellij_platform_execution_impl(env);
            }
        }
    }

    private final void terminated(ExecutionEnvironment env) {
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            StringBuilder stringBuilder = new StringBuilder().append("removed: ");
            Executor executor = env.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
            LOG.info(stringBuilder.append(executor.getId()).append(' ').append(env).append(", slot manager ").append(this.extraSlots.getActive$intellij_platform_execution_impl() ? "ENABLED" : "DISABLED").append(" RunToolbar").toString());
        }
        if (this.extraSlots.getActive$intellij_platform_execution_impl()) {
            this.extraSlots.processTerminated(env.getExecutionId());
        }
    }

    private final void terminating(ExecutionEnvironment env) {
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            StringBuilder stringBuilder = new StringBuilder().append("terminating: ");
            Executor executor = env.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
            LOG.info(stringBuilder.append(executor.getId()).append(' ').append(env).append(", slot manager ").append(this.extraSlots.getActive$intellij_platform_execution_impl() ? "ENABLED" : "DISABLED").append(" RunToolbar").toString());
        }
        if (this.extraSlots.getActive$intellij_platform_execution_impl()) {
            if (this.isRelevant(env)) {
                this.extraSlots.processTerminating(env);
            } else {
                this.extraSlots.processTerminated(env.getExecutionId());
            }
        }
    }

    private final boolean isRelevant(ExecutionEnvironment environment2) {
        return environment2.getContentToReuse() != null && RunToolbarDataKt.getRunToolbarProcess(environment2) != null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RunToolbarComponentService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.extraSlots = RunToolbarSlotManager.Companion.getInstance(this.project);
        if (RunToolbarProcess.Companion.isAvailable()) {
            Topics.subscribe((Topic)ExecutionManager.EXECUTION_TOPIC, (Disposable)((Disposable)this.project), (Object)new ExecutionListener(){

                public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                    Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                    Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, env){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ ExecutionEnvironment $env;

                        public final void run() {
                            if (Intrinsics.areEqual((Object)this.$env.getProject(), (Object)this.this$0.this.getProject())) {
                                RunToolbarComponentService.access$processNotStarted(this.this$0.this, this.$env);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$env = executionEnvironment;
                        }
                    });
                }

                public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                    Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                    Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, env){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ ExecutionEnvironment $env;

                        public final void run() {
                            if (Intrinsics.areEqual((Object)this.$env.getProject(), (Object)this.this$0.this.getProject())) {
                                RunToolbarComponentService.access$start(this.this$0.this, this.$env);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$env = executionEnvironment;
                        }
                    });
                }

                public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                    Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                    Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, env){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ ExecutionEnvironment $env;

                        public final void run() {
                            if (Intrinsics.areEqual((Object)this.$env.getProject(), (Object)this.this$0.this.getProject())) {
                                RunToolbarComponentService.access$terminating(this.this$0.this, this.$env);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$env = executionEnvironment;
                        }
                    });
                }

                public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                    Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                    Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, env){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ ExecutionEnvironment $env;

                        public final void run() {
                            if (Intrinsics.areEqual((Object)this.$env.getProject(), (Object)this.this$0.this.getProject())) {
                                RunToolbarComponentService.access$terminated(this.this$0.this, this.$env);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$env = executionEnvironment;
                        }
                    });
                }
            });
            this.extraSlots.addListener$intellij_platform_execution_impl(new ActiveListener(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void enabled() {
                    ExecutionEnvironment it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = ExecutionManagerImpl.Companion.getAllDescriptors(this.getProject());
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        ExecutionEnvironment executionEnvironment;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        RunContentDescriptor it2 = (RunContentDescriptor)element$iv$iv;
                        boolean bl2 = false;
                        if (RunToolbarDataKt.environment(it2) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        ExecutionEnvironment it$iv$iv = executionEnvironment;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ExecutionEnvironment)element$iv$iv;
                        boolean bl = false;
                        RunContentDescriptor runContentDescriptor = it.getContentToReuse();
                        if (!(runContentDescriptor != null && (runContentDescriptor = runContentDescriptor.getProcessHandler()) != null && !runContentDescriptor.isProcessTerminated())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List environments = (List)destination$iv$iv;
                    if (RunToolbarProcess.Companion.getLogNeeded()) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        $this$filter$iv = environments;
                        StringBuilder stringBuilder = new StringBuilder().append("ENABLED. put data ");
                        Logger logger = LOG;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (ExecutionEnvironment)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it + " (" + it.getExecutionId() + "); ";
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv;
                        logger.info(stringBuilder.append(collection).append(" RunToolbar").toString());
                    }
                    Iterable $this$forEach$iv = environments;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ExecutionEnvironment it3 = (ExecutionEnvironment)element$iv;
                        boolean bl = false;
                        extraSlots.processStarted$intellij_platform_execution_impl(it3);
                    }
                }

                @Override
                public void disabled() {
                    if (RunToolbarProcess.Companion.getLogNeeded()) {
                        LOG.info("DISABLED RunToolbar");
                    }
                    ActiveListener.DefaultImpls.disabled(this);
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RunToolbarComponentService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(RunTo\u2026onentService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$processNotStarted(RunToolbarComponentService $this, ExecutionEnvironment env) {
        $this.processNotStarted(env);
    }

    public static final /* synthetic */ void access$start(RunToolbarComponentService $this, ExecutionEnvironment env) {
        $this.start(env);
    }

    public static final /* synthetic */ void access$terminating(RunToolbarComponentService $this, ExecutionEnvironment env) {
        $this.terminating(env);
    }

    public static final /* synthetic */ void access$terminated(RunToolbarComponentService $this, ExecutionEnvironment env) {
        $this.terminated(env);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarComponentService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

