/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ \u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001d\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017J%\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/runToolbar/WaitingForAProcesses;", "", "()V", "executorId", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "subSettingsList", "", "checkAndUpdate", "", "checkAndUpdate$intellij_platform_execution_impl", "clear", "", "clear$intellij_platform_execution_impl", "collect", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isWaitingForASingleProcess", "isWaitingForASingleProcess$intellij_platform_execution_impl", "isWaitingForASubProcess", "isWaitingForASubProcess$intellij_platform_execution_impl", "start", "start$intellij_platform_execution_impl", "intellij.platform.execution.impl"})
public final class WaitingForAProcesses {
    private String executorId;
    private RunnerAndConfigurationSettings settings;
    private final List<RunnerAndConfigurationSettings> subSettingsList;

    public final boolean isWaitingForASingleProcess$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettings settings, @NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        return Intrinsics.areEqual((Object)executorId, (Object)this.executorId) && Intrinsics.areEqual((Object)settings, (Object)this.settings) && this.subSettingsList.isEmpty();
    }

    public final boolean isWaitingForASubProcess$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettings settings, @NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        return this.subSettingsList.contains(settings) && Intrinsics.areEqual((Object)executorId, (Object)this.executorId);
    }

    public final void start$intellij_platform_execution_impl(@NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, @NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        this.clear$intellij_platform_execution_impl();
        this.executorId = executorId;
        this.settings = settings;
        if (settings.getConfiguration() instanceof CompoundRunConfiguration) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"settings.configuration");
            this.collect(project, runConfiguration, settings);
        }
    }

    public final void clear$intellij_platform_execution_impl() {
        this.settings = null;
        this.executorId = null;
        this.subSettingsList.clear();
    }

    public final boolean checkAndUpdate$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettings settings, @NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        if (Intrinsics.areEqual((Object)executorId, (Object)this.executorId) ^ true) {
            return false;
        }
        if (this.subSettingsList.remove(settings)) {
            if (this.subSettingsList.isEmpty()) {
                this.clear$intellij_platform_execution_impl();
            }
            return true;
        }
        return false;
    }

    private final void collect(Project project, RunConfiguration configuration2, RunnerAndConfigurationSettings settings) {
        if (configuration2 instanceof CompoundRunConfiguration) {
            RunManager runManager = RunManager.Companion.getInstance(project);
            for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets()) {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings;
                RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                if (runManager.findSettings(subConfiguration) == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
                boolean bl3 = false;
                this.collect(project, subConfiguration, it);
            }
        } else {
            this.subSettingsList.add(settings);
        }
    }

    public WaitingForAProcesses() {
        boolean bl = false;
        this.subSettingsList = new ArrayList();
    }
}

