/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class ProjectStartupRunner
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(ProjectStartupRunner.class);

    ProjectStartupRunner() {
    }

    public void runActivity(@NotNull Project project) {
        ProjectStartupTaskManager projectStartupTaskManager;
        if (project == null) {
            ProjectStartupRunner.$$$reportNull$$$0(0);
        }
        if ((projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project)).isEmpty()) {
            return;
        }
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                projectStartupTaskManager.delete(settings.getUniqueID());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StartupManager.getInstance((Project)project).runAfterOpened(() -> ProjectStartupRunner.runActivities(project));
    }

    private static void runActivities(@NotNull Project project) {
        if (project == null) {
            ProjectStartupRunner.$$$reportNull$$$0(1);
        }
        if (!TrustedProjects.isTrusted(project)) {
            return;
        }
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        ApplicationManager.getApplication().invokeLater(() -> {
            long pause2 = 0L;
            Alarm alarm2 = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            for (RunnerAndConfigurationSettings configuration2 : configurations) {
                if (!ProjectStartupRunner.canBeRun(configuration2)) {
                    ProjectStartupRunner.showNotification(project, ExecutionBundle.message((String)"project.startup.runner.notification.can.not.be.started", (Object[])new Object[]{configuration2.getName()}));
                    return;
                }
                try {
                    alarm2.addRequest((Runnable)new MyExecutor(executor, configuration2, alarm2), pause2);
                }
                catch (ExecutionException e) {
                    ProjectStartupRunner.showNotification(project, e.getMessage());
                }
                pause2 = 300L;
            }
        }, project.getDisposed());
    }

    private static void showNotification(Project project, @Nls String text2) {
        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification(ExecutionBundle.message((String)"project.startup.runner.notification", (Object[])new Object[]{text2}), MessageType.ERROR).notify(project);
    }

    public static boolean canBeRun(@NotNull RunnerAndConfigurationSettings configuration2) {
        if (configuration2 == null) {
            ProjectStartupRunner.$$$reportNull$$$0(2);
        }
        return ProgramRunner.getRunner((String)"Run", (RunProfile)configuration2.getConfiguration()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/startup/ProjectStartupRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivities";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyExecutor
    implements Runnable {
        public static final int ATTEMPTS = 10;
        private final ExecutionEnvironment myEnvironment;
        @NotNull
        private final Alarm myAlarm;
        private final Project myProject;
        private int myCnt;
        private static final long PAUSE = 300L;
        private final String myName;

        MyExecutor(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings configuration2, @NotNull Alarm alarm2) throws ExecutionException {
            if (executor == null) {
                MyExecutor.$$$reportNull$$$0(0);
            }
            if (configuration2 == null) {
                MyExecutor.$$$reportNull$$$0(1);
            }
            if (alarm2 == null) {
                MyExecutor.$$$reportNull$$$0(2);
            }
            this.myCnt = 10;
            this.myName = configuration2.getName();
            this.myProject = configuration2.getConfiguration().getProject();
            this.myAlarm = alarm2;
            this.myEnvironment = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration2).contentToReuse(null).dataContext(null).activeTarget().build();
        }

        @Override
        public void run() {
            if (ExecutionManager.getInstance((Project)this.myProject).isStarting(this.myEnvironment)) {
                if (this.myCnt <= 0) {
                    ProjectStartupRunner.showNotification(this.myProject, ExecutionBundle.message((String)"project.startup.runner.notification.not.started", (Object[])new Object[]{this.myName, 10}));
                    return;
                }
                --this.myCnt;
                this.myAlarm.addRequest((Runnable)this, 300L);
            }
            LOG.info("Starting startup task '" + this.myName + "'");
            ProgramRunnerUtil.executeConfiguration(this.myEnvironment, true, true);
            if (this.myAlarm.isEmpty()) {
                Disposer.dispose((Disposable)this.myAlarm);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "alarm";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/startup/ProjectStartupRunner$MyExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

