/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.testframework.FailedTestsNavigator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.execution.testframework.ToggleModelActionProvider;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.execution.testframework.actions.TestTreeExpander;
import com.intellij.execution.testframework.autotest.AdjustAutotestDelayActionGroup;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.DumbAwareToggleInvertedBooleanProperty;
import com.intellij.util.config.ToggleBooleanProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolbarPanel
extends JPanel
implements OccurenceNavigator,
Disposable {
    private static final Logger LOG = Logger.getInstance(ToolbarPanel.class);
    protected final TestTreeExpander myTreeExpander = new TestTreeExpander();
    protected final FailedTestsNavigator myOccurenceNavigator;
    protected final ScrollToTestSourceAction myScrollToSource;
    @Nullable
    private ExportTestResultsAction myExportAction;
    private final ArrayList<ToggleModelAction> myActions = new ArrayList();

    public ToolbarPanel(TestConsoleProperties properties2, JComponent parent) {
        super(new BorderLayout());
        RunProfile configuration2;
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.addAction((AnAction)new DumbAwareToggleInvertedBooleanProperty(ExecutionBundle.message((String)"junit.run.hide.passed.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.run.hide.passed.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.ShowPassed, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.HIDE_PASSED_TESTS));
        actionGroup2.add((AnAction)new DumbAwareToggleInvertedBooleanProperty(TestRunnerBundle.message("action.show.ignored.text", new Object[0]), TestRunnerBundle.message("action.show.ignored.description", new Object[0]), AllIcons.RunConfigurations.ShowIgnored, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.HIDE_IGNORED_TEST));
        actionGroup2.addSeparator();
        boolean isNewLayout = Registry.is((String)"debugger.new.tool.window.layout");
        DefaultActionGroup sortGroup = !isNewLayout ? actionGroup2 : DefaultActionGroup.createPopupGroup(() -> ExecutionBundle.message((String)"junit.runing.info.sort.group.name", (Object[])new Object[0]));
        DumbAwareToggleBooleanProperty suitesAlwaysOnTop = new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.folders.on.top.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.folders.on.top.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.SUITES_ALWAYS_ON_TOP);
        if (isNewLayout) {
            sortGroup.addAction((AnAction)suitesAlwaysOnTop);
        }
        sortGroup.addAction((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.sort.alphabetically.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.sort.alphabetically.action.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.SORT_ALPHABETICALLY));
        SortByDurationAction sortByStatistics = new SortByDurationAction(properties2);
        this.myActions.add(sortByStatistics);
        sortGroup.addAction((AnAction)sortByStatistics);
        if (isNewLayout) {
            sortGroup.getTemplatePresentation().setIcon(sortByStatistics.getTemplatePresentation().getIcon());
            actionGroup2.add((AnAction)sortGroup);
        } else {
            actionGroup2.addSeparator();
        }
        DefaultActionGroup moreGroup = isNewLayout ? new MoreActionGroup() : actionGroup2;
        AnAction action2 = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.myTreeExpander, parent);
        action2.getTemplatePresentation().setDescription(ExecutionBundle.messagePointer((String)"junit.runing.info.expand.test.action.name", (Object[])new Object[0]));
        moreGroup.add(action2);
        action2 = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, parent);
        action2.getTemplatePresentation().setDescription(ExecutionBundle.messagePointer((String)"junit.runing.info.collapse.test.action.name", (Object[])new Object[0]));
        moreGroup.add(action2);
        moreGroup.addSeparator();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        this.myOccurenceNavigator = new FailedTestsNavigator();
        moreGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        moreGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        for (AnAction[] actionProvider : ToggleModelActionProvider.EP_NAME.getExtensionList()) {
            ToggleModelAction toggleModelAction = actionProvider.createToggleModelAction(properties2);
            this.myActions.add(toggleModelAction);
            actionGroup2.add((AnAction)toggleModelAction);
        }
        AnAction[] importActions = properties2.createImportActions();
        if (importActions != null) {
            for (AnAction importAction : importActions) {
                if (importAction.getTemplatePresentation().getClientProperty(RunTab.PREFERRED_PLACE) == PreferredPlace.TOOLBAR) {
                    actionGroup2.add(importAction);
                    continue;
                }
                moreGroup.add(importAction);
            }
        }
        if ((configuration2 = properties2.getConfiguration()) instanceof RunConfiguration) {
            this.myExportAction = ExportTestResultsAction.create(properties2.getExecutor().getToolWindowId(), (RunConfiguration)configuration2, parent);
            moreGroup.addAction((AnAction)this.myExportAction);
        }
        DefaultActionGroup secondaryGroup = new DefaultActionGroup();
        secondaryGroup.setPopup(true);
        secondaryGroup.getTemplatePresentation().setText(ExecutionBundle.message((String)"junit.runing.info.test.runner.options.group.name", (Object[])new Object[0]));
        secondaryGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.track.test.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.track.test.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.TRACK_RUNNING_TEST));
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(TestRunnerBundle.message("action.show.inline.statistics.text", new Object[0]), TestRunnerBundle.message("action.toggle.visibility.test.duration.in.tree.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.SHOW_INLINE_STATISTICS));
        if (!isNewLayout) {
            secondaryGroup.add((AnAction)suitesAlwaysOnTop);
        }
        secondaryGroup.addSeparator();
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.scroll.to.stacktrace.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.scroll.to.stacktrace.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.SCROLL_TO_STACK_TRACE));
        secondaryGroup.add((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.open.source.at.exception.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.open.source.at.exception.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.OPEN_FAILURE_LINE));
        this.myScrollToSource = new ScrollToTestSourceAction(properties2);
        secondaryGroup.add((AnAction)this.myScrollToSource);
        secondaryGroup.add((AnAction)new AdjustAutotestDelayActionGroup(parent));
        secondaryGroup.addSeparator();
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.select.first.failed.action.name", (Object[])new Object[0]), null, null, (AbstractProperty.AbstractPropertyContainer)properties2, TestConsoleProperties.SELECT_FIRST_DEFECT));
        properties2.appendAdditionalActions(secondaryGroup, parent, properties2);
        moreGroup.addSeparator();
        moreGroup.add((AnAction)secondaryGroup);
        if (isNewLayout) {
            actionGroup2.add((AnAction)moreGroup);
            actionGroup2 = new RunTab.ToolbarActionGroup((ActionGroup)actionGroup2);
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TestTreeViewToolbar", (ActionGroup)actionGroup2, true);
        actionToolbar.setTargetComponent(parent);
        this.add((Component)actionToolbar.getComponent(), "Center");
    }

    public void setModel(TestFrameworkRunningModel model2) {
        TestFrameworkActions.installFilterAction(model2);
        this.myScrollToSource.setModel(model2);
        this.myTreeExpander.setModel(model2);
        this.myOccurenceNavigator.setModel(model2);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(model2);
        }
        for (ToggleModelAction action2 : this.myActions) {
            action2.setModel(model2);
        }
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_ALPHABETICALLY, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_BY_DURATION, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SUITES_ALWAYS_ON_TOP, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
    }

    private static TestFrameworkPropertyListener<Boolean> createComparatorPropertyListener(final TestFrameworkRunningModel model2) {
        return new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value2) {
                try {
                    AbstractTestTreeBuilderBase builder2 = (AbstractTestTreeBuilderBase)model2.getClass().getMethod("getTreeBuilder", new Class[0]).invoke((Object)model2, new Object[0]);
                    if (builder2 != null) {
                        builder2.setTestsComparator(model2);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        };
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurenceNavigator.getNextOccurenceActionName();
        if (string == null) {
            ToolbarPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurenceNavigator.getPreviousOccurenceActionName();
        if (string == null) {
            ToolbarPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void dispose() {
        this.myScrollToSource.setModel(null);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/testframework/ToolbarPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SortByDurationAction
    extends ToggleModelAction
    implements DumbAware {
        private TestFrameworkRunningModel myModel;

        SortByDurationAction(TestConsoleProperties properties2) {
            super(ExecutionBundle.message((String)"junit.runing.info.sort.by.statistics.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.sort.by.statistics.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.SortbyDuration, properties2, TestConsoleProperties.SORT_BY_DURATION);
        }

        protected boolean isEnabled() {
            TestFrameworkRunningModel model2 = this.myModel;
            return model2 != null && !model2.isRunning();
        }

        @Override
        public void setModel(TestFrameworkRunningModel model2) {
            this.myModel = model2;
        }
    }
}

