/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMStacktraceParserEx;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromFileAction;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsGroup;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleProperties
extends TestConsoleProperties
implements SMStacktraceParserEx {
    private final RunProfile myConfiguration;
    @NotNull
    private final String myTestFrameworkName;
    private final CompositeFilter myCustomFilter;
    private boolean myIdBasedTestTree;
    private boolean myPrintTestingStartedTime;

    public SMTRunnerConsoleProperties(@NotNull RunConfiguration config2, @NlsSafe @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config2 == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(2);
        }
        this(config2.getProject(), (RunProfile)config2, testFrameworkName, executor);
    }

    public SMTRunnerConsoleProperties(@NotNull Project project, @NotNull RunProfile config2, @NlsSafe @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (project == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(3);
        }
        if (config2 == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(4);
        }
        if (testFrameworkName == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(6);
        }
        super((Storage)new Storage.PropertiesComponentStorage(testFrameworkName + "Support.", PropertiesComponent.getInstance()), project, executor);
        this.myIdBasedTestTree = false;
        this.myPrintTestingStartedTime = true;
        this.myConfiguration = config2;
        this.myTestFrameworkName = testFrameworkName;
        this.myCustomFilter = new CompositeFilter(project);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean serviceMessageHasNewLinePrefix() {
        return false;
    }

    @Override
    @NotNull
    public RunProfile getConfiguration() {
        RunProfile runProfile = this.myConfiguration;
        if (runProfile == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(7);
        }
        return runProfile;
    }

    @Override
    protected AnAction @Nullable [] createImportActions() {
        return new AnAction[]{new ImportTestsGroup(this), new ImportTestsFromFileAction()};
    }

    public boolean isIdBasedTestTree() {
        return this.myIdBasedTestTree;
    }

    public void setIdBasedTestTree(boolean idBasedTestTree) {
        this.myIdBasedTestTree = idBasedTestTree;
    }

    public boolean isPrintTestingStartedTime() {
        return this.myPrintTestingStartedTime;
    }

    public void setPrintTestingStartedTime(boolean printTestingStartedTime) {
        this.myPrintTestingStartedTime = printTestingStartedTime;
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        String[] lines2;
        if (location == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(8);
        }
        if (stacktrace == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(9);
        }
        if (this.myCustomFilter.isEmpty()) {
            return null;
        }
        int stacktraceLength = stacktrace.length();
        for (String line : lines2 = StringUtil.splitByLines((String)stacktrace)) {
            HyperlinkInfo info2;
            Filter.Result result2;
            try {
                result2 = this.myCustomFilter.applyFilter(line, stacktraceLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myCustomFilter + " to '" + line + "'", t);
            }
            HyperlinkInfo hyperlinkInfo = info2 = result2 != null ? result2.getFirstHyperlinkInfo() : null;
            if (info2 == null) continue;
            if (info2 instanceof FileHyperlinkInfo) {
                return new FileHyperlinkNavigatable((FileHyperlinkInfo)info2);
            }
            final Project project = location.getProject();
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    info2.navigate(project);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }
        return null;
    }

    public void addStackTraceFilter(Filter filter) {
        this.myCustomFilter.addFilter(filter);
    }

    public boolean fixEmptySuite() {
        return false;
    }

    @Nullable
    public SMTestLocator getTestLocator() {
        return null;
    }

    @Nullable
    public TestProxyFilterProvider getFilterProvider() {
        return null;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return null;
    }

    @NotNull
    public String getTestFrameworkName() {
        String string = this.myTestFrameworkName;
        if (string == null) {
            SMTRunnerConsoleProperties.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isUndefined() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FileHyperlinkNavigatable
    implements Navigatable {
        private OpenFileDescriptor myFileDescriptor;
        private final FileHyperlinkInfo myFileHyperlinkInfo;

        public FileHyperlinkNavigatable(@NotNull FileHyperlinkInfo info2) {
            if (info2 == null) {
                FileHyperlinkNavigatable.$$$reportNull$$$0(0);
            }
            this.myFileHyperlinkInfo = info2;
        }

        public OpenFileDescriptor getOpenFileDescriptor() {
            if (this.myFileDescriptor == null) {
                this.myFileDescriptor = this.myFileHyperlinkInfo.getDescriptor();
            }
            return this.myFileDescriptor;
        }

        public void navigate(boolean requestFocus) {
            this.getOpenFileDescriptor().navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.getOpenFileDescriptor().canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.getOpenFileDescriptor().canNavigateToSource();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/execution/testframework/sm/runner/SMTRunnerConsoleProperties$FileHyperlinkNavigatable", "<init>"));
        }
    }
}

