/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsGroup
extends ActionGroup {
    private SMTRunnerConsoleProperties myProperties;

    public ImportTestsGroup() {
        super(() -> SmRunnerBundle.message("sm.test.runner.import.test.group.history", new Object[0]), () -> SmRunnerBundle.message("sm.test.runner.import.test.group.open.recent.session", new Object[0]), AllIcons.Vcs.History);
        this.setPopup(true);
        this.getTemplatePresentation().putClientProperty(RunTab.PREFERRED_PLACE, (Object)PreferredPlace.TOOLBAR);
    }

    public ImportTestsGroup(SMTRunnerConsoleProperties properties2) {
        this();
        this.myProperties = properties2;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                ImportTestsGroup.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (EMPTY_ARRAY == null) {
                ImportTestsGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        Collection<String> filePaths = TestHistoryConfiguration.getInstance(project).getFiles();
        File testHistoryRoot = TestStateStorage.getTestHistoryRoot(project);
        List fileNames = filePaths.stream().map(fileName -> new File(testHistoryRoot, (String)fileName)).filter(file2 -> file2.exists()).sorted((f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified())).collect(Collectors.toList());
        int historySize = fileNames.size();
        AnAction[] actions2 = new AnAction[historySize];
        for (int i2 = 0; i2 < historySize; ++i2) {
            actions2[i2] = new ImportTestsFromHistoryAction(project, ((File)fileNames.get(i2)).getName(), this.myProperties != null ? this.myProperties.getExecutor() : null);
        }
        if (actions2 == null) {
            ImportTestsGroup.$$$reportNull$$$0(2);
        }
        return actions2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsGroup", "getChildren"));
    }
}

