/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.google.common.net.InetAddresses;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistribution {
    public static final String DEFAULT_WSL_MNT_ROOT = "/mnt/";
    private static final int RESOLVE_SYMLINK_TIMEOUT = 10000;
    private static final String RUN_PARAMETER = "run";
    static final int DEFAULT_TIMEOUT = SystemProperties.getIntProperty((String)"ide.wsl.probe.timeout", (int)20000);
    private static final String SHELL_PARAMETER = "$SHELL";
    public static final String WSL_EXE = "wsl.exe";
    public static final String DISTRIBUTION_PARAMETER = "--distribution";
    public static final String EXIT_CODE_PARAMETER = "; exitcode=$?";
    public static final String EXEC_PARAMETER = "--exec";
    private static final Key<ProcessListener> SUDO_LISTENER_KEY = Key.create((String)"WSL sudo listener");
    private static final String RSYNC = "rsync";
    @NotNull
    private final WslDistributionDescriptor myDescriptor;
    @Nullable
    private final Path myExecutablePath;
    @Nullable
    private Integer myVersion;
    private final NullableLazyValue<String> myHostIp;
    private final NullableLazyValue<String> myWslIp;
    private final NullableLazyValue<String> myShellPath;
    private final NullableLazyValue<String> myUserHomeProvider;

    protected WSLDistribution(@NotNull WSLDistribution dist) {
        if (dist == null) {
            WSLDistribution.$$$reportNull$$$0(0);
        }
        this(dist.myDescriptor, dist.myExecutablePath);
        this.myVersion = dist.myVersion;
    }

    WSLDistribution(@NotNull WslDistributionDescriptor descriptor2, @Nullable Path executablePath) {
        if (descriptor2 == null) {
            WSLDistribution.$$$reportNull$$$0(1);
        }
        this.myHostIp = NullableLazyValue.createValue(this::readHostIp);
        this.myWslIp = NullableLazyValue.createValue(this::readWslIp);
        this.myShellPath = NullableLazyValue.createValue(this::readShellPath);
        this.myUserHomeProvider = NullableLazyValue.createValue(this::readUserHome);
        this.myDescriptor = descriptor2;
        this.myExecutablePath = executablePath;
    }

    public WSLDistribution(@NotNull String msId) {
        if (msId == null) {
            WSLDistribution.$$$reportNull$$$0(2);
        }
        this(new WslDistributionDescriptor(msId), null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public Path getExecutablePath() {
        return this.myExecutablePath;
    }

    @Nullable
    @NlsSafe
    public String readReleaseInfo() {
        try {
            String key = "PRETTY_NAME";
            String releaseInfo = "/etc/os-release";
            ProcessOutput output2 = this.executeOnWsl(10000, "cat", "/etc/os-release");
            if (WSLUtil.LOG.isDebugEnabled()) {
                WSLUtil.LOG.debug("Reading release info: " + this.getId());
            }
            if (!output2.checkSuccess(WSLUtil.LOG)) {
                return null;
            }
            for (String line : output2.getStdoutLines(true)) {
                if (!line.startsWith("PRETTY_NAME") || line.length() < "PRETTY_NAME".length() + 1) continue;
                String prettyName = line.substring("PRETTY_NAME".length() + 1);
                return StringUtil.nullize((String)StringUtil.unquoteString((String)prettyName));
            }
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn((Throwable)e);
        }
        return null;
    }

    void setVersion(@Nullable Integer version2) {
        this.myVersion = version2;
    }

    public int getVersion() {
        if (this.myVersion == null) {
            this.myVersion = WSLUtil.getWslVersion(this);
        }
        return this.myVersion;
    }

    @NotNull
    public GeneralCommandLine createWslCommandLine(String ... command) throws ExecutionException {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(3);
        }
        GeneralCommandLine generalCommandLine = this.patchCommandLine(new GeneralCommandLine(command), null, new WSLCommandLineOptions());
        if (generalCommandLine == null) {
            WSLDistribution.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    public ProcessOutput executeOnWsl(@NotNull List<String> command, @NotNull WSLCommandLineOptions options2, int timeout, @Nullable Consumer<? super ProcessHandler> processHandlerConsumer) throws ExecutionException {
        ProcessOutput output2;
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(5);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(6);
        }
        GeneralCommandLine commandLine = this.patchCommandLine(new GeneralCommandLine(command), null, options2);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(commandLine);
        if (processHandlerConsumer != null) {
            processHandlerConsumer.consume((Object)processHandler2);
        }
        if ((output2 = processHandler2.runProcess(timeout)).getExitCode() != 0 || output2.isTimeout() || output2.isCancelled()) {
            WSLUtil.LOG.info("command on wsl: " + commandLine.getCommandLineString() + " was failed:ec=" + output2.getExitCode() + ",timeout=" + output2.isTimeout() + ",cancelled=" + output2.isCancelled() + ",stderr=" + output2.getStderr() + ",stdout=" + output2.getStdout());
        }
        ProcessOutput processOutput = output2;
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(7);
        }
        return processOutput;
    }

    @NotNull
    private ProcessOutput executeOnWsl(@NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2, int timeout) throws ExecutionException {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(8);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(9);
        }
        this.patchCommandLine(commandLine, null, options2);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = processHandler2.runProcess(timeout);
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(10);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput executeOnWsl(int timeout, String ... command) throws ExecutionException {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(11);
        }
        ProcessOutput processOutput = this.executeOnWsl(Arrays.asList(command), new WSLCommandLineOptions(), timeout, null);
        if (processOutput == null) {
            WSLDistribution.$$$reportNull$$$0(12);
        }
        return processOutput;
    }

    public void copyFromWsl(@NotNull String wslPath, @NotNull String windowsPath, @Nullable List<String> additionalOptions, @Nullable Consumer<? super ProcessHandler> handlerConsumer) throws ExecutionException {
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(13);
        }
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(14);
        }
        new File(windowsPath).mkdirs();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(RSYNC, "-cr"));
        if (additionalOptions != null) {
            command.addAll(additionalOptions);
        }
        command.add(wslPath + "/");
        String targetWslPath = this.getWslPath(windowsPath);
        if (targetWslPath == null) {
            throw new ExecutionException(IdeBundle.message((String)"wsl.rsync.unable.to.copy.files.dialog.message", (Object[])new Object[]{windowsPath}));
        }
        command.add(targetWslPath + "/");
        ProcessOutput process2 = this.executeOnWsl(command, new WSLCommandLineOptions(), -1, handlerConsumer);
        if (process2.getExitCode() != 0) {
            if (this.executeOnWsl(10000, "type", RSYNC).getExitCode() != 0) {
                throw new ExecutionException(IdeBundle.message((String)"wsl.no.rsync", (Object[])new Object[]{this.myDescriptor.getMsId()}));
            }
            throw new ExecutionException(process2.getStderr());
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(@NotNull T commandLine, @Nullable Project project, @Nullable String remoteWorkingDir, boolean askForSudo) {
        T t;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(15);
        }
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setRemoteWorkingDirectory(remoteWorkingDir).setSudo(askForSudo);
        try {
            t = this.patchCommandLine(commandLine, project, options2);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot patch command line for WSL", e);
        }
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(16);
        }
        return t;
    }

    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(final @NotNull T commandLine, final @Nullable Project project, @NotNull WSLCommandLineOptions options2) throws ExecutionException {
        Path wslExe;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(17);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(18);
        }
        this.logCommandLineBefore(commandLine, options2);
        Path executable = this.getExecutablePath();
        boolean launchWithWslExe = options2.isLaunchWithWslExe() || executable == null;
        Path path2 = wslExe = launchWithWslExe ? WSLDistribution.findWslExe() : null;
        if (wslExe == null && executable == null) {
            throw new ExecutionException(IdeBundle.message((String)"wsl.not.installed.dialog.message", (Object[])new Object[0]));
        }
        boolean executeCommandInShell = wslExe == null || options2.isExecuteCommandInShell();
        List<String> linuxCommand = WSLDistribution.buildLinuxCommand(commandLine, executeCommandInShell);
        boolean isElevated = options2.isSudo();
        if (isElevated && wslExe == null) {
            WSLDistribution.prependCommand(linuxCommand, "sudo", "-S", "-p", "''");
            SUDO_LISTENER_KEY.set(commandLine, (Object)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    OutputStream input;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((input = event.getProcessHandler().getProcessInput()) == null) {
                        return;
                    }
                    String password = CredentialPromptDialog.askPassword(project, IdeBundle.message((String)"wsl.enter.root.password.dialog.title", (Object[])new Object[0]), IdeBundle.message((String)"wsl.sudo.password.for.root.label", (Object[])new Object[]{WSLDistribution.this.getPresentableName()}), new CredentialAttributes("WSL", "root", WSLDistribution.class), true);
                    if (password != null) {
                        try (PrintWriter pw = new PrintWriter(input, false, commandLine.getCharset());){
                            pw.println(password);
                        }
                    }
                    super.startNotified(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/wsl/WSLDistribution$1", "startNotified"));
                }
            });
        }
        if (executeCommandInShell && StringUtil.isNotEmpty((String)options2.getRemoteWorkingDirectory())) {
            WSLDistribution.prependCommand(linuxCommand, "cd", CommandLineUtil.posixQuote((String)options2.getRemoteWorkingDirectory()), "&&");
        }
        if (executeCommandInShell && !options2.isPassEnvVarsUsingInterop()) {
            commandLine.getEnvironment().forEach((key, val) -> WSLDistribution.prependCommand(linuxCommand, "export", CommandLineUtil.posixQuote((String)key) + "=" + CommandLineUtil.posixQuote((String)val), "&&"));
            commandLine.getEnvironment().clear();
        } else {
            WSLDistribution.passEnvironmentUsingInterop(commandLine);
        }
        if (executeCommandInShell) {
            for (String command : options2.getInitShellCommands()) {
                WSLDistribution.prependCommand(linuxCommand, command, "&&");
            }
        }
        commandLine.getParametersList().clearAll();
        Object linuxCommandStr = StringUtil.join(linuxCommand, (String)" ");
        if (wslExe != null) {
            commandLine.setExePath(wslExe.toString());
            commandLine.addParameters(new String[]{DISTRIBUTION_PARAMETER, this.getMsId()});
            if (isElevated) {
                commandLine.addParameters(new String[]{"-u", "root"});
            }
            if (options2.isExecuteCommandInShell()) {
                if (options2.getSleepTimeoutSec() > 0.0 && this.getVersion() == 1) {
                    linuxCommandStr = (String)linuxCommandStr + "; exitcode=$?; sleep " + options2.getSleepTimeoutSec() + "; (exit $exitcode)";
                }
                if (options2.isExecuteCommandInDefaultShell()) {
                    commandLine.addParameters(new String[]{SHELL_PARAMETER, "-c", linuxCommandStr});
                } else {
                    commandLine.addParameters(new String[]{EXEC_PARAMETER, options2.getShellPath()});
                    if (options2.isExecuteCommandInInteractiveShell()) {
                        commandLine.addParameters(new String[]{"-i"});
                    }
                    if (options2.isExecuteCommandInLoginShell()) {
                        commandLine.addParameters(new String[]{"-l"});
                    }
                    commandLine.addParameters(new String[]{"-c", linuxCommandStr});
                }
            } else {
                commandLine.addParameter(EXEC_PARAMETER);
                commandLine.addParameters(linuxCommand);
            }
        } else {
            commandLine.setExePath(executable.toString());
            commandLine.addParameter(this.getRunCommandLineParameter());
            commandLine.addParameter((String)linuxCommandStr);
        }
        this.logCommandLineAfter(commandLine);
        T t = commandLine;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(19);
        }
        return t;
    }

    private void logCommandLineBefore(@NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(20);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(21);
        }
        if (WSLUtil.LOG.isTraceEnabled()) {
            WSLUtil.LOG.trace("[" + this.getId() + "] Patching: " + commandLine.getCommandLineString() + "; options: " + options2 + "; envs: " + commandLine.getEnvironment());
        }
    }

    private void logCommandLineAfter(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(22);
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("[" + this.getId() + "] Patched as: " + commandLine.getCommandLineList(null));
        }
    }

    @Nullable
    public static Path findWslExe() {
        File file2 = PathEnvironmentVariableUtil.findInPath((String)WSL_EXE);
        return file2 != null ? file2.toPath() : null;
    }

    @NotNull
    private static List<String> buildLinuxCommand(@NotNull GeneralCommandLine commandLine, boolean executeCommandInShell) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(23);
        }
        List command = ContainerUtil.concat(List.of(commandLine.getExePath()), (List)commandLine.getParametersList().getList());
        return new ArrayList<String>(ContainerUtil.map((Collection)command, (Function)(executeCommandInShell ? CommandLineUtil::posixQuote : Functions.identity())));
    }

    private static void passEnvironmentUsingInterop(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(24);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String envName : commandLine.getEnvironment().keySet()) {
            if (!StringUtil.isNotEmpty((String)envName)) continue;
            if (builder2.length() > 0) {
                builder2.append(":");
            }
            builder2.append(envName).append("/u");
        }
        if (builder2.length() > 0) {
            String prevValue = (String)commandLine.getEnvironment().get("WSLENV");
            if (prevValue == null) {
                prevValue = (String)commandLine.getParentEnvironment().get("WSLENV");
            }
            String value2 = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ":" + builder2 : builder2.toString();
            commandLine.getEnvironment().put("WSLENV", value2);
        }
    }

    @NotNull
    @NlsSafe
    protected String getRunCommandLineParameter() {
        return RUN_PARAMETER;
    }

    @NotNull
    @NlsSafe
    public String resolveSymlink(@NotNull String path2, int timeoutInMilliseconds) {
        block5: {
            String string;
            if (path2 == null) {
                WSLDistribution.$$$reportNull$$$0(25);
            }
            try {
                ProcessOutput output2 = this.executeOnWsl(timeoutInMilliseconds, "readlink", "-f", path2);
                if (output2.getExitCode() != 0) break block5;
                String stdout = output2.getStdout().trim();
                if (output2.getExitCode() != 0 || !StringUtil.isNotEmpty((String)stdout)) break block5;
                string = stdout;
            }
            catch (ExecutionException e) {
                WSLUtil.LOG.debug("Error while resolving symlink: " + path2, (Throwable)e);
            }
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String resolveSymlink(@NotNull String path2) {
        if (path2 == null) {
            WSLDistribution.$$$reportNull$$$0(28);
        }
        String string = this.resolveSymlink(path2, 10000);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public <T extends ProcessHandler> T patchProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull T processHandler2) {
        ProcessListener listener2;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(30);
        }
        if (processHandler2 == null) {
            WSLDistribution.$$$reportNull$$$0(31);
        }
        if ((listener2 = (ProcessListener)SUDO_LISTENER_KEY.get((UserDataHolder)commandLine)) != null) {
            processHandler2.addProcessListener(listener2);
            SUDO_LISTENER_KEY.set((UserDataHolder)commandLine, null);
        }
        T t = processHandler2;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(32);
        }
        return t;
    }

    @Nullable
    public Map<String, String> getEnvironment() {
        try {
            ProcessOutput processOutput = this.executeOnWsl(Collections.singletonList("env"), new WSLCommandLineOptions().setExecuteCommandInShell(true).setExecuteCommandInLoginShell(true).setExecuteCommandInInteractiveShell(true), 5000, null);
            if (processOutput.getExitCode() == 0) {
                HashMap<String, String> result2 = new HashMap<String, String>();
                for (String string : processOutput.getStdoutLines()) {
                    int assignIndex = string.indexOf(61);
                    if (assignIndex == -1) {
                        result2.put(string, "");
                        continue;
                    }
                    result2.put(string.substring(0, assignIndex), string.substring(assignIndex + 1));
                }
                return result2;
            }
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn((Throwable)e);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath;
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(33);
        }
        if ((windowsPath = WSLUtil.getWindowsPath(wslPath, this.getMntRoot())) != null) {
            String string = windowsPath;
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = this.getUNCRoot() + FileUtil.toSystemDependentName((String)FileUtil.normalize((String)wslPath));
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getWslPath(@NotNull String windowsPath) {
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(36);
        }
        if (FileUtil.toSystemDependentName((String)windowsPath).startsWith("\\\\wsl$\\")) {
            int index2 = (windowsPath = StringUtil.trimStart((String)FileUtil.toSystemDependentName((String)windowsPath), (String)"\\\\wsl$\\")).indexOf(92);
            if (index2 == -1) {
                return null;
            }
            String distName = windowsPath.substring(0, index2);
            if (!distName.equalsIgnoreCase(this.myDescriptor.getMsId())) {
                throw new IllegalArgumentException("Trying to get WSL path from a different WSL distribution: in path: " + distName + "; mine is: " + this.myDescriptor.getMsId());
            }
            return FileUtil.toSystemIndependentName((String)windowsPath.substring(index2));
        }
        if (FileUtil.isWindowsAbsolutePath((String)windowsPath)) {
            return this.getMntRoot() + WSLDistribution.convertWindowsPath(windowsPath);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public final String getMntRoot() {
        String string = this.myDescriptor.getMntRoot();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public final String getUserHome() {
        return (String)this.myUserHomeProvider.getValue();
    }

    @NlsSafe
    @Nullable
    private String readUserHome() {
        return this.getEnvironmentVariable("HOME");
    }

    @NotNull
    @NlsSafe
    static String convertWindowsPath(@NotNull String windowsAbsolutePath) {
        if (windowsAbsolutePath == null) {
            WSLDistribution.$$$reportNull$$$0(38);
        }
        String string = Character.toLowerCase(windowsAbsolutePath.charAt(0)) + FileUtil.toSystemIndependentName((String)windowsAbsolutePath.substring(2));
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = this.myDescriptor.getId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMsId() {
        String string = this.myDescriptor.getMsId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = this.myDescriptor.getPresentableName();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(42);
        }
        return string;
    }

    public String toString() {
        return this.myDescriptor.getMsId();
    }

    private static void prependCommand(@NotNull List<? super String> command, String ... commandToPrepend) {
        if (command == null) {
            WSLDistribution.$$$reportNull$$$0(43);
        }
        if (commandToPrepend == null) {
            WSLDistribution.$$$reportNull$$$0(44);
        }
        command.addAll(0, Arrays.asList(commandToPrepend));
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getMsId().equals(((WSLDistribution)o).getMsId());
    }

    public int hashCode() {
        return Strings.stringHashCodeInsensitive((CharSequence)this.getMsId());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    public File getUNCRoot() {
        return new File("\\\\wsl$\\" + this.myDescriptor.getMsId());
    }

    @ApiStatus.Experimental
    @NotNull
    public Path getUNCRootPath() {
        Path path2 = Paths.get("\\\\wsl$\\" + this.myDescriptor.getMsId(), new String[0]);
        if (path2 == null) {
            WSLDistribution.$$$reportNull$$$0(45);
        }
        return path2;
    }

    @ApiStatus.Experimental
    @Nullable
    public VirtualFile getUNCRootVirtualFile(boolean refreshIfNeed) {
        if (!Experiments.getInstance().isFeatureEnabled("wsl.p9.support")) {
            return null;
        }
        File uncRoot = this.getUNCRoot();
        return uncRoot.exists() ? VfsUtil.findFileByIoFile((File)uncRoot, (boolean)refreshIfNeed) : null;
    }

    public String getHostIp() {
        return (String)this.myHostIp.getValue();
    }

    public String getWslIp() {
        return (String)this.myWslIp.getValue();
    }

    public InetAddress getHostIpAddress() {
        return InetAddresses.forString((String)this.getHostIp());
    }

    public InetAddress getWslIpAddress() {
        return InetAddresses.forString((String)this.getWslIp());
    }

    @Nullable
    private String readHostIp() {
        ProcessOutput output2;
        String wsl1LoopbackAddress = this.getWsl1LoopbackAddress();
        if (wsl1LoopbackAddress != null) {
            return wsl1LoopbackAddress;
        }
        if (Registry.is((String)"wsl.obtain.windows.host.ip.alternatively", (boolean)true)) {
            InetAddress wslAddr = this.getWslIpAddress();
            DatagramSocket datagramSocket = new DatagramSocket();
            try {
                datagramSocket.connect(wslAddr, 0);
                String string = datagramSocket.getLocalAddress().getHostAddress();
                datagramSocket.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        datagramSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WSLUtil.LOG.error("Cannot obtain Windows host IP alternatively: failed to connect to WSL IP " + wslAddr + ". Fallback to default way.", (Throwable)e);
                }
            }
        }
        String releaseInfo = "/etc/resolv.conf";
        try {
            output2 = this.executeOnWsl(List.of("cat", "/etc/resolv.conf"), new WSLCommandLineOptions(), 10000, null);
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.info("Cannot read host ip", (Throwable)e);
            return null;
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("Reading release info: " + this.getId());
        }
        if (!output2.checkSuccess(WSLUtil.LOG)) {
            return null;
        }
        for (String line : output2.getStdoutLines(true)) {
            if (!line.startsWith("nameserver")) continue;
            return line.substring("nameserver".length()).trim();
        }
        return null;
    }

    @Nullable
    private String readWslIp() {
        ProcessOutput output2;
        String wsl1LoopbackAddress = this.getWsl1LoopbackAddress();
        if (wsl1LoopbackAddress != null) {
            return wsl1LoopbackAddress;
        }
        try {
            output2 = this.executeOnWsl(List.of("ip", "addr", "show", "eth0"), new WSLCommandLineOptions(), 10000, null);
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.info("Cannot read wsl ip", (Throwable)e);
            return null;
        }
        if (WSLUtil.LOG.isDebugEnabled()) {
            WSLUtil.LOG.debug("Reading eth0 info: " + this.getId());
        }
        if (!output2.checkSuccess(WSLUtil.LOG)) {
            return null;
        }
        for (String line : output2.getStdoutLines(true)) {
            int index2;
            String trimmed = line.trim();
            if (!trimmed.startsWith("inet ") || (index2 = trimmed.indexOf("/")) == -1) continue;
            return trimmed.substring("inet ".length(), index2);
        }
        return null;
    }

    @Nullable
    private String getWsl1LoopbackAddress() {
        return this.getVersion() == 1 ? InetAddress.getLoopbackAddress().getHostAddress() : null;
    }

    @NonNls
    @Nullable
    public String getEnvironmentVariable(String name2) {
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setExecuteCommandInInteractiveShell(true).setExecuteCommandInLoginShell(true).setShellPath(this.getShellPath());
        return this.executeInShellAndGetCommandOnlyStdout(new GeneralCommandLine(new String[]{"printenv", name2}), options2, DEFAULT_TIMEOUT, true);
    }

    @NlsSafe
    @NotNull
    public String getShellPath() {
        String string = (String)ObjectUtils.notNull((Object)((String)this.myShellPath.getValue()), (Object)"/bin/sh");
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    private String readShellPath() {
        WSLCommandLineOptions options2 = new WSLCommandLineOptions().setExecuteCommandInDefaultShell(true);
        return this.executeInShellAndGetCommandOnlyStdout(new GeneralCommandLine(new String[]{"printenv", "SHELL"}), options2, DEFAULT_TIMEOUT, true);
    }

    @NotNull
    ProcessOutput executeInShellAndGetCommandOnlyStdout(@NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2, int timeout) throws ExecutionException {
        String markerText;
        ProcessOutput output2;
        String stdout;
        int index2;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(47);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(48);
        }
        if (!options2.isExecuteCommandInShell()) {
            throw new AssertionError((Object)"Execution in shell is expected");
        }
        String prefixText = "intellij: executing command...";
        options2.addInitCommand("echo " + CommandLineUtil.posixQuote((String)prefixText));
        if (options2.isExecuteCommandInInteractiveShell()) {
            commandLine.getEnvironment().put("DISABLE_AUTO_UPDATE", "true");
            options2.setPassEnvVarsUsingInterop(true);
        }
        if ((index2 = (stdout = (output2 = this.executeOnWsl(commandLine, options2, timeout)).getStdout()).indexOf(markerText = prefixText + LineSeparator.LF.getSeparatorString())) < 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isInternal() || application.isUnitTestMode()) {
                WSLUtil.LOG.error("Cannot find '" + prefixText + "' in stdout: " + output2);
            } else {
                WSLUtil.LOG.info("Cannot find '" + prefixText + "' in stdout");
            }
            ProcessOutput processOutput = output2;
            if (processOutput == null) {
                WSLDistribution.$$$reportNull$$$0(49);
            }
            return processOutput;
        }
        return new ProcessOutput(stdout.substring(index2 + markerText.length()), output2.getStderr(), output2.getExitCode(), output2.isTimeout(), output2.isCancelled());
    }

    @Nullable
    String executeInShellAndGetCommandOnlyStdout(@NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2, int timeout, boolean expectOneLineStdout) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(50);
        }
        if (options2 == null) {
            WSLDistribution.$$$reportNull$$$0(51);
        }
        try {
            ProcessOutput output2 = this.executeInShellAndGetCommandOnlyStdout(commandLine, options2, timeout);
            String stdout = output2.getStdout();
            if (!output2.isTimeout() && output2.getExitCode() == 0) {
                return expectOneLineStdout ? this.expectOneLineOutput(commandLine, stdout) : stdout;
            }
            WSLUtil.LOG.info("Failed to execute " + commandLine + " for " + this.getMsId() + ": exitCode=" + output2.getExitCode() + ", timeout=" + output2.isTimeout() + ", stdout=" + stdout + ", stderr=" + output2.getStderr());
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.info("Failed to execute " + commandLine + " for " + this.getMsId(), (Throwable)e);
        }
        return null;
    }

    @NotNull
    private String expectOneLineOutput(@NotNull GeneralCommandLine commandLine, @NotNull String stdout) {
        String converted;
        List lines2;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(52);
        }
        if (stdout == null) {
            WSLDistribution.$$$reportNull$$$0(53);
        }
        if ((lines2 = StringUtil.split((String)(converted = StringUtil.convertLineSeparators((String)stdout, (String)LineSeparator.LF.getSeparatorString())), (String)LineSeparator.LF.getSeparatorString(), (boolean)true, (boolean)true)).size() != 1) {
            WSLUtil.LOG.info("One line stdout expected: " + this.getMsId() + ", command=" + commandLine + ", stdout=" + stdout + ", lines=" + lines2.size());
        }
        String string = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)lines2)), (String)stdout);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(54);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 6: 
            case 9: 
            case 18: 
            case 21: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 14: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsAbsolutePath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandToPrepend";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslCommandLine";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnWsl";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "patchProcessHandler";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWindowsPath";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getUNCRootPath";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInShellAndGetCommandOnlyStdout";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "expectOneLineOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWslCommandLine";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 54: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeOnWsl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyFromWsl";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "logCommandLineBefore";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "logCommandLineAfter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildLinuxCommand";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "passEnvironmentUsingInterop";
                break;
            }
            case 25: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "patchProcessHandler";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getWslPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "convertWindowsPath";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "prependCommand";
                break;
            }
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "executeInShellAndGetCommandOnlyStdout";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "expectOneLineOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 49: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

