/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionAndVersion;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WslDistributionManager
implements Disposable {
    static final Logger LOG = Logger.getInstance(WslDistributionManager.class);
    private static final Object LOCK = new Object();
    private volatile CachedDistributions myInstalledDistributions;
    private volatile List<WSLDistribution> myLastInstalledDistributions;
    private final Map<String, WSLDistribution> myMsIdToDistributionCache = CollectionFactory.createConcurrentWeakCaseInsensitiveMap();

    @NotNull
    public static WslDistributionManager getInstance() {
        WslDistributionManager wslDistributionManager = (WslDistributionManager)ApplicationManager.getApplication().getService(WslDistributionManager.class);
        if (wslDistributionManager == null) {
            WslDistributionManager.$$$reportNull$$$0(0);
        }
        return wslDistributionManager;
    }

    public void dispose() {
        this.myMsIdToDistributionCache.clear();
        this.myInstalledDistributions = null;
    }

    @Nullable
    public List<WSLDistribution> getCachedInstalledDistributions() {
        return this.getInstalledDistributionsFuture().getNow(null);
    }

    @Nullable
    public List<WSLDistribution> getLastInstalledDistributions() {
        return this.myLastInstalledDistributions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<WSLDistribution> getInstalledDistributions() {
        if (!this.isAvailable()) {
            List<WSLDistribution> list2 = List.of();
            if (list2 == null) {
                WslDistributionManager.$$$reportNull$$$0(1);
            }
            return list2;
        }
        CachedDistributions cachedDistributions = this.myInstalledDistributions;
        if (cachedDistributions != null && cachedDistributions.isUpToDate()) {
            List<WSLDistribution> list3 = cachedDistributions.myInstalledDistributions;
            if (list3 == null) {
                WslDistributionManager.$$$reportNull$$$0(2);
            }
            return list3;
        }
        this.myInstalledDistributions = null;
        Object object = LOCK;
        synchronized (object) {
            cachedDistributions = this.myInstalledDistributions;
            if (cachedDistributions == null) {
                this.myInstalledDistributions = cachedDistributions = new CachedDistributions(this.loadInstalledDistributions());
                this.myLastInstalledDistributions = cachedDistributions.myInstalledDistributions;
            }
        }
        List<WSLDistribution> list4 = cachedDistributions.myInstalledDistributions;
        if (list4 == null) {
            WslDistributionManager.$$$reportNull$$$0(3);
        }
        return list4;
    }

    @NotNull
    public CompletableFuture<List<WSLDistribution>> getInstalledDistributionsFuture() {
        if (!this.isAvailable()) {
            CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.completedFuture(List.of());
            if (completableFuture == null) {
                WslDistributionManager.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CachedDistributions cachedDistributions = this.myInstalledDistributions;
        if (cachedDistributions != null && cachedDistributions.isUpToDate()) {
            CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.completedFuture(cachedDistributions.myInstalledDistributions);
            if (completableFuture == null) {
                WslDistributionManager.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        CompletableFuture<List<WSLDistribution>> completableFuture = CompletableFuture.supplyAsync(this::getInstalledDistributions, AppExecutorUtil.getAppExecutorService());
        if (completableFuture == null) {
            WslDistributionManager.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    protected boolean isAvailable() {
        return WSLUtil.isSystemCompatible();
    }

    @NotNull
    public WSLDistribution getOrCreateDistributionByMsId(@NonNls @NotNull String msId) {
        if (msId == null) {
            WslDistributionManager.$$$reportNull$$$0(7);
        }
        return this.getOrCreateDistributionByMsId(msId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private WSLDistribution getOrCreateDistributionByMsId(@NonNls @NotNull String msId, boolean overrideCaseInsensitively) {
        if (msId == null) {
            WslDistributionManager.$$$reportNull$$$0(8);
        }
        if (msId.isEmpty()) {
            throw new IllegalArgumentException("WSL msId is empty");
        }
        WSLDistribution d = this.myMsIdToDistributionCache.get(msId);
        if (d == null || overrideCaseInsensitively && !d.getMsId().equals(msId)) {
            Map<String, WSLDistribution> map2 = this.myMsIdToDistributionCache;
            synchronized (map2) {
                d = this.myMsIdToDistributionCache.get(msId);
                if (d == null || overrideCaseInsensitively && !d.getMsId().equals(msId)) {
                    d = new WSLDistribution(msId);
                    this.myMsIdToDistributionCache.put(msId, d);
                }
            }
        }
        WSLDistribution wSLDistribution = d;
        if (wSLDistribution == null) {
            WslDistributionManager.$$$reportNull$$$0(9);
        }
        return wSLDistribution;
    }

    public static boolean isWslPath(@NotNull String path2) {
        if (path2 == null) {
            WslDistributionManager.$$$reportNull$$$0(10);
        }
        return FileUtilRt.toSystemDependentName((String)path2).startsWith("\\\\wsl$\\");
    }

    @NotNull
    private List<WSLDistribution> loadInstalledDistributions() {
        WSLUtil.WSLToolFlags wslTool;
        int releaseId = WSLUtil.getWindowsReleaseId();
        if (releaseId > 0 && releaseId < 2004 && ((wslTool = WSLUtil.getWSLToolFlags()) == null || !wslTool.isVerboseFlagAvailable && !wslTool.isQuietFlagAvailable)) {
            List<WSLDistribution> list2 = WSLUtil.getAvailableDistributions();
            if (list2 == null) {
                WslDistributionManager.$$$reportNull$$$0(11);
            }
            return list2;
        }
        if (Registry.is((String)"wsl.list.prefer.verbose.output", (boolean)true)) {
            List list3;
            try {
                List<WslDistributionAndVersion> result2 = this.loadInstalledDistributionsWithVersions();
                list3 = ContainerUtil.map(result2, data2 -> {
                    WSLDistribution distribution2 = this.getOrCreateDistributionByMsId(data2.getDistributionName(), true);
                    distribution2.setVersion(data2.getVersion());
                    return distribution2;
                });
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.error((Throwable)e);
            }
            if (list3 == null) {
                WslDistributionManager.$$$reportNull$$$0(12);
            }
            return list3;
        }
        List list4 = ContainerUtil.map(this.loadInstalledDistributionMsIds(), msId -> this.getOrCreateDistributionByMsId((String)msId, true));
        if (list4 == null) {
            WslDistributionManager.$$$reportNull$$$0(13);
        }
        return list4;
    }

    @NotNull
    protected abstract List<String> loadInstalledDistributionMsIds();

    @NotNull
    public abstract List<WslDistributionAndVersion> loadInstalledDistributionsWithVersions() throws IOException, IllegalStateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionManager";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributionsFuture";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDistributionByMsId";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstalledDistributions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDistributionByMsId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWslPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedDistributions {
        @NotNull
        private final List<WSLDistribution> myInstalledDistributions;
        private final long myExternalChangesCount;

        private CachedDistributions(@NotNull List<WSLDistribution> installedDistributions) {
            if (installedDistributions == null) {
                CachedDistributions.$$$reportNull$$$0(0);
            }
            this.myInstalledDistributions = List.copyOf(installedDistributions);
            this.myExternalChangesCount = CachedDistributions.getCurrentExternalChangesCount();
        }

        public boolean isUpToDate() {
            return CachedDistributions.getCurrentExternalChangesCount() == this.myExternalChangesCount;
        }

        private static long getCurrentExternalChangesCount() {
            return SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedDistributions", "com/intellij/execution/wsl/WslDistributionManager$CachedDistributions", "<init>"));
        }
    }
}

