/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginEnabler;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class CheckRequiredPluginsActivity
implements StartupActivity.RequiredForSmartMode {
    private static final Logger LOG = Logger.getInstance(CheckRequiredPluginsActivity.class);
    @NonNls
    private static final String NOTIFICATION_GROUP_ID = "Required Plugins";
    @NonNls
    private static final String ENABLE = "enable";
    @NonNls
    private static final String INSTALL = "install";

    CheckRequiredPluginsActivity() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(0);
        }
        ExternalDependenciesManager.getInstance(project);
    }

    public static void runCheck(@NotNull Project project, @NotNull ExternalDependenciesManager dependencyManager) {
        String target2;
        List<DependencyOnPlugin> dependencies2;
        if (project == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(1);
        }
        if (dependencyManager == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(2);
        }
        if ((dependencies2 = dependencyManager.getDependencies(DependencyOnPlugin.class)).isEmpty()) {
            return;
        }
        String projectName = project.getName();
        ArrayList<@Nls String> errorMessages = new ArrayList<String>();
        ArrayList<IdeaPluginDescriptorImpl> disabled = new ArrayList<IdeaPluginDescriptorImpl>();
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        ArrayList<IdeaPluginDescriptorImpl> pluginsToEnableWithoutRestart = new ArrayList<IdeaPluginDescriptorImpl>();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        ProjectPluginTracker pluginTracker = DynamicPluginEnabler.findPluginTracker(project, pluginEnabler);
        for (DependencyOnPlugin dependency : dependencies2) {
            PluginId pluginId = PluginId.getId((String)dependency.getPluginId());
            IdeaPluginDescriptorImpl descriptor2 = PluginManagerCore.findPlugin(pluginId);
            if (descriptor2 == null) {
                errorMessages.add(IdeBundle.message((String)"error.plugin.required.for.project.not.installed", (Object[])new Object[]{pluginId, projectName}));
                notInstalled.add(pluginId);
                continue;
            }
            String pluginName = descriptor2.getName();
            if (pluginEnabler.isDisabled(pluginId) || pluginTracker != null && pluginTracker.isDisabled(pluginId)) {
                boolean canEnableWithoutRestart;
                boolean bl = canEnableWithoutRestart = Registry.is((String)"ide.plugins.load.automatically") && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2);
                if (canEnableWithoutRestart) {
                    pluginsToEnableWithoutRestart.add(descriptor2);
                    continue;
                }
                errorMessages.add(IdeBundle.message((String)"error.plugin.required.for.project.disabled", (Object[])new Object[]{pluginName, projectName}));
                disabled.add(descriptor2);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            String maxVersion = dependency.getMaxVersion();
            String pluginVersion = descriptor2.getVersion();
            BuildNumber currentIdeVersion = applicationInfo.getBuild();
            if (descriptor2.isBundled() && !descriptor2.allowBundledUpdate() && currentIdeVersion.asStringWithoutProductCode().equals(pluginVersion)) {
                Object pluginFromString;
                Object object = pluginFromString = PluginManagerCore.CORE_ID.equals((Object)descriptor2.getPluginId()) ? "" : "plugin '" + pluginName + "' from ";
                if (minVersion != null && currentIdeVersion.compareTo(BuildNumber.fromString((String)minVersion)) < 0) {
                    errorMessages.add(IdeBundle.message((String)"error.project.requires.newer.ide", (Object[])new Object[]{projectName, pluginFromString, minVersion, pluginVersion}));
                }
                if (maxVersion == null || currentIdeVersion.compareTo(BuildNumber.fromString((String)maxVersion)) <= 0) continue;
                errorMessages.add(IdeBundle.message((String)"error.project.requires.older.ide", (Object[])new Object[]{projectName, pluginFromString, maxVersion, pluginVersion}));
                continue;
            }
            if (minVersion != null && VersionComparatorUtil.compare((String)pluginVersion, (String)minVersion) < 0) {
                errorMessages.add(IdeBundle.message((String)"error.project.requires.newer.plugin", (Object[])new Object[]{projectName, pluginName, minVersion, pluginVersion}));
            }
            if (maxVersion == null || VersionComparatorUtil.compare((String)pluginVersion, (String)maxVersion) <= 0) continue;
            errorMessages.add(IdeBundle.message((String)"error.project.requires.older.plugin", (Object[])new Object[]{projectName, pluginName, maxVersion, pluginVersion}));
        }
        if (!pluginsToEnableWithoutRestart.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> CheckRequiredPluginsActivity.enablePlugins(pluginsToEnableWithoutRestart, pluginEnabler));
        }
        if (errorMessages.isEmpty()) {
            return;
        }
        Object object = notInstalled.isEmpty() ? (disabled.isEmpty() ? null : ENABLE) : (target2 = INSTALL);
        if (target2 != null) {
            String text2 = INSTALL.equals(target2) ? IdeBundle.message((String)"link.install.required.plugins", (Object[])new Object[0]) : (disabled.size() == 1 ? IdeBundle.message((String)"link.enable.required.plugin", (Object[])new Object[]{((IdeaPluginDescriptor)disabled.get(0)).getName()}) : IdeBundle.message((String)"link.enable.required.plugins", (Object[])new Object[0]));
            errorMessages.add(HtmlChunk.link((String)target2, (String)text2).toString());
        }
        NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID).createNotification(IdeBundle.message((String)"notification.title.required.plugins.not.loaded", (Object[])new Object[0]), StringUtil.join(errorMessages, (String)"<br>"), NotificationType.ERROR).setListener(notInstalled.isEmpty() ? CheckRequiredPluginsActivity.createEnableNotificationListener(project, disabled, pluginEnabler) : CheckRequiredPluginsActivity.createInstallNotificationListener(project, notInstalled, disabled)).notify(project);
    }

    private static boolean enablePlugins(@NotNull List<? extends IdeaPluginDescriptor> descriptors, @NotNull PluginEnabler pluginEnabler) {
        if (descriptors == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(3);
        }
        if (pluginEnabler == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(4);
        }
        LOG.info("Required plugins to enable: [" + StringUtil.join(descriptors, d -> d.getPluginId().getIdString(), (String)", ") + "]");
        return pluginEnabler.enable(descriptors);
    }

    @NotNull
    private static NotificationListener createEnableNotificationListener(@NotNull Project project, @NotNull List<? extends IdeaPluginDescriptor> disabled, @NotNull PluginEnabler pluginEnabler) {
        if (project == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(5);
        }
        if (disabled == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(6);
        }
        if (pluginEnabler == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(7);
        }
        NotificationListener notificationListener = (notification, event) -> {
            if (!CheckRequiredPluginsActivity.isApplicable(event, ENABLE)) {
                return;
            }
            notification.expire();
            if (!CheckRequiredPluginsActivity.enablePlugins(disabled, pluginEnabler)) {
                PluginManagerMain.notifyPluginsUpdated(project);
            }
        };
        if (notificationListener == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(8);
        }
        return notificationListener;
    }

    @NotNull
    private static NotificationListener createInstallNotificationListener(@NotNull Project project, @NotNull Set<PluginId> notInstalled, @NotNull List<? extends IdeaPluginDescriptor> disabled) {
        if (project == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(9);
        }
        if (notInstalled == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(10);
        }
        if (disabled == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(11);
        }
        HashSet<PluginId> pluginIds2 = new HashSet<PluginId>(notInstalled);
        pluginIds2.addAll(notInstalled);
        for (IdeaPluginDescriptor ideaPluginDescriptor : disabled) {
            pluginIds2.add(ideaPluginDescriptor.getPluginId());
        }
        NotificationListener notificationListener = (notification, event) -> {
            if (!CheckRequiredPluginsActivity.isApplicable(event, INSTALL)) {
                return;
            }
            PluginsAdvertiser.installAndEnable(project, pluginIds2, true, true, () -> notification.expire());
        };
        if (notificationListener == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(12);
        }
        return notificationListener;
    }

    private static boolean isApplicable(@NotNull HyperlinkEvent event, @NotNull @NonNls String description) {
        if (event == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(13);
        }
        if (description == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(14);
        }
        return HyperlinkEvent.EventType.ACTIVATED == event.getEventType() && description.equals(event.getDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabled";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notInstalled";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnableNotificationListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstallNotificationListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runCheck";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEnableNotificationListener";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createInstallNotificationListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

