/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.feedback;

import com.intellij.feedback.FeedbackTypeResolver;
import com.intellij.feedback.bundle.FeedbackBundle;
import com.intellij.feedback.dialog.ProjectCreationFeedbackDialog;
import com.intellij.feedback.notification.RequestFeedbackNotification;
import com.intellij.feedback.state.projectCreation.ProjectCreationInfoService;
import com.intellij.feedback.state.projectCreation.ProjectCreationInfoState;
import com.intellij.feedback.statistics.ProjectCreationFeedbackCountCollector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0004J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bH$J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\bH$J\b\u0010\u0010\u001a\u00020\bH\u0004J\b\u0010\u0011\u001a\u00020\bH&J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\bJ\b\u0010\u0014\u001a\u00020\u0013H$R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/feedback/FeedbackTypes;", "", "(Ljava/lang/String;I)V", "suitableIdeVersion", "", "getSuitableIdeVersion", "()Ljava/lang/String;", "checkIdeVersionIsSuitable", "", "createFeedbackDialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "createNotification", "Lcom/intellij/notification/Notification;", "isIntellijIdeaEAP", "isSuitable", "showNotification", "", "updateStateAfterNotificationShowed", "PROJECT_CREATION_FEEDBACK", "intellij.platform.feedback"})
public abstract class FeedbackTypes
extends Enum<FeedbackTypes> {
    public static final /* enum */ FeedbackTypes PROJECT_CREATION_FEEDBACK;
    private static final /* synthetic */ FeedbackTypes[] $VALUES;

    static {
        FeedbackTypes[] feedbackTypesArray = new FeedbackTypes[1];
        FeedbackTypes[] feedbackTypesArray2 = feedbackTypesArray;
        feedbackTypesArray[0] = PROJECT_CREATION_FEEDBACK = new PROJECT_CREATION_FEEDBACK("PROJECT_CREATION_FEEDBACK", 0);
        $VALUES = feedbackTypesArray;
    }

    @NotNull
    protected abstract String getSuitableIdeVersion();

    public abstract boolean isSuitable();

    protected final boolean isIntellijIdeaEAP() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        return applicationInfoEx.isEAP();
    }

    protected final boolean checkIdeVersionIsSuitable() {
        String string = this.getSuitableIdeVersion();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        return Intrinsics.areEqual((Object)string, (Object)applicationInfoEx.getShortVersion());
    }

    @NotNull
    protected abstract Notification createNotification(boolean var1);

    @NotNull
    protected abstract DialogWrapper createFeedbackDialog(@Nullable Project var1, boolean var2);

    protected abstract void updateStateAfterNotificationShowed();

    public final void showNotification(@Nullable Project project, boolean forTest) {
        Notification notification = this.createNotification(forTest);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)FeedbackBundle.message("notification.request.feedback.action.respond.text", new Object[0]), (Runnable)new Runnable(this, forTest, project){
            final /* synthetic */ FeedbackTypes this$0;
            final /* synthetic */ boolean $forTest;
            final /* synthetic */ Project $project;

            public final void run() {
                if (!this.$forTest) {
                    ProjectCreationFeedbackCountCollector.Companion.logNotificationActionCalled();
                }
                DialogWrapper dialog2 = this.this$0.createFeedbackDialog(this.$project, this.$forTest);
                dialog2.show();
                if (!this.$forTest && dialog2.getExitCode() == 1) {
                    ProjectCreationFeedbackCountCollector.Companion.logDialogClosed();
                }
            }
            {
                this.this$0 = feedbackTypes;
                this.$forTest = bl;
                this.$project = project;
            }
        }));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)FeedbackBundle.message("notification.request.feedback.action.dont.show.text", new Object[0]), (Runnable)new Runnable(forTest){
            final /* synthetic */ boolean $forTest;

            public final void run() {
                if (!this.$forTest) {
                    FeedbackTypeResolver.INSTANCE.setFeedbackNotificationEnabled(false);
                }
            }
            {
                this.$forTest = bl;
            }
        }));
        notification.notify(project);
        this.updateStateAfterNotificationShowed();
    }

    public static /* synthetic */ void showNotification$default(FeedbackTypes feedbackTypes, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        feedbackTypes.showNotification(project, bl);
    }

    private FeedbackTypes() {
    }

    public /* synthetic */ FeedbackTypes(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static FeedbackTypes[] values() {
        return (FeedbackTypes[])$VALUES.clone();
    }

    public static FeedbackTypes valueOf(String string) {
        return Enum.valueOf(FeedbackTypes.class, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000bH\u0014J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/feedback/FeedbackTypes$PROJECT_CREATION_FEEDBACK;", "Lcom/intellij/feedback/FeedbackTypes;", "maxNumberNotificationShowed", "", "suitableIdeVersion", "", "getSuitableIdeVersion", "()Ljava/lang/String;", "testProjectTypeName", "unknownProjectTypeName", "checkNotificationNumberNotExceeded", "", "state", "Lcom/intellij/feedback/state/projectCreation/ProjectCreationInfoState;", "checkProjectCreated", "checkProjectCreationFeedbackNotSent", "createFeedbackDialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "createNotification", "Lcom/intellij/notification/Notification;", "getLastCreatedProjectTypeName", "isSuitable", "updateStateAfterNotificationShowed", "", "intellij.platform.feedback"})
    static final class PROJECT_CREATION_FEEDBACK
    extends FeedbackTypes {
        private final String unknownProjectTypeName;
        private final String testProjectTypeName;
        private final int maxNumberNotificationShowed;
        @NotNull
        private final String suitableIdeVersion;

        @Override
        @NotNull
        protected String getSuitableIdeVersion() {
            return this.suitableIdeVersion;
        }

        @Override
        public boolean isSuitable() {
            ProjectCreationInfoState projectCreationInfoState = ProjectCreationInfoService.Companion.getInstance().getState();
            return this.isIntellijIdeaEAP() && this.checkIdeVersionIsSuitable() && this.checkProjectCreationFeedbackNotSent(projectCreationInfoState) && this.checkProjectCreated(projectCreationInfoState) && this.checkNotificationNumberNotExceeded(projectCreationInfoState);
        }

        private final boolean checkProjectCreationFeedbackNotSent(ProjectCreationInfoState state) {
            return !state.getFeedbackSent();
        }

        private final boolean checkProjectCreated(ProjectCreationInfoState state) {
            return state.getLastCreatedProjectBuilderId() != null;
        }

        private final boolean checkNotificationNumberNotExceeded(ProjectCreationInfoState state) {
            return state.getNumberNotificationShowed() < this.maxNumberNotificationShowed;
        }

        @Override
        @NotNull
        protected Notification createNotification(boolean forTest) {
            return new RequestFeedbackNotification();
        }

        @Override
        @NotNull
        protected DialogWrapper createFeedbackDialog(@Nullable Project project, boolean forTest) {
            return new ProjectCreationFeedbackDialog(project, this.getLastCreatedProjectTypeName(forTest));
        }

        private final String getLastCreatedProjectTypeName(boolean forTest) {
            if (forTest) {
                return this.testProjectTypeName;
            }
            ProjectCreationInfoState projectCreationInfoState = ProjectCreationInfoService.Companion.getInstance().getState();
            String string = projectCreationInfoState.getLastCreatedProjectBuilderId();
            if (string == null) {
                string = this.unknownProjectTypeName;
            }
            return string;
        }

        @Override
        protected void updateStateAfterNotificationShowed() {
            ProjectCreationInfoState projectCreationInfoState;
            ProjectCreationInfoState projectCreationInfoState2 = projectCreationInfoState = ProjectCreationInfoService.Companion.getInstance().getState();
            projectCreationInfoState2.setNumberNotificationShowed(projectCreationInfoState2.getNumberNotificationShowed() + 1);
        }

        /*
         * WARNING - void declaration
         */
        PROJECT_CREATION_FEEDBACK() {
            void var1_1;
            this.unknownProjectTypeName = "UNKNOWN";
            this.testProjectTypeName = "TEST";
            this.maxNumberNotificationShowed = 3;
            this.suitableIdeVersion = "2022.1";
        }
    }
}

