/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindUsagesStatisticsCollector;
import com.intellij.find.findUsages.PersistentFindUsagesOptions;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFindUsagesDialog
extends DialogWrapper {
    private final Project myProject;
    protected final FindUsagesOptions myFindUsagesOptions;
    private final boolean myToShowInNewTab;
    private final boolean myIsShowInNewTabEnabled;
    private final boolean myIsShowInNewTabVisible;
    private final boolean mySearchForTextOccurrencesAvailable;
    private final boolean mySearchInLibrariesAvailable;
    private JCheckBox myCbToOpenInNewTab;
    protected StateRestoringCheckBox myCbToSearchForTextOccurrences;
    protected JCheckBox myCbToSkipResultsWhenOneUsage;
    private ScopeChooserCombo myScopeCombo;
    private int myFindOptionsCount;

    protected AbstractFindUsagesDialog(@NotNull Project project, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, boolean searchForTextOccurrencesAvailable, boolean searchInLibrariesAvailable) {
        if (project == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(0);
        }
        if (findUsagesOptions == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myFindUsagesOptions = findUsagesOptions;
        this.myToShowInNewTab = toShowInNewTab;
        this.myIsShowInNewTabEnabled = !mustOpenInNewTab && UsageViewContentManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        this.myIsShowInNewTabVisible = !isSingleFile;
        this.mySearchForTextOccurrencesAvailable = searchForTextOccurrencesAvailable;
        this.mySearchInLibrariesAvailable = searchInLibrariesAvailable;
        if (this.myFindUsagesOptions instanceof PersistentFindUsagesOptions) {
            ((PersistentFindUsagesOptions)this.myFindUsagesOptions).setDefaults(this.myProject);
        }
        this.setOKButtonText(FindBundle.message("find.dialog.find.button", new Object[0]));
        this.setTitle(FindBundle.message(isSingleFile ? "find.usages.in.file.dialog.title" : "find.usages.dialog.title", new Object[0]));
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected boolean isInFileOnly() {
        return !this.myIsShowInNewTabVisible;
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.fill = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 17;
        SimpleColoredComponent coloredComponent = new SimpleColoredComponent();
        coloredComponent.setIpad((Insets)JBUI.emptyInsets());
        coloredComponent.setMyBorder(null);
        this.configureLabelComponent(coloredComponent);
        panel2.add((Component)coloredComponent, gbConstraints);
        return panel2;
    }

    public abstract void configureLabelComponent(@NotNull SimpleColoredComponent var1);

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel allOptionsPanel = this.createAllOptionsPanel();
        if (allOptionsPanel != null) {
            panel2.add((Component)allOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        if (this.myIsShowInNewTabVisible) {
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.myCbToOpenInNewTab.setSelected(this.myToShowInNewTab);
            this.myCbToOpenInNewTab.setEnabled(this.myIsShowInNewTabEnabled);
            panel2.add((Component)this.myCbToOpenInNewTab, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)0, (int)13, (int)0), 0, 0));
        }
        return panel2;
    }

    @NotNull
    public final FindUsagesOptions calcFindUsagesOptions() {
        this.calcFindUsagesOptions(this.myFindUsagesOptions);
        if (this.myFindUsagesOptions instanceof PersistentFindUsagesOptions) {
            ((PersistentFindUsagesOptions)this.myFindUsagesOptions).storeDefaults(this.myProject);
        }
        FindUsagesStatisticsCollector.logOptions(this.myProject, this.myFindUsagesOptions, this.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = this.myFindUsagesOptions;
        if (findUsagesOptions == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(3);
        }
        return findUsagesOptions;
    }

    protected void init() {
        super.init();
        this.update();
    }

    public void calcFindUsagesOptions(FindUsagesOptions options2) {
        options2.searchScope = this.myScopeCombo == null || this.myScopeCombo.getSelectedScope() == null ? GlobalSearchScope.allScope((Project)this.myProject) : this.myScopeCombo.getSelectedScope();
        options2.isSearchForTextOccurrences = AbstractFindUsagesDialog.isToChange(this.myCbToSearchForTextOccurrences) && AbstractFindUsagesDialog.isSelected(this.myCbToSearchForTextOccurrences);
    }

    protected void update() {
    }

    boolean isShowInSeparateWindow() {
        return this.myCbToOpenInNewTab != null && this.myCbToOpenInNewTab.isSelected();
    }

    private boolean isSkipResultsWhenOneUsage() {
        return this.myCbToSkipResultsWhenOneUsage != null && this.myCbToSkipResultsWhenOneUsage.isSelected();
    }

    protected void doOKAction() {
        if (!this.shouldDoOkAction()) {
            return;
        }
        FindSettings settings = FindSettings.getInstance();
        if (this.myScopeCombo != null) {
            settings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
        }
        if (this.mySearchForTextOccurrencesAvailable && this.myCbToSearchForTextOccurrences != null && this.myCbToSearchForTextOccurrences.isEnabled()) {
            this.myFindUsagesOptions.isSearchForTextOccurrences = this.myCbToSearchForTextOccurrences.isSelected();
        }
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            settings.setSkipResultsWithOneUsage(this.isSkipResultsWhenOneUsage());
        }
        super.doOKAction();
    }

    protected boolean shouldDoOkAction() {
        return this.myScopeCombo == null || this.myScopeCombo.getSelectedScope() != null;
    }

    protected static boolean isToChange(JCheckBox cb2) {
        return cb2 != null && cb2.getParent() != null;
    }

    protected static boolean isSelected(JCheckBox cb2) {
        return cb2 != null && cb2.getParent() != null && cb2.isSelected();
    }

    protected StateRestoringCheckBox addCheckboxToPanel(@NlsContexts.Checkbox String name2, boolean toSelect2, JPanel panel2, boolean toUpdate) {
        StateRestoringCheckBox cb2 = this.createCheckbox(name2, toSelect2, toUpdate);
        JPanel decoratedCheckbox = new ComponentPanelBuilder((JComponent)cb2).createPanel();
        decoratedCheckbox.setAlignmentX(0.0f);
        decoratedCheckbox.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        panel2.add(decoratedCheckbox);
        return cb2;
    }

    protected StateRestoringCheckBox createCheckbox(@NlsContexts.Checkbox String name2, boolean toSelect2, boolean toUpdate) {
        StateRestoringCheckBox cb2 = new StateRestoringCheckBox(name2);
        cb2.setSelected(toSelect2);
        cb2.setAlignmentX(0.0f);
        if (toUpdate) {
            cb2.addActionListener(___ -> this.update());
        }
        ++this.myFindOptionsCount;
        return cb2;
    }

    protected JPanel createAllOptionsPanel() {
        JComponent scopePanel;
        JPanel findWhatPanel = this.createFindWhatPanel();
        if (findWhatPanel != null) {
            this.addUsagesOptions(findWhatPanel);
            if (this.myFindOptionsCount > 2) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)new Title(FindBundle.message("find.what.group", new Object[0]), (Border)JBUI.Borders.empty((int)4, (int)0, (int)8, (int)0), null), "North");
                findWhatPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)17));
                panel2.add((Component)findWhatPanel, "Center");
                findWhatPanel = panel2;
            }
        }
        if ((scopePanel = this.createSearchScopePanel()) != null) {
            JPanel panel3 = new JPanel(new BorderLayout());
            if (findWhatPanel != null) {
                panel3.add((Component)findWhatPanel, "North");
                scopePanel.setBorder((Border)JBUI.Borders.emptyTop((int)9));
            }
            panel3.add((Component)scopePanel, "South");
            return panel3;
        }
        if (findWhatPanel != null && this.myFindOptionsCount <= 2) {
            findWhatPanel.setBorder((Border)JBUI.Borders.emptyTop((int)9));
        }
        return findWhatPanel;
    }

    @Nullable
    protected JPanel createFindWhatPanel() {
        if (this.mySearchForTextOccurrencesAvailable || this.myIsShowInNewTabVisible) {
            JPanel findWhatPanel = new JPanel();
            findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
            return findWhatPanel;
        }
        return null;
    }

    protected void addUsagesOptions(JPanel panel2) {
        if (this.mySearchForTextOccurrencesAvailable) {
            this.myCbToSearchForTextOccurrences = this.addCheckboxToPanel(FindBundle.message("find.options.search.for.text.occurrences.checkbox", new Object[0]), this.myFindUsagesOptions.isSearchForTextOccurrences, panel2, false);
        }
        if (this.myIsShowInNewTabVisible) {
            this.myCbToSkipResultsWhenOneUsage = this.addCheckboxToPanel(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0]), FindSettings.getInstance().isSkipResultsWithOneUsage(), panel2, false);
        }
    }

    @Nullable
    private JComponent createSearchScopePanel() {
        if (this.isInFileOnly()) {
            return null;
        }
        JPanel optionsPanel = new JPanel(new BorderLayout());
        String scope2 = this.myFindUsagesOptions.searchScope.getDisplayName();
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, this.mySearchInLibrariesAvailable, true, scope2);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        optionsPanel.add((Component)((Object)this.myScopeCombo), "Center");
        Title scopeTitle = new Title(FindBundle.message("find.scope.label", new Object[0]), (Border)JBUI.Borders.emptyBottom((int)4), (JComponent)this.myScopeCombo.getComboBox());
        optionsPanel.add((Component)scopeTitle, "North");
        return optionsPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusedControl() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myScopeCombo != null) {
            return this.myScopeCombo.getComboBox();
        }
        return this.getPreferredFocusedControl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/AbstractFindUsagesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/AbstractFindUsagesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TitleLabel
    extends JBLabel {
        private @NlsContexts.Separator String originalText;

        private TitleLabel(@NlsContexts.Separator String text2, @Nullable JComponent labelFor) {
            this.originalText = text2;
            this.setLabelFor(labelFor);
            this.updateLabelFont();
        }

        public void updateUI() {
            super.updateUI();
            this.updateLabelFont();
        }

        @NlsContexts.Separator
        public String getText() {
            return this.originalText;
        }

        public void setText(@NlsContexts.Separator String text2) {
            this.originalText = text2;
            super.setText(text2 != null && text2.startsWith("<html>") ? text2 : UIUtil.replaceMnemonicAmpersand((String)this.originalText));
        }

        private void updateLabelFont() {
            Font labelFont = StartupUiUtil.getLabelFont();
            this.setFont(RelativeFont.NORMAL.fromResource("TitledSeparator.fontSizeOffset", 0).derive(labelFont));
        }
    }

    private static class Title
    extends JPanel {
        private Title(@NlsContexts.Separator String text2, @NotNull Border border, @Nullable JComponent labelFor) {
            if (border == null) {
                Title.$$$reportNull$$$0(0);
            }
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(border);
            this.setAlignmentX(0.0f);
            this.add((Component)((Object)new TitleLabel(text2, labelFor)));
            this.add(Box.createVerticalGlue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "border", "com/intellij/find/findUsages/AbstractFindUsagesDialog$Title", "<init>"));
        }
    }
}

