/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class BlockIndentOptions {
    private final CodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
    private final int myRightMargin;

    public BlockIndentOptions(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, Block block) {
        if (settings == null) {
            BlockIndentOptions.$$$reportNull$$$0(0);
        }
        if (indentOptions == null) {
            BlockIndentOptions.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
        this.myIndentOptions = indentOptions;
        this.myRightMargin = this.calcRightMargin(block);
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull AbstractBlockWrapper block) {
        CommonCodeStyleSettings commonSettings;
        CommonCodeStyleSettings.IndentOptions result2;
        if (block == null) {
            BlockIndentOptions.$$$reportNull$$$0(2);
        }
        if (this.myIndentOptions.isOverrideLanguageOptions()) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myIndentOptions;
            if (indentOptions == null) {
                BlockIndentOptions.$$$reportNull$$$0(3);
            }
            return indentOptions;
        }
        Language language2 = block.getLanguage();
        if (language2 != null && (result2 = (commonSettings = this.mySettings.getCommonSettings(language2)).getIndentOptions()) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = result2;
            if (indentOptions == null) {
                BlockIndentOptions.$$$reportNull$$$0(4);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.myIndentOptions;
        if (indentOptions == null) {
            BlockIndentOptions.$$$reportNull$$$0(5);
        }
        return indentOptions;
    }

    public int getRightMargin() {
        return this.myRightMargin;
    }

    private int calcRightMargin(Block rootBlock) {
        PsiFile psiFile;
        PsiElement psiElement;
        ASTNode node2;
        Language language2 = null;
        if (rootBlock instanceof ASTBlock && (node2 = ((ASTBlock)rootBlock).getNode()) != null && (psiElement = node2.getPsi()).isValid() && (psiFile = psiElement.getContainingFile()) != null) {
            language2 = psiFile.getViewProvider().getBaseLanguage();
        }
        return this.mySettings.getRightMargin(language2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/engine/BlockIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/engine/BlockIndentOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

