/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FormattingServiceUtil {
    private static final Logger LOG = Logger.getInstance(FormattingServiceUtil.class);

    private FormattingServiceUtil() {
    }

    @NotNull
    public static FormattingService findService(@NotNull PsiFile file2, boolean isExplicit, boolean isCompleteFile) {
        FormattingService formattingService;
        if (file2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((formattingService = (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> !(!s.canFormat(file2) || !isExplicit && !s.getFeatures().contains(FormattingService.Feature.AD_HOC_FORMATTING) || !isCompleteFile && !s.getFeatures().contains(FormattingService.Feature.FORMAT_FRAGMENTS)))) != null, (Object)("At least 1 formatting service which can handle PsiFile " + file2.getName() + " should be registered."));
        FormattingService formattingService2 = formattingService;
        if (formattingService2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(1);
        }
        return formattingService2;
    }

    @Nullable
    public static FormattingService findService(Class<? extends FormattingService> serviceClass) {
        return (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> s.getClass().equals(serviceClass));
    }

    @NotNull
    public static FormattingService findImportsOptimizingService(@NotNull PsiFile file2) {
        FormattingService importsOptimizer;
        if (file2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((importsOptimizer = (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> s.canFormat(file2) && s.getFeatures().contains(FormattingService.Feature.OPTIMIZE_IMPORTS))) != null, (Object)("At least 1 formatting service which can optimize imports in PsiFile " + file2.getName() + " should be registered."));
        FormattingService formattingService = importsOptimizer;
        if (formattingService == null) {
            FormattingServiceUtil.$$$reportNull$$$0(3);
        }
        return formattingService;
    }

    private static List<FormattingService> getChainedServices(@NotNull FormattingService formattingService) {
        if (formattingService == null) {
            FormattingServiceUtil.$$$reportNull$$$0(4);
        }
        ArrayList<FormattingService> serviceList = new ArrayList<FormattingService>();
        FormattingService currService = formattingService;
        while (currService != null && !serviceList.contains(currService)) {
            serviceList.add(0, currService);
            currService = (FormattingService)ObjectUtils.doIfNotNull((Object)currService.runAfter(), serviceClass -> FormattingServiceUtil.findService(serviceClass));
        }
        return serviceList;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement element2, boolean canChangeWhiteSpaceOnly) {
        if (element2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(5);
        }
        PsiFile file2 = element2.getContainingFile();
        PsiElement contextElement = element2;
        FormattingService mainService = FormattingServiceUtil.findService(file2, true, element2.getTextRange().equals((Object)file2.getTextRange()));
        for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
            contextElement = service.formatElement(contextElement, canChangeWhiteSpaceOnly);
        }
        PsiElement psiElement = contextElement;
        if (psiElement == null) {
            FormattingServiceUtil.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement element2, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly) {
        if (element2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(7);
        }
        if (range2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(8);
        }
        PsiFile file2 = element2.getContainingFile();
        boolean isFullRange = range2.equals((Object)file2.getTextRange());
        PsiElement contextElement = element2;
        FormattingService mainService = FormattingServiceUtil.findService(element2.getContainingFile(), true, isFullRange);
        if (isFullRange) {
            for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
                contextElement = service.formatElement(contextElement, range2, canChangeWhiteSpacesOnly);
            }
            PsiElement psiElement = contextElement;
            if (psiElement == null) {
                FormattingServiceUtil.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        PsiElement psiElement = mainService.formatElement(element2, range2, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            FormattingServiceUtil.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    public static void formatRanges(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, boolean canChangeWhiteSpaceOnly) {
        if (file2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(11);
        }
        if (ranges == null) {
            FormattingServiceUtil.$$$reportNull$$$0(12);
        }
        boolean isFullRange = ranges.getRanges().size() == 1 && ranges.getRanges().get(0).getTextRange().equals((Object)file2.getTextRange());
        FormattingService mainService = FormattingServiceUtil.findService(file2, true, isFullRange);
        if (isFullRange) {
            for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
                service.formatRanges(file2, (FormattingRangesInfo)ranges, canChangeWhiteSpaceOnly, false);
            }
        } else {
            mainService.formatRanges(file2, (FormattingRangesInfo)ranges, canChangeWhiteSpaceOnly, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/FormattingServiceUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingService";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/FormattingServiceUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportsOptimizingService";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findImportsOptimizingService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChainedServices";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

