/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.ui.update.ComparableObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeIconProvider
extends IconProvider
implements DumbAware {
    private final Map<Ext, Icon> myIconCache = new HashMap<Ext, Icon>();
    private final Set<Ext> myCustomIconExtensions = SystemInfoRt.isWindows ? Set.of(new Ext("exe"), new Ext("ico")) : Collections.emptySet();
    private final Map<String, Icon> myCustomIconCache = new HashMap<String, Icon>();
    private static final Ext NO_EXT = new Ext(null);
    private static final Ext CLOSED_DIR = new Ext(null, 0);
    private static final NotNullLazyValue<JFileChooser> fileChooser = NotNullLazyValue.volatileLazy(() -> new JFileChooser());

    @Nullable
    public Icon getIcon(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        VirtualFile file2;
        if (element2 == null) {
            NativeIconProvider.$$$reportNull$$$0(0);
        }
        if (element2 instanceof PsiFile && (file2 = ((PsiFile)element2).getVirtualFile()) != null) {
            return this.doGetIcon(file2, flags);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Icon doGetIcon(@NotNull VirtualFile virtualFile2, int flags) {
        if (virtualFile2 == null) {
            NativeIconProvider.$$$reportNull$$$0(1);
        }
        if (!NativeIconProvider.isNativeFileType(virtualFile2)) {
            return null;
        }
        if (virtualFile2 instanceof VirtualFileWithoutContent) {
            return null;
        }
        Ext ext = NativeIconProvider.getExtension(virtualFile2, flags);
        Path ioFile = virtualFile2.getFileSystem().getNioPath(virtualFile2);
        if (ioFile == null) {
            return null;
        }
        Map<Ext, Icon> map2 = this.myIconCache;
        synchronized (map2) {
            Icon icon2;
            if (this.myCustomIconExtensions.contains((Object)ext)) {
                icon2 = this.myCustomIconCache.get(ioFile.toString());
            } else {
                Icon icon3 = icon2 = ext == null ? null : this.myIconCache.get((Object)ext);
            }
            if (icon2 != null) {
                return icon2;
            }
        }
        return DeferredIconImpl.withoutReadAction(AllIcons.Nodes.NodePlaceholder, ioFile, file2 -> {
            Icon icon2;
            if (!Files.exists(file2, new LinkOption[0])) {
                return null;
            }
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                return null;
            }
            try {
                icon2 = ((JFileChooser)fileChooser.getValue()).getIcon(file2.toFile());
            }
            catch (Exception e) {
                return null;
            }
            if (ext != null) {
                Map<Ext, Icon> map2 = this.myIconCache;
                synchronized (map2) {
                    if (this.myCustomIconExtensions.contains((Object)ext)) {
                        this.myCustomIconCache.put(file2.toString(), icon2);
                    } else {
                        this.myIconCache.put(ext, icon2);
                    }
                }
            }
            return icon2;
        });
    }

    @Nullable
    public static Icon getNativeIcon(@NotNull Path file2) {
        if (file2 == null) {
            NativeIconProvider.$$$reportNull$$$0(2);
        }
        return ((JFileChooser)fileChooser.getValue()).getIcon(file2.toFile());
    }

    private static Ext getExtension(VirtualFile file2, int flags) {
        if (file2.isDirectory()) {
            if (file2.getExtension() == null) {
                return CLOSED_DIR;
            }
            return new Ext(file2.getExtension(), flags);
        }
        return file2.getExtension() != null ? new Ext(file2.getExtension()) : NO_EXT;
    }

    private static boolean isNativeFileType(VirtualFile file2) {
        FileType type = file2.getFileType();
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).useNativeIcon();
        }
        return type instanceof UnknownFileType && !file2.isDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/NativeIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNativeIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Ext
    extends ComparableObject.Impl {
        private final Object[] myText;

        private Ext(@Nullable String text2) {
            this.myText = new Object[]{text2};
        }

        private Ext(@Nullable String text2, int flags) {
            this.myText = new Object[]{text2, flags};
        }

        public Object @NotNull [] getEqualityObjects() {
            if (this.myText == null) {
                Ext.$$$reportNull$$$0(0);
            }
            return this.myText;
        }

        public String toString() {
            return this.myText[0] != null ? this.myText[0].toString() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/NativeIconProvider$Ext", "getEqualityObjects"));
        }
    }
}

