/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.ProjectDetector;
import com.intellij.util.BitUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ReopenProjectAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private final String myProjectPath;
    private final String myProjectName;
    private boolean myIsRemoved;
    @Nullable
    private ProjectGroup myProjectGroup;

    public ReopenProjectAction(@NotNull @SystemIndependent String projectPath, @NlsSafe String projectName, @NlsSafe String displayName) {
        if (projectPath == null) {
            ReopenProjectAction.$$$reportNull$$$0(0);
        }
        this.myIsRemoved = false;
        this.myProjectPath = projectPath;
        this.myProjectName = projectName;
        Presentation presentation2 = this.getTemplatePresentation();
        String text2 = projectPath.equals(displayName) ? FileUtil.getLocationRelativeToUserHome((String)projectPath) : displayName;
        presentation2.setText(text2, false);
        presentation2.setDescription(FileUtil.toSystemDependentName((String)projectPath));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ReopenProjectAction.$$$reportNull$$$0(1);
        }
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        Project project = e.getProject();
        Path file2 = Paths.get(this.myProjectPath, new String[0]).normalize();
        if (!Files.exists(file2, new LinkOption[0])) {
            if (Messages.showDialog((Project)project, (String)IdeBundle.message((String)"message.the.path.0.does.not.exist.maybe.on.remote", (Object[])new Object[]{FileUtil.toSystemDependentName((String)this.myProjectPath)}), (String)IdeBundle.message((String)"dialog.title.reopen.project", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText(), IdeBundle.message((String)"button.remove.from.list", (Object[])new Object[0])}, (int)0, (Icon)Messages.getErrorIcon()) == 1) {
                this.myIsRemoved = true;
                RecentProjectsManager.getInstance().removePath(this.myProjectPath);
            }
            return;
        }
        int modifiers = e.getModifiers();
        boolean forceOpenInNewFrame = BitUtil.isSet((int)modifiers, (int)2) || BitUtil.isSet((int)modifiers, (int)1) || e.getPlace() == "WelcomeScreen" || LightEdit.owns((Project)project);
        RecentProjectsManagerBase.getInstanceEx().openProject(file2, OpenProjectTask.withProjectToClose(project, forceOpenInNewFrame).withRunConfigurators());
        for (ProjectDetector extension2 : (ProjectDetector[])ProjectDetector.EXTENSION_POINT_NAME.getExtensions()) {
            extension2.logRecentProjectOpened(this.myProjectGroup);
        }
    }

    public @SystemIndependent String getProjectPath() {
        return this.myProjectPath;
    }

    public boolean isRemoved() {
        return this.myIsRemoved;
    }

    @NlsSafe
    public String getProjectName() {
        RecentProjectsManager mgr = RecentProjectsManager.getInstance();
        if (mgr instanceof RecentProjectsManagerBase) {
            return ((RecentProjectsManagerBase)mgr).getProjectName(this.myProjectPath);
        }
        return this.myProjectName;
    }

    @NlsSafe
    @Nullable
    public String getProjectNameToDisplay() {
        RecentProjectsManager mgr = RecentProjectsManager.getInstance();
        String displayName = mgr instanceof RecentProjectsManagerBase ? ((RecentProjectsManagerBase)mgr).getDisplayName(this.myProjectPath) : null;
        return displayName != null ? displayName : this.getProjectName();
    }

    @NlsActions.ActionText
    @Nullable
    public String getTemplateText() {
        return IdeBundle.message((String)"action.ReopenProject.reopen.project.text", (Object[])new Object[0]);
    }

    public void setProjectGroup(@Nullable ProjectGroup projectGroup) {
        this.myProjectGroup = projectGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ReopenProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

