/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachDirectoryUtils {
    public static void chooseAndAddDirectoriesWithUndo(@NotNull Project project, @Nullable Consumer<? super List<VirtualFile>> callback2) {
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(0);
        }
        Module module = AttachDirectoryUtils.getAttachTargetModule(project);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, null, files2 -> {
            AttachDirectoryUtils.addAndSelectDirectoriesWithUndo(project, module, files2);
            if (callback2 != null) {
                callback2.consume(files2);
            }
        });
    }

    public static void addDirectoriesWithUndo(@NotNull Project project, @NotNull List<VirtualFile> roots2) {
        Module module;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(1);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(2);
        }
        if ((module = AttachDirectoryUtils.getAttachTargetModule(project)) == null) {
            return;
        }
        AttachDirectoryUtils.addAndSelectDirectoriesWithUndo(project, module, roots2);
    }

    private static void addAndSelectDirectoriesWithUndo(@NotNull Project project, @Nullable Module module, @NotNull List<VirtualFile> roots2) {
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(3);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(4);
        }
        AttachDirectoryUtils.addRemoveEntriesWithUndo(project, module, roots2, true);
        VirtualFile file2 = (VirtualFile)ContainerUtil.getFirstItem(roots2);
        if (file2 != null) {
            ProjectViewSelectInTarget.select(project, file2, "ProjectPane", null, file2, true);
        }
    }

    public static void addRemoveEntriesWithUndo(final @NotNull Project project, final @Nullable Module module, @NotNull List<VirtualFile> roots2, final boolean add2) {
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(5);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(6);
        }
        final ArrayList adjustedRoots = ContainerUtil.newArrayList((Iterable)JBIterable.from(roots2).filter(o -> add2 == (ModuleUtilCore.findModuleForFile((VirtualFile)o, (Project)project) == null)).filterMap(o -> o.isDirectory() ? o : o.getParent()).unique());
        adjustedRoots.removeIf(r -> ContainerUtil.exists((Iterable)adjustedRoots, r2 -> VfsUtilCore.isAncestor((VirtualFile)r2, (VirtualFile)r, (boolean)true)));
        if (adjustedRoots.isEmpty()) {
            return;
        }
        String title2 = IdeBundle.message((String)"command.name.choice.attach.detach", (Object[])new Object[]{add2 ? 0 : 1, AttachDirectoryUtils.getDisplayName(adjustedRoots)});
        WriteCommandAction.writeCommandAction((Project)project).withName(title2).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            class MyUndoable
            extends GlobalUndoableAction {
                MyUndoable() {
                }

                public void undo() {
                    AttachDirectoryUtils.addRemoveEntriesInner(project, module, adjustedRoots, !add2);
                }

                public void redo() {
                    AttachDirectoryUtils.addRemoveEntriesInner(project, module, adjustedRoots, add2);
                }
            }
            MyUndoable undoable = new MyUndoable();
            undoable.redo();
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoable);
        });
    }

    public static void excludeEntriesWithUndo(@NotNull Project project, @NotNull List<VirtualFile> roots2, boolean exclude) {
        Module module;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(7);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(8);
        }
        if ((module = AttachDirectoryUtils.getAttachTargetModule(project)) != null) {
            AttachDirectoryUtils.excludeEntriesWithUndo(module, roots2, exclude);
        }
    }

    public static void excludeEntriesWithUndo(final @NotNull Module module, final @NotNull List<VirtualFile> roots2, final boolean exclude) {
        if (module == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(9);
        }
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(10);
        }
        if (roots2.isEmpty()) {
            return;
        }
        Project project = module.getProject();
        String title2 = IdeBundle.message((String)"command.name.choice.exclude.include", (Object[])new Object[]{exclude ? 0 : 1, AttachDirectoryUtils.getDisplayName(roots2)});
        WriteCommandAction.writeCommandAction((Project)project).withName(title2).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            class MyUndoable
            extends GlobalUndoableAction {
                MyUndoable() {
                }

                public void undo() {
                    AttachDirectoryUtils.excludeEntriesInner(module, roots2, !exclude);
                }

                public void redo() {
                    AttachDirectoryUtils.excludeEntriesInner(module, roots2, exclude);
                }
            }
            MyUndoable undoable = new MyUndoable();
            undoable.redo();
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)undoable);
        });
    }

    public static String getDisplayName(@NotNull List<VirtualFile> roots2) {
        if (roots2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(11);
        }
        return roots2.size() == 1 ? "directory '" + roots2.get(0).getName() + "'" : roots2.size() + " " + StringUtil.pluralize((String)"directory", (int)roots2.size());
    }

    private static void addRemoveEntriesInner(@NotNull Project project, @Nullable Module module, @NotNull List<VirtualFile> files2, boolean add2) {
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(12);
        }
        if (files2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(13);
        }
        if (module == null) {
            module = AttachDirectoryUtils.getAttachTargetModule(project);
        }
        if (module == null) {
            module = AttachDirectoryUtils.createDefaultModule(project);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
            if (add2) {
                for (VirtualFile file2 : files2) {
                    model2.addContentEntry(file2);
                }
            } else {
                for (ContentEntry entry2 : model2.getContentEntries()) {
                    if (!files2.contains(entry2.getFile())) continue;
                    model2.removeContentEntry(entry2);
                }
            }
        });
    }

    private static void excludeEntriesInner(@NotNull Module module, @NotNull List<VirtualFile> files2, boolean exclude) {
        if (module == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(14);
        }
        if (files2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(15);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
            for (ContentEntry entry2 : model2.getContentEntries()) {
                VirtualFile root2 = entry2.getFile();
                if (root2 == null) continue;
                for (VirtualFile file2 : files2) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)file2, (boolean)true)) continue;
                    if (exclude) {
                        entry2.addExcludeFolder(file2);
                        continue;
                    }
                    entry2.removeExcludeFolder(file2.getUrl());
                }
            }
        });
    }

    @Nullable
    private static Module getAttachTargetModule(@NotNull Project project) {
        Module[] modules2;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(16);
        }
        return (modules2 = ModuleManager.getInstance((Project)project).getModules()).length == 0 ? null : modules2[0];
    }

    @NotNull
    private static Module createDefaultModule(@NotNull Project project) {
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(17);
        }
        IProjectStore store = ProjectKt.getStateStore(project);
        Path proDir = store.getProjectFilePath().getParent();
        Path modulePath = proDir.resolve(project.getName() + ".iml");
        ModuleType defType = ModuleTypeManager.getInstance().getDefaultModuleType();
        Module module = ModuleManager.getInstance((Project)project).newModule(modulePath, defType.getId());
        if (module == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(18);
        }
        return module;
    }

    @NotNull
    public static List<VirtualFile> getAttachedDirectories(@NotNull Project project) {
        Module module;
        if (project == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(19);
        }
        List<VirtualFile> list2 = (module = AttachDirectoryUtils.getAttachTargetModule(project)) != null ? Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots()) : Collections.emptyList();
        if (list2 == null) {
            AttachDirectoryUtils.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/AttachDirectoryUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/AttachDirectoryUtils";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultModule";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndAddDirectoriesWithUndo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoriesWithUndo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAndSelectDirectoriesWithUndo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveEntriesWithUndo";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "excludeEntriesWithUndo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRemoveEntriesInner";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "excludeEntriesInner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttachTargetModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultModule";
                break;
            }
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

