/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;

final class ChangeLAFAnimator {
    private float myAlpha = 1.0f;
    private final Map<JLayeredPane, JComponent> myMap;
    private final Animator myAnimator = new Animator("ChangeLAF", 60, 800, false){

        public void resume() {
            ChangeLAFAnimator.this.doPaint();
            super.resume();
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            ChangeLAFAnimator.this.myAlpha = 1.0f - (float)(1.0 - Math.cos(Math.PI * (double)frame / (double)totalFrames)) / 2.0f;
            ChangeLAFAnimator.this.doPaint();
        }

        protected void paintCycleEnd() {
            if (!this.isDisposed()) {
                Disposer.dispose((Disposable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            try {
                super.dispose();
                for (Map.Entry<JLayeredPane, JComponent> entry2 : ChangeLAFAnimator.this.myMap.entrySet()) {
                    JLayeredPane layeredPane2 = entry2.getKey();
                    layeredPane2.remove(entry2.getValue());
                    layeredPane2.revalidate();
                    layeredPane2.repaint();
                }
            }
            finally {
                ChangeLAFAnimator.this.myMap.clear();
            }
        }
    };

    static ChangeLAFAnimator showSnapshot() {
        return new ChangeLAFAnimator();
    }

    private ChangeLAFAnimator() {
        Window[] windows = Window.getWindows();
        this.myMap = new LinkedHashMap<JLayeredPane, JComponent>();
        for (Window window : windows) {
            if (!(window instanceof RootPaneContainer) || !window.isShowing()) continue;
            Rectangle bounds2 = window.getBounds();
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            final JLayeredPane layeredPane2 = rootPaneContainer.getLayeredPane();
            final BufferedImage image = ImageUtil.createImage((GraphicsConfiguration)window.getGraphicsConfiguration(), (int)bounds2.width, (int)bounds2.height, (int)2);
            Graphics imageGraphics = image.getGraphics();
            GraphicsUtil.setupAntialiasing((Graphics)imageGraphics);
            ((RootPaneContainer)((Object)window)).getRootPane().paint(imageGraphics);
            JComponent imageLayer = new JComponent(){

                @Override
                public void updateUI() {
                }

                @Override
                public void paint(Graphics g) {
                    g = g.create();
                    ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, ChangeLAFAnimator.this.myAlpha));
                    UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, (ImageObserver)this);
                }

                @Override
                public Rectangle getBounds() {
                    return layeredPane2.getBounds();
                }
            };
            imageLayer.setSize(layeredPane2.getSize());
            layeredPane2.add((Component)imageLayer, JLayeredPane.DRAG_LAYER);
            this.myMap.put(layeredPane2, imageLayer);
        }
        this.doPaint();
    }

    void hideSnapshotWithAnimation() {
        this.myAnimator.resume();
    }

    private void doPaint() {
        for (Map.Entry<JLayeredPane, JComponent> entry2 : this.myMap.entrySet()) {
            if (!entry2.getKey().isShowing()) continue;
            entry2.getValue().revalidate();
            entry2.getValue().repaint();
        }
    }
}

