/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.troubleshooting.CompositeGeneralTroubleInfoCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.Compressor;
import com.intellij.util.ui.IoErrorText;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectZippedLogsAction
extends AnAction
implements DumbAware {
    private static final String CONFIRMATION_DIALOG = "zipped.logs.action.show.confirmation.dialog";
    private static final String NOTIFICATION_GROUP = "Collect Zipped Logs";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        boolean doNotShowDialog = PropertiesComponent.getInstance().getBoolean(CONFIRMATION_DIALOG);
        if (!doNotShowDialog) {
            String title2 = IdeBundle.message((String)"collect.logs.sensitive.title", (Object[])new Object[0]);
            String message2 = IdeBundle.message((String)"collect.logs.sensitive.text", (Object[])new Object[0]);
            boolean confirmed = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title2, (String)message2).yesText(ActionsBundle.message((String)"action.RevealIn.name.other", (Object[])new Object[]{RevealFileAction.getFileManagerName()}))).noText(CommonBundle.getCancelButtonText())).icon(Messages.getWarningIcon())).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

                public void rememberChoice(boolean selected2, int exitCode) {
                    PropertiesComponent.getInstance().setValue(CollectZippedLogsAction.CONFIRMATION_DIALOG, selected2);
                }
            })).ask(project);
            if (!confirmed) {
                return;
            }
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                Path logs = CollectZippedLogsAction.packLogs(project);
                if (RevealFileAction.isSupported()) {
                    RevealFileAction.openFile(logs);
                } else {
                    new Notification(NOTIFICATION_GROUP, IdeBundle.message((String)"collect.logs.notification.success", (Object[])new Object[]{logs}), NotificationType.INFORMATION).notify(project);
                }
            }
            catch (IOException x) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn((Throwable)x);
                String message2 = IdeBundle.message((String)"collect.logs.notification.error", (Object[])new Object[]{IoErrorText.message((Throwable)x)});
                new Notification(NOTIFICATION_GROUP, message2, NotificationType.ERROR).notify(project);
            }
        }, IdeBundle.message((String)"collect.logs.progress.title", (Object[])new Object[0]), true, project);
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    @NotNull
    public static Path packLogs(@Nullable Project project) throws IOException {
        Project project2;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return CollectZippedLogsAction.packLogs(project2, compressor -> {});
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @RequiresBackgroundThread
    @NotNull
    public static Path packLogs(@Nullable Project project, @NotNull Consumer<Compressor> consumer2) throws IOException {
        void additionalFiles;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (additionalFiles == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(1);
        }
        PerformanceWatcher.getInstance().dumpThreads("", false);
        String productName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.ENGLISH);
        String date = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        Path archive = Files.createTempFile(productName + "-logs-" + date, ".zip", new FileAttribute[0]);
        try (Compressor.Zip zip = new Compressor.Zip(archive.toFile());){
            Project project2;
            ProgressManager.checkCanceled();
            additionalFiles.accept(zip);
            ProgressManager.checkCanceled();
            Path logs = Path.of(PathManager.getLogPath(), new String[0]);
            Path caches = Path.of(PathManager.getSystemPath(), new String[0]);
            if (Files.isSameFile(logs, caches)) {
                throw new IOException("cannot collect logs, because log directory set to be the same as the 'system' one: " + logs);
            }
            zip.addDirectory(logs);
            ProgressManager.checkCanceled();
            if (project2 != null) {
                StringBuilder settings = new StringBuilder();
                settings.append(new CompositeGeneralTroubleInfoCollector().collectInfo(project2));
                for (TroubleInfoCollector troubleInfoCollector : (TroubleInfoCollector[])TroubleInfoCollector.EP_SETTINGS.getExtensions()) {
                    ProgressManager.checkCanceled();
                    settings.append(troubleInfoCollector.collectInfo(project2)).append('\n');
                }
                zip.addFile("troubleshooting.txt", settings.toString().getBytes(StandardCharsets.UTF_8));
            }
            try (DirectoryStream<Path> paths2 = Files.newDirectoryStream(Path.of(SystemProperties.getUserHome(), new String[0]));){
                for (Path path2 : paths2) {
                    ProgressManager.checkCanceled();
                    String name2 = path2.getFileName().toString();
                    if (!name2.startsWith("java_error_in") && !name2.startsWith("jbr_err_pid") || name2.endsWith("hprof") || !Files.isRegularFile(path2, new LinkOption[0])) continue;
                    zip.addFile(name2, path2);
                }
            }
        }
        catch (IOException e) {
            try {
                Files.delete(archive);
            }
            catch (IOException x) {
                e.addSuppressed(x);
            }
            throw e;
        }
        Path path3 = archive;
        if (path3 == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(2);
        }
        return path3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CollectZippedLogsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CollectZippedLogsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "packLogs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "packLogs";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

