/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CopyPathProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AlwaysPerformingActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferencePopup
extends NonTrivialActionGroup
implements AlwaysPerformingActionGroup {
    private static final Logger LOG = Logger.getInstance(CopyReferencePopup.class);
    private static final int DEFAULT_WIDTH = JBUIScale.scale((int)500);

    public boolean canBePerformed(@NotNull DataContext context2) {
        if (context2 == null) {
            CopyReferencePopup.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyReferencePopup.$$$reportNull$$$0(1);
        }
        final DataContext dataContext = SimpleDataContext.builder().addAll(e.getDataContext(), CommonDataKeys.PSI_ELEMENT, CommonDataKeys.PROJECT, LangDataKeys.PSI_ELEMENT_ARRAY, CommonDataKeys.VIRTUAL_FILE_ARRAY, CommonDataKeys.EDITOR).build();
        String popupPlace = ActionPlaces.getActionGroupPopupPlace((String)((Object)((Object)this)).getClass().getSimpleName());
        PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(LangBundle.message((String)"popup.title.copy", (Object[])new Object[0]), (ActionGroup)this, e.getDataContext(), true, true, false, true, null, -1, null, popupPlace){

            protected ListCellRenderer<PopupFactoryImpl.ActionItem> getListElementRenderer() {
                return new PopupListElementRenderer<PopupFactoryImpl.ActionItem>((ListPopupImpl)this){
                    private JLabel myInfoLabel;
                    private JLabel myShortcutLabel;

                    @Override
                    protected void createLabel() {
                        super.createLabel();
                        this.myIconLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)1, (int)JBUI.CurrentTheme.ActionsList.elementIconGap()));
                        this.myInfoLabel = new JLabel();
                        this.myInfoLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)1, (int)1));
                        this.myShortcutLabel = new JLabel();
                        this.myShortcutLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                        this.myShortcutLabel.setForeground(UIUtil.getContextHelpForeground());
                    }

                    @Override
                    protected JComponent createItemComponent() {
                        this.createLabel();
                        JPanel panel2 = new JPanel(new GridBagLayout());
                        GridBag gbc = new GridBag();
                        panel2.add((Component)this.myIconLabel, gbc.next());
                        panel2.add((Component)this.myTextLabel, gbc.next());
                        panel2.add((Component)this.myShortcutLabel, gbc.next());
                        panel2.add((Component)this.myInfoLabel, gbc.next().weightx(1.0));
                        return this.layoutComponent(panel2);
                    }

                    @Override
                    protected void customizeComponent(@NotNull JList<? extends PopupFactoryImpl.ActionItem> list2, @NotNull PopupFactoryImpl.ActionItem actionItem, boolean isSelected) {
                        int pos;
                        if (list2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (actionItem == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.myNextStepButtonSeparator.setVisible(false);
                        AnAction action2 = actionItem.getAction();
                        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                        List<PsiElement> elements = CopyReferenceUtil.getElementsToCopy(editor2, dataContext);
                        String qualifiedName = null;
                        if (action2 instanceof CopyPathProvider) {
                            qualifiedName = ((CopyPathProvider)action2).getQualifiedName(this.getProject(), elements, editor2, dataContext);
                        }
                        if (action2 instanceof CopyReferenceAction) {
                            qualifiedName = ((CopyReferenceAction)action2).getQualifiedName(editor2, elements);
                        }
                        this.myInfoLabel.setText("");
                        if (qualifiedName != null) {
                            this.myInfoLabel.setText(qualifiedName);
                        }
                        Color foreground = isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor();
                        this.myInfoLabel.setForeground(foreground);
                        this.myShortcutLabel.setForeground(foreground);
                        MnemonicNavigationFilter<PopupFactoryImpl.ActionItem> filter = myStep.getMnemonicNavigationFilter();
                        int n = pos = filter == null ? -1 : filter.getMnemonicPos(actionItem);
                        if (pos != -1) {
                            Object text2 = this.myTextLabel.getText();
                            text2 = ((String)text2).substring(0, pos) + ((String)text2).substring(pos + 1);
                            this.myTextLabel.setText((String)text2);
                            this.myTextLabel.setDisplayedMnemonicIndex(pos);
                        }
                        if (action2 instanceof CopyPathProvider) {
                            Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])action2.getShortcutSet().getShortcuts());
                            this.myShortcutLabel.setText(shortcut != null ? KeymapUtil.getShortcutText((Shortcut)shortcut) : null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "list";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "actionItem";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/actions/CopyReferencePopup$1$1";
                        objectArray[2] = "customizeComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            protected boolean isResizable() {
                return true;
            }
        };
        CopyReferencePopup.updatePopupSize(popup2);
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    public ActionGroup getCopyReferenceActionGroup() {
        AnAction popupGroup = ActionManager.getInstance().getAction("CopyReferencePopupGroup");
        if (!(popupGroup instanceof DefaultActionGroup)) {
            LOG.warn("Cannot find 'CopyReferencePopup' action to show popup");
            return null;
        }
        return (ActionGroup)popupGroup;
    }

    private static void updatePopupSize(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            CopyReferencePopup.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            popup2.getContent().setPreferredSize(new Dimension(DEFAULT_WIDTH, popup2.getContent().getPreferredSize().height));
            popup2.getContent().setSize(new Dimension(DEFAULT_WIDTH, popup2.getContent().getPreferredSize().height));
            popup2.setSize(popup2.getContent().getPreferredSize());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CopyReferencePopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePopupSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

