/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.AttachDirectoryUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DetachDirectoryAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DetachDirectoryAction.$$$reportNull$$$0(0);
        }
        ProjectFileIndex index2 = (project = e.getProject()) == null ? null : ProjectFileIndex.SERVICE.getInstance((Project)project);
        JBIterable files2 = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
        boolean enabled = index2 != null && files2.isNotEmpty() && files2.filter(o -> !o.equals(index2.getContentRootForFile(o))).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(this.getTitle(files2.take(2).size()));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DetachDirectoryAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ProjectFileIndex index2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
        List roots2 = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(o -> o.equals(index2.getContentRootForFile(o))).toList();
        String target2 = AttachDirectoryUtils.getDisplayName(roots2);
        String message2 = IdeBundle.message((String)"detach.directory.dialog.message.detach.0", (Object[])new Object[]{target2});
        if (Messages.showOkCancelDialog((Project)project, (String)message2, (String)this.getConfirmDetachDialogTitle(), (String)IdeBundle.message((String)"detach.directory.dialog.button.detach", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0) {
            DetachDirectoryAction.detachDirectoriesWithUndo(project, roots2);
        }
    }

    @NlsSafe
    protected String getTitle(int directoriesAmount) {
        return IdeBundle.message((String)"detach.directory.action.text.detach.0", (Object[])new Object[]{directoriesAmount});
    }

    @NlsSafe
    protected String getConfirmDetachDialogTitle() {
        return IdeBundle.message((String)"detach.directory.dialog.title.detach", (Object[])new Object[0]);
    }

    public static void detachDirectoriesWithUndo(@NotNull Project project, @NotNull List<VirtualFile> files2) {
        if (project == null) {
            DetachDirectoryAction.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            DetachDirectoryAction.$$$reportNull$$$0(3);
        }
        AttachDirectoryUtils.addRemoveEntriesWithUndo(project, null, files2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/DetachDirectoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detachDirectoriesWithUndo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

