/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0017\u0010&\u001a\t\u0018\u00010'\u00a2\u0006\u0002\b(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0014H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00062"}, d2={"Lcom/intellij/ide/actions/SwitcherVirtualFile;", "Lcom/intellij/ide/actions/SwitcherListItem;", "Lcom/intellij/ui/BackgroundSupplier;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "icon$delegate", "Lkotlin/Lazy;", "isProblemFile", "", "()Z", "mainText", "", "getMainText", "()Ljava/lang/String;", "setMainText", "(Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "statusText", "getStatusText", "getWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "close", "", "switcher", "Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "getElementBackground", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/Nullable;", "row", "", "navigate", "mode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "prepareMainRenderer", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "intellij.platform.ide.impl"})
public final class SwitcherVirtualFile
implements SwitcherListItem,
BackgroundSupplier {
    private final Lazy icon$delegate;
    @NotNull
    private String mainText;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private final EditorWindow window;

    private final Icon getIcon() {
        Lazy lazy = this.icon$delegate;
        SwitcherVirtualFile switcherVirtualFile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Icon)lazy.getValue();
    }

    public final boolean isProblemFile() {
        WolfTheProblemSolver wolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)this.project);
        return wolfTheProblemSolver != null && wolfTheProblemSolver.isProblemFile(this.file);
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.mainText;
    }

    public void setMainText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mainText = string;
    }

    @Override
    @NotNull
    public String getStatusText() {
        VirtualFile virtualFile2 = this.file.getParent();
        if (virtualFile2 == null) {
            virtualFile2 = this.file;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)virtualFile2.getPresentableUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUse\u2026 ?: file).presentableUrl)");
        return string;
    }

    @Override
    public void navigate(@NotNull Switcher.SwitcherPanel switcher, @NotNull FileEditorManagerImpl.OpenMode mode) {
        Intrinsics.checkNotNullParameter((Object)switcher, (String)"switcher");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
    }

    @Override
    public void close(@NotNull Switcher.SwitcherPanel switcher) {
        Intrinsics.checkNotNullParameter((Object)switcher, (String)"switcher");
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component2, boolean selected2) {
        JBColor effectColor;
        Color color;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.setIconTextGap(JBUI.scale((int)4));
        boolean bl = Registry.is((String)"ide.project.view.change.icon.on.selection", (boolean)true);
        component2.setIcon(bl ? RenderingUtil.getIcon((Icon)this.getIcon(), (boolean)selected2) : this.getIcon());
        if (selected2) {
            color = null;
        } else {
            FileStatus fileStatus = FileStatusManager.getInstance((Project)this.project).getStatus(this.file);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"FileStatusManager.getIns\u2026(project).getStatus(file)");
            color = fileStatus.getColor();
        }
        Color foreground = color;
        JBColor jBColor = effectColor = this.isProblemFile() ? JBColor.red : null;
        int style = jBColor == null ? 0 : 8;
        component2.append(this.getMainText(), new SimpleTextAttributes(style, foreground, (Color)effectColor));
    }

    @Nullable
    public Color getElementBackground(int row2) {
        return VfsPresentationUtil.getFileBackgroundColor(this.project, this.file);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final EditorWindow getWindow() {
        return this.window;
    }

    public SwitcherVirtualFile(@NotNull Project project, @NotNull VirtualFile file2, @Nullable EditorWindow window) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project;
        this.file = file2;
        this.window = window;
        this.icon$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Icon>(this){
            final /* synthetic */ SwitcherVirtualFile this$0;

            @NotNull
            public final Icon invoke() {
                return IconUtil.getIcon(this.this$0.getFile(), 2, this.this$0.getProject());
            }
            {
                this.this$0 = switcherVirtualFile;
                super(0);
            }
        }));
        this.mainText = "";
    }

    @Override
    @Nullable
    public String getMnemonic() {
        return SwitcherListItem.DefaultImpls.getMnemonic(this);
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return SwitcherListItem.DefaultImpls.getShortcutText(this);
    }

    @Override
    public boolean getSeparatorAbove() {
        return SwitcherListItem.DefaultImpls.getSeparatorAbove(this);
    }

    @Override
    public void prepareExtraRenderer(@NotNull SimpleColoredComponent component2, boolean selected2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        SwitcherListItem.DefaultImpls.prepareExtraRenderer(this, component2, selected2);
    }
}

