/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/actions/ToolWindowTabRenameActionBase;", "Lcom/intellij/openapi/wm/ToolWindowContextMenuActionBase;", "toolWindowId", "", "labelText", "(Ljava/lang/String;Ljava/lang/String;)V", "getLabelText", "()Ljava/lang/String;", "getToolWindowId", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "contentNameUpdated", "project", "Lcom/intellij/openapi/project/Project;", "showContentRenamePopup", "baseLabel", "Lcom/intellij/openapi/wm/impl/content/BaseLabel;", "update", "selectedContent", "intellij.platform.ide.impl"})
public class ToolWindowTabRenameActionBase
extends ToolWindowContextMenuActionBase {
    @NotNull
    private final String toolWindowId;
    @NotNull
    private final String labelText;

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2, @Nullable Content selectedContent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        String string = toolWindow2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toolWindow.id");
        String id2 = string;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(e.getProject() != null && Intrinsics.areEqual((Object)id2, (Object)this.toolWindowId) && selectedContent != null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow2, @Nullable Content content2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Component contextComponent = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        BaseLabel tabLabel = contextComponent instanceof BaseLabel ? (BaseLabel)contextComponent : (BaseLabel)e.getData(ToolWindowContentUi.SELECTED_CONTENT_TAB_LABEL);
        BaseLabel baseLabel = tabLabel;
        if (baseLabel == null || (baseLabel = baseLabel.getContent()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)baseLabel, (String)"tabLabel?.content ?: return");
        BaseLabel tabLabelContent = baseLabel;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        this.showContentRenamePopup(tabLabel, (Content)tabLabelContent, project2);
    }

    private final void showContentRenamePopup(BaseLabel baseLabel, Content content2, Project project) {
        JTextField textField2 = new JTextField(content2.getDisplayName());
        textField2.selectAll();
        JBLabel label2 = new JBLabel(this.labelText);
        label2.setFont(UIUtil.getLabelFont().deriveFont(1));
        JPanel jPanel2 = SwingHelper.newLeftAlignedVerticalPanel((Component)label2, Box.createVerticalStrut(JBUI.scale((int)2)), textField2);
        Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"SwingHelper.newLeftAlign\u2026BUI.scale(2)), textField)");
        JPanel panel2 = jPanel2;
        panel2.addFocusListener(new FocusAdapter(textField2){
            final /* synthetic */ JTextField $textField;

            public void focusGained(@Nullable FocusEvent e) {
                IdeFocusManager.findInstance().requestFocus((Component)this.$textField, false);
            }
            {
                this.$textField = $captured_local_variable$0;
            }
        });
        Balloon balloon2 = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel2, null).setShowCallout(true).setCloseButtonEnabled(false).setAnimationCycle(0).setDisposable((Disposable)content2).setHideOnKeyOutside(true).setHideOnClickOutside(true).setRequestFocus(true).setBlockClicksThroughBalloon(true).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon2, (String)"JBPopupFactory.getInstan\u2026e)\n      .createBalloon()");
        Balloon balloon3 = balloon2;
        textField2.addKeyListener(new KeyAdapter(this, content2, textField2, project, balloon3){
            final /* synthetic */ ToolWindowTabRenameActionBase this$0;
            final /* synthetic */ Content $content;
            final /* synthetic */ JTextField $textField;
            final /* synthetic */ Project $project;
            final /* synthetic */ Balloon $balloon;

            public void keyPressed(@Nullable KeyEvent e) {
                if (e != null && e.getKeyCode() == 10) {
                    if (!Disposer.isDisposed((Disposable)((Disposable)this.$content))) {
                        String string = this.$textField.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textField.text");
                        CharSequence charSequence = string;
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            this.$textField.putClientProperty("JComponent.outline", "error");
                            this.$textField.repaint();
                            return;
                        }
                        this.$content.setDisplayName(this.$textField.getText());
                        this.this$0.contentNameUpdated(this.$content, this.$project);
                    }
                    this.$balloon.hide();
                }
            }
            {
                this.this$0 = this$0;
                this.$content = $captured_local_variable$1;
                this.$textField = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$balloon = $captured_local_variable$4;
            }
        });
        textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(textField2){
            final /* synthetic */ JTextField $textField;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object outlineValue = this.$textField.getClientProperty("JComponent.outline");
                if (Intrinsics.areEqual((Object)outlineValue, (Object)"error")) {
                    this.$textField.putClientProperty("JComponent.outline", null);
                    this.$textField.repaint();
                }
            }
            {
                this.$textField = $captured_local_variable$0;
            }
        });
        balloon3.show(new RelativePoint((Component)baseLabel, new Point(baseLabel.getWidth() / 2, 0)), Balloon.Position.above);
    }

    public void contentNameUpdated(@NotNull Content content2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public final String getToolWindowId() {
        return this.toolWindowId;
    }

    @NotNull
    public final String getLabelText() {
        return this.labelText;
    }

    public ToolWindowTabRenameActionBase(@NotNull String toolWindowId, @NlsContexts.Label @NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        this.toolWindowId = toolWindowId;
        this.labelText = labelText;
    }
}

