/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolwindowSwitcher
extends DumbAwareAction {
    private static JBPopup popup;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolwindowSwitcher.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        assert (project != null);
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
        ToolwindowSwitcher.invokePopup(project, new ToolWindowsComparator(toolWindowManager.getRecentToolWindows()), null, null);
    }

    public static void invokePopup(Project project, @NotNull Comparator<? super ToolWindow> comparator2, @Nullable Predicate<? super ToolWindow> filter, @Nullable RelativePoint point) {
        if (comparator2 == null) {
            ToolwindowSwitcher.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            filter = window -> true;
        }
        if (popup != null) {
            ToolwindowSwitcher.gotoNextElement(popup);
            return;
        }
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
        List<ToolWindow> toolWindows = ToolwindowSwitcher.getToolWindows(project, filter);
        if (toolWindows.isEmpty()) {
            return;
        }
        toolWindows.sort(comparator2);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(toolWindows);
        ToolWindow selected2 = toolWindowManager.getActiveToolWindowId() == null || toolWindows.size() == 1 ? toolWindows.get(0) : toolWindows.get(1);
        popup = builder2.setRenderer((ListCellRenderer)new ToolWindowsWidgetCellRenderer()).setAutoselectOnMouseMove(true).setRequestFocus(true).setSelectedValue((Object)selected2, false).setMinSize(new Dimension(300, -1)).setNamerForFiltering(x -> x.getStripeTitle()).setItemChosenCallback(selectedValue -> {
            if (popup != null) {
                popup.closeOk(null);
            }
            toolWindowManager.activateToolWindow(selectedValue.getId(), null, true, ToolWindowEventSource.ToolWindowSwitcher);
        }).createPopup();
        Disposer.register((Disposable)popup, () -> {
            popup = null;
        });
        if (point != null) {
            popup.show(point);
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
    }

    @NotNull
    public static List<ToolWindow> getToolWindows(@NotNull Project project, @NotNull Predicate<? super ToolWindow> filter) {
        if (project == null) {
            ToolwindowSwitcher.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            ToolwindowSwitcher.$$$reportNull$$$0(3);
        }
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
        List<ToolWindow> list2 = Arrays.stream(toolWindowManager.getToolWindowIds()).map(toolWindowManager::getToolWindow).filter(tw -> tw != null && tw.isAvailable() && tw.isShowStripeButton() && filter.test((ToolWindow)tw)).collect(Collectors.toList());
        if (list2 == null) {
            ToolwindowSwitcher.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static void gotoNextElement(JBPopup popup2) {
        JList list2 = (JList)UIUtil.findComponentOfType((JComponent)popup2.getContent(), JList.class);
        if (list2 != null) {
            ScrollingUtil.moveDown((JList)list2, (int)0);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolwindowSwitcher.$$$reportNull$$$0(5);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToolwindowSwitcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToolwindowSwitcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invokePopup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindows";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToolWindowsComparator
    implements Comparator<ToolWindow> {
        private final ArrayList<String> myRecent;

        private ToolWindowsComparator(ArrayList<String> recent) {
            this.myRecent = recent;
        }

        @Override
        public int compare(ToolWindow o1, ToolWindow o2) {
            int index1 = this.myRecent.indexOf(o1.getId());
            int index2 = this.myRecent.indexOf(o2.getId());
            if (index1 >= 0 && index2 >= 0) {
                return index1 - index2;
            }
            if (index1 >= 0) {
                return -1;
            }
            if (index2 >= 0) {
                return 1;
            }
            return StringUtil.naturalCompare((String)o1.getStripeTitle(), (String)o2.getStripeTitle());
        }
    }

    private static class ToolWindowsWidgetCellRenderer
    implements ListCellRenderer<ToolWindow> {
        private final JPanel myPanel;
        private final SimpleColoredComponent myTextLabel = new SimpleColoredComponent();
        private final JLabel myShortcutLabel = new JLabel();

        private ToolWindowsWidgetCellRenderer() {
            this.myPanel = new BorderLayoutPanel(){

                public void paintComponent(Graphics g) {
                    Color bg = UIUtil.getListBackground((boolean)false, (boolean)false);
                    g.setColor(bg);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (!this.getBackground().equals(bg)) {
                        g.setColor(this.getBackground());
                        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                        g.fillRoundRect(4, 1, this.getWidth() - 8, this.getHeight() - 2, 8, 8);
                        config2.restore();
                    }
                }
            }.addToLeft((Component)this.myTextLabel).addToRight((Component)this.myShortcutLabel);
            this.myShortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUIScale.scale((int)8), (int)1, (int)0));
            this.myPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)12));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ToolWindow> list2, ToolWindow value2, int index2, boolean isSelected, boolean cellHasFocus) {
            UIUtil.setBackgroundRecursively((Component)this.myPanel, (Color)UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.myTextLabel.clear();
            this.myTextLabel.append(value2.getStripeTitle());
            Icon icon2 = value2.getIcon();
            if (icon2 instanceof ScalableIcon) {
                icon2 = ((ScalableIcon)icon2).scale(16.0f / (float)icon2.getIconWidth());
            }
            this.myTextLabel.setIcon((Icon)ObjectUtils.notNull((Object)icon2, (Object)EmptyIcon.ICON_16));
            this.myTextLabel.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            this.myTextLabel.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            String activateActionId = ActivateToolWindowAction.getActionIdForToolWindow(value2.getId());
            KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(activateActionId);
            if (shortcut != null) {
                this.myShortcutLabel.setText(KeymapUtil.getShortcutText((Shortcut)shortcut));
            } else {
                this.myShortcutLabel.setText("");
            }
            this.myShortcutLabel.setForeground(isSelected ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
            return this.myPanel;
        }
    }
}

