/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.ScopeSupporting;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor
implements WeightedSearchEverywhereContributor<Object>,
ScopeSupporting {
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);
    private static final Key<Map<String, String>> SE_SELECTED_SCOPES = Key.create((String)"SE_SELECTED_SCOPES");
    private static final Pattern ourPatternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    protected final Project myProject;
    protected boolean myEverywhere;
    protected ScopeDescriptor myScopeDescriptor;
    private final GlobalSearchScope myEverywhereScope;
    private final GlobalSearchScope myProjectScope;
    protected final SmartPsiElementPointer<PsiElement> myPsiContext;

    protected AbstractGotoSEContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(0);
        }
        this.myProject = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        PsiElement context2 = GotoActionBase.getPsiContext(event);
        this.myPsiContext = context2 != null ? SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(context2) : null;
        GlobalSearchScope everywhereScope = SearchEverywhereClassifier.EP_Manager.getEverywhereScope(this.myProject);
        if (everywhereScope == null) {
            everywhereScope = GlobalSearchScope.everythingScope((Project)this.myProject);
        }
        this.myEverywhereScope = everywhereScope;
        List<ScopeDescriptor> scopeDescriptors = this.createScopes();
        GlobalSearchScope projectScope = SearchEverywhereClassifier.EP_Manager.getProjectScope(this.myProject);
        if (projectScope == null && this.myEverywhereScope.equals(projectScope = GlobalSearchScope.projectScope((Project)this.myProject))) {
            ScopeDescriptor secondScope = (ScopeDescriptor)JBIterable.from(scopeDescriptors).filter(o -> !o.scopeEquals((SearchScope)this.myEverywhereScope) && !o.scopeEquals(null)).first();
            projectScope = secondScope != null ? (GlobalSearchScope)secondScope.getScope() : this.myEverywhereScope;
        }
        this.myProjectScope = projectScope;
        this.myScopeDescriptor = this.getInitialSelectedScope(scopeDescriptors);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractGotoSEContributor.this.myScopeDescriptor = AbstractGotoSEContributor.this.getInitialSelectedScope(AbstractGotoSEContributor.this.createScopes());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$1", "pluginUnloaded"));
            }
        });
    }

    private List<ScopeDescriptor> createScopes() {
        DataContext context2 = this.createContext();
        ArrayList<ScopeDescriptor> res2 = new ArrayList<ScopeDescriptor>();
        ScopeChooserCombo.processScopes(this.myProject, context2, 17, (Processor<? super ScopeDescriptor>)new CommonProcessors.CollectProcessor(res2));
        return res2;
    }

    private DataContext createContext() {
        DataContext parentContext = this.myProject == null ? null : SimpleDataContext.getProjectContext(this.myProject);
        PsiElement context2 = this.myPsiContext != null ? this.myPsiContext.getElement() : null;
        PsiFile file2 = context2 == null ? null : context2.getContainingFile();
        return SimpleDataContext.builder().setParent(parentContext).add(CommonDataKeys.PSI_ELEMENT, context2).add(CommonDataKeys.PSI_FILE, file2).build();
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @NotNull
    protected List<AnAction> doGetActions(@NotNull @NlsContexts.Checkbox String ignored, @Nullable PersistentSearchEverywhereContributorFilter<?> filter, @NotNull Runnable onChanged) {
        if (ignored == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(2);
        }
        if (onChanged == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(3);
        }
        List<AnAction> list2 = this.doGetActions(filter, null, onChanged);
        if (list2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    protected <T> List<AnAction> doGetActions(@Nullable PersistentSearchEverywhereContributorFilter<T> filter, @Nullable ElementsChooser.StatisticsCollector<T> statisticsCollector, final @NotNull Runnable onChanged) {
        if (onChanged == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(5);
        }
        if (this.myProject == null || filter == null) {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new ScopeChooserAction(){
            final boolean canToggleEverywhere;
            {
                this.canToggleEverywhere = !AbstractGotoSEContributor.this.myEverywhereScope.equals(AbstractGotoSEContributor.this.myProjectScope);
            }

            @Override
            void onScopeSelected(@NotNull ScopeDescriptor o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                AbstractGotoSEContributor.this.setSelectedScope(o);
                onChanged.run();
            }

            @Override
            @NotNull
            ScopeDescriptor getSelectedScope() {
                ScopeDescriptor scopeDescriptor = AbstractGotoSEContributor.this.myScopeDescriptor;
                if (scopeDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                return scopeDescriptor;
            }

            @Override
            void onProjectScopeToggled() {
                this.setEverywhere(!AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)AbstractGotoSEContributor.this.myEverywhereScope));
            }

            @Override
            boolean processScopes(@NotNull Processor<? super ScopeDescriptor> processor2) {
                if (processor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return ContainerUtil.process(AbstractGotoSEContributor.this.createScopes(), processor2);
            }

            public boolean isEverywhere() {
                return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)AbstractGotoSEContributor.this.myEverywhereScope);
            }

            public void setEverywhere(boolean everywhere) {
                AbstractGotoSEContributor.this.setSelectedScope(new ScopeDescriptor((SearchScope)(everywhere ? AbstractGotoSEContributor.this.myEverywhereScope : AbstractGotoSEContributor.this.myProjectScope)));
                onChanged.run();
            }

            public boolean canToggleEverywhere() {
                if (!this.canToggleEverywhere) {
                    return false;
                }
                return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)AbstractGotoSEContributor.this.myEverywhereScope) || AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals((SearchScope)AbstractGotoSEContributor.this.myProjectScope);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onScopeSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "processScopes";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        result2.add((AnAction)new SearchEverywhereFiltersAction<T>(filter, onChanged, statisticsCollector));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private ScopeDescriptor getInitialSelectedScope(List<? extends ScopeDescriptor> scopeDescriptors) {
        String selectedScope;
        String string = selectedScope = this.myProject == null ? null : AbstractGotoSEContributor.getSelectedScopes(this.myProject).get(this.getClass().getSimpleName());
        if (StringUtil.isNotEmpty(selectedScope)) {
            for (ScopeDescriptor scopeDescriptor : scopeDescriptors) {
                if (!selectedScope.equals(scopeDescriptor.getDisplayName()) || scopeDescriptor.scopeEquals(null)) continue;
                ScopeDescriptor scopeDescriptor2 = scopeDescriptor;
                if (scopeDescriptor2 == null) {
                    AbstractGotoSEContributor.$$$reportNull$$$0(8);
                }
                return scopeDescriptor2;
            }
        }
        return new ScopeDescriptor((SearchScope)this.myProjectScope);
    }

    private void setSelectedScope(@NotNull ScopeDescriptor o) {
        if (o == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(9);
        }
        this.myScopeDescriptor = o;
        AbstractGotoSEContributor.getSelectedScopes(this.myProject).put(this.getClass().getSimpleName(), o.scopeEquals((SearchScope)this.myEverywhereScope) || o.scopeEquals((SearchScope)this.myProjectScope) ? null : o.getDisplayName());
    }

    @NotNull
    private static Map<String, String> getSelectedScopes(@NotNull Project project) {
        HashMap map2;
        if (project == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(10);
        }
        if ((map2 = (HashMap)SE_SELECTED_SCOPES.get((UserDataHolder)project)) == null) {
            map2 = new HashMap(3);
            SE_SELECTED_SCOPES.set((UserDataHolder)project, map2);
        }
        HashMap hashMap = map2;
        if (hashMap == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    public void fetchWeightedElements(@NotNull String rawPattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2) {
        if (rawPattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(12);
        }
        if (progressIndicator == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(13);
        }
        if (consumer2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(14);
        }
        if (this.myProject == null) {
            return;
        }
        String pattern = this.removeCommandFromPattern(rawPattern);
        if (!this.isEmptyPatternSupported() && pattern.isEmpty()) {
            return;
        }
        Runnable fetchRunnable = () -> {
            if (!this.isDumbAware() && DumbService.isDumb((Project)this.myProject)) {
                return;
            }
            FilteringGotoByModel<?> model2 = this.createModel(this.myProject);
            if (progressIndicator.isCanceled()) {
                return;
            }
            PsiElement context2 = this.myPsiContext != null ? this.myPsiContext.getElement() : null;
            ChooseByNameItemProvider provider2 = ChooseByNameModelEx.getItemProvider(model2, context2);
            GlobalSearchScope scope2 = (GlobalSearchScope)Objects.requireNonNull(this.myScopeDescriptor.getScope());
            boolean everywhere = scope2.isSearchInLibraries();
            MyViewModel viewModel = new MyViewModel(this.myProject, model2);
            if (provider2 instanceof ChooseByNameInScopeItemProvider) {
                FindSymbolParameters parameters2 = FindSymbolParameters.wrap(pattern, scope2);
                ((ChooseByNameInScopeItemProvider)provider2).filterElementsWithWeights(viewModel, parameters2, progressIndicator, item -> this.processElement(progressIndicator, consumer2, model2, item.getItem(), item.getWeight()));
            } else if (provider2 instanceof ChooseByNameWeightedItemProvider) {
                ((ChooseByNameWeightedItemProvider)provider2).filterElementsWithWeights(viewModel, pattern, everywhere, progressIndicator, item -> this.processElement(progressIndicator, consumer2, model2, item.getItem(), item.getWeight()));
            } else {
                provider2.filterElements(viewModel, pattern, everywhere, progressIndicator, (Processor<Object>)((Processor)element2 -> this.processElement(progressIndicator, consumer2, model2, element2, this.getElementPriority(element2, pattern))));
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() && application.isDispatchThread()) {
            fetchRunnable.run();
        } else {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(fetchRunnable, progressIndicator);
        }
    }

    protected boolean processElement(@NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2, FilteringGotoByModel<?> model2, Object element2, int degree) {
        if (progressIndicator == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(15);
        }
        if (consumer2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(16);
        }
        if (progressIndicator.isCanceled()) {
            return false;
        }
        if (element2 == null) {
            LOG.error("Null returned from " + model2 + " in " + this);
            return true;
        }
        return consumer2.process((Object)new FoundItemDescriptor(element2, degree));
    }

    @Override
    public ScopeDescriptor getScope() {
        return this.myScopeDescriptor;
    }

    @Override
    public void setScope(ScopeDescriptor scope2) {
        this.setSelectedScope(scope2);
    }

    @Override
    public List<ScopeDescriptor> getSupportedScopes() {
        return this.createScopes();
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        if (Registry.is((String)"search.everywhere.group.contributors.by.type")) {
            SearchEverywhereCommandInfo command = this.getFilterCommand();
            List<Object> list2 = command == null ? Collections.emptyList() : Collections.singletonList(command);
            if (list2 == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(17);
            }
            return list2;
        }
        List<SearchEverywhereCommandInfo> list3 = Collections.emptyList();
        if (list3 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(18);
        }
        return list3;
    }

    @NotNull
    protected abstract FilteringGotoByModel<?> createModel(@NotNull Project var1);

    @Nullable
    protected SearchEverywhereCommandInfo getFilterCommand() {
        return null;
    }

    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(19);
        }
        if (StringUtil.containsAnyChar((String)(pattern = this.removeCommandFromPattern(pattern)), (String)":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            String string = AbstractGotoSEContributor.applyPatternFilter(pattern, ourPatternToDetectLinesAndColumns);
            if (string == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(21);
        }
        return string;
    }

    private String removeCommandFromPattern(@NotNull String pattern) {
        SearchEverywhereCommandInfo command;
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(22);
        }
        if ((command = this.getFilterCommand()) != null && pattern.startsWith(command.getCommandWithPrefix())) {
            pattern = pattern.substring(command.getCommandWithPrefix().length()).stripLeading();
        }
        return pattern;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    public boolean showInFindResults() {
        return true;
    }

    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
        if (selected2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(23);
        }
        if (searchText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(24);
        }
        if (selected2 instanceof PsiElement) {
            if (!((PsiElement)selected2).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            PsiElement psiElement = this.preparePsi((PsiElement)selected2, modifiers, searchText);
            Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
            if (extNavigatable != null && extNavigatable.canNavigate()) {
                extNavigatable.navigate(true);
                return true;
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, true);
        } else {
            EditSourceUtil.navigate((NavigationItem)((NavigationItem)selected2), (boolean)true, (boolean)false);
        }
        return true;
    }

    public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
        if (element2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(25);
        }
        if (dataId == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(26);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (element2 instanceof PsiElement) {
                return element2;
            }
            if (element2 instanceof DataProvider) {
                return ((DataProvider)element2).getData(dataId);
            }
            if (element2 instanceof PsiElementNavigationItem) {
                return ((PsiElementNavigationItem)element2).getTargetElement();
            }
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element2 instanceof PsiElement) {
            return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element2);
        }
        return null;
    }

    public boolean isMultiSelectionSupported() {
        return true;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.createModel(this.myProject));
    }

    @NotNull
    public ListCellRenderer<Object> getElementsRenderer() {
        return new SearchEverywherePsiRenderer((Disposable)this);
    }

    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(27);
        }
        if (searchPattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(28);
        }
        return 50;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            return new OpenFileDescriptor(psi.getProject(), file2, ((Integer)position.first).intValue(), ((Integer)position.second).intValue());
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text2) {
        int line = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 2);
        int column2 = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 3);
        if (line == -1 && column2 != -1) {
            line = 0;
        }
        return new Pair((Object)line, (Object)column2);
    }

    private static int getLineAndColumnRegexpGroup(String text2, int groupNumber) {
        Matcher matcher = ourPatternToDetectLinesAndColumns.matcher(text2);
        if (matcher.matches()) {
            try {
                String group2;
                if (groupNumber <= matcher.groupCount() && (group2 = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group2) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawPattern";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSelectedScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScopes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCommands";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGetActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedScopes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fetchWeightedElements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeCommandFromPattern";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyViewModel
    implements ChooseByNameViewModel {
        private final Project myProject;
        private final ChooseByNameModel myModel;

        private MyViewModel(Project project, ChooseByNameModel model2) {
            this.myProject = project;
            this.myModel = model2;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        @Override
        @NotNull
        public ChooseByNameModel getModel() {
            ChooseByNameModel chooseByNameModel = this.myModel;
            if (chooseByNameModel == null) {
                MyViewModel.$$$reportNull$$$0(0);
            }
            return chooseByNameModel;
        }

        @Override
        public boolean isSearchInAnyPlace() {
            return this.myModel.useMiddleMatching();
        }

        @Override
        @NotNull
        public String transformPattern(@NotNull String pattern) {
            if (pattern == null) {
                MyViewModel.$$$reportNull$$$0(1);
            }
            String string = ChooseByNamePopup.getTransformedPattern(pattern, this.myModel);
            if (string == null) {
                MyViewModel.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean canShowListForEmptyPattern() {
            return false;
        }

        @Override
        public int getMaximumListSizeLimit() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$MyViewModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$MyViewModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "transformPattern";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class ScopeChooserAction
    extends ActionGroup
    implements CustomComponentAction,
    DumbAware,
    SearchEverywhereToggleAction {
        static final char CHOOSE = 'O';
        static final char TOGGLE = 'P';
        static final String TOGGLE_ACTION_NAME = "toggleProjectScope";

        ScopeChooserAction() {
        }

        abstract void onScopeSelected(@NotNull ScopeDescriptor var1);

        @NotNull
        abstract ScopeDescriptor getSelectedScope();

        abstract void onProjectScopeToggled();

        abstract boolean processScopes(@NotNull Processor<? super ScopeDescriptor> var1);

        public boolean canBePerformed(@NotNull DataContext context2) {
            if (context2 == null) {
                ScopeChooserAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public boolean isPopup() {
            return true;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (EMPTY_ARRAY == null) {
                ScopeChooserAction.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                ScopeChooserAction.$$$reportNull$$$0(2);
            }
            if (place == null) {
                ScopeChooserAction.$$$reportNull$$$0(3);
            }
            final ActionButtonWithText component2 = new ActionButtonWithText((AnAction)this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            ComponentUtil.putClientProperty((JComponent)component2, (Key)MnemonicHelper.MNEMONIC_CHECKER, keyCode -> KeyEvent.getExtendedKeyCodeForChar(80) == keyCode || KeyEvent.getExtendedKeyCodeForChar(79) == keyCode);
            MnemonicHelper.registerMnemonicAction((JComponent)component2, (int)79);
            InputMap map2 = component2.getInputMap(2);
            int mask = MnemonicHelper.getFocusAcceleratorKeyMask();
            map2.put(KeyStroke.getKeyStroke(80, mask, false), TOGGLE_ACTION_NAME);
            component2.getActionMap().put(TOGGLE_ACTION_NAME, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)component2);
                    KeyEvent inputEvent = new KeyEvent(component2, 401, e.getWhen(), MnemonicHelper.getFocusAcceleratorKeyMask(), KeyEvent.getExtendedKeyCodeForChar(80), 'P');
                    AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)this, (InputEvent)inputEvent, (String)"toolbar", (DataContext)dataContext);
                    ActionUtil.performDumbAwareWithCallbacks((AnAction)this, (AnActionEvent)event, this::onProjectScopeToggled);
                }
            });
            ActionButtonWithText actionButtonWithText = component2;
            if (actionButtonWithText == null) {
                ScopeChooserAction.$$$reportNull$$$0(4);
            }
            return actionButtonWithText;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScopeChooserAction.$$$reportNull$$$0(5);
            }
            ScopeDescriptor selection = this.getSelectedScope();
            String name2 = StringUtil.trimMiddle((String)StringUtil.notNullize((String)selection.getDisplayName()), (int)30);
            String text2 = StringUtil.escapeMnemonics((String)name2).replaceFirst("(?i)([PO])", "_$1");
            e.getPresentation().setText(text2);
            e.getPresentation().setIcon(OffsetIcon.getOriginalIcon(selection.getIcon()));
            String shortcutText = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(79, MnemonicHelper.getFocusAcceleratorKeyMask(), true));
            String shortcutText2 = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(80, MnemonicHelper.getFocusAcceleratorKeyMask(), true));
            e.getPresentation().setDescription(LangBundle.message((String)"action.choose.scope.p.toggle.scope.description", (Object[])new Object[]{shortcutText, shortcutText2}));
            JComponent button4 = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
            if (button4 != null) {
                button4.setBackground(selection.getColor());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JComponent button4;
            if (e == null) {
                ScopeChooserAction.$$$reportNull$$$0(6);
            }
            if ((button4 = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY)) == null || !button4.isValid()) {
                return;
            }
            ListCellRenderer<ScopeDescriptor> renderer2 = new ListCellRenderer<ScopeDescriptor>(){
                final ListCellRenderer<ScopeDescriptor> delegate = ScopeChooserCombo.createDefaultRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value2, int index2, boolean isSelected, boolean cellHasFocus) {
                    Component component2 = this.delegate.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                    if (component2 instanceof JComponent && !(component2 instanceof JSeparator) && !(component2 instanceof TitledSeparator)) {
                        ((JComponent)component2).setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
                    }
                    return component2;
                }
            };
            ArrayList items = new ArrayList();
            JBList fakeList = new JBList();
            this.processScopes((Processor<? super ScopeDescriptor>)((Processor)arg_0 -> ScopeChooserAction.lambda$actionPerformed$1(renderer2, (JList)fakeList, items, arg_0)));
            BaseListPopupStep<ScopeDescriptor> step2 = new BaseListPopupStep<ScopeDescriptor>("", items){

                @Nullable
                public PopupStep<?> onChosen(ScopeDescriptor selectedValue, boolean finalChoice) {
                    this.onScopeSelected(selectedValue);
                    ActionToolbar toolbar = ActionToolbar.findToolbarBy((Component)button4);
                    if (toolbar != null) {
                        toolbar.updateActionsImmediately();
                    }
                    return FINAL_CHOICE;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(ScopeDescriptor value2) {
                    return value2.getScope() instanceof GlobalSearchScope ? StringUtil.notNullize((String)value2.getDisplayName()) : "";
                }

                public boolean isSelectable(ScopeDescriptor value2) {
                    return value2.getScope() instanceof GlobalSearchScope;
                }
            };
            ScopeDescriptor selection = this.getSelectedScope();
            step2.setDefaultOptionIndex(ContainerUtil.indexOf(items, o -> Objects.equals(o.getDisplayName(), selection.getDisplayName())));
            ListPopupImpl popup2 = new ListPopupImpl(e.getProject(), (ListPopupStep)step2);
            popup2.setMaxRowCount(10);
            popup2.getList().setCellRenderer(renderer2);
            popup2.showUnderneathOf(button4);
        }

        private static /* synthetic */ boolean lambda$actionPerformed$1(ListCellRenderer renderer2, JList fakeList, List items, ScopeDescriptor o) {
            Component c = renderer2.getListCellRendererComponent(fakeList, o, -1, false, false);
            if (c instanceof JSeparator || c instanceof TitledSeparator || !o.scopeEquals(null) && o.getScope() instanceof GlobalSearchScope) {
                items.add(o);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$ScopeChooserAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

