/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersStatisticsCollector;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private static final Pattern ourPatternToDetectAnonymousClasses = Pattern.compile("([.\\w]+)((\\$[\\d]+)*(\\$)?)");
    private static final Pattern ourPatternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    private final PersistentSearchEverywhereContributorFilter<LanguageRef> myFilter;

    public ClassSearchEverywhereContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        super(event);
        this.myFilter = ClassSearchEverywhereContributor.createLanguageFilter((Project)event.getRequiredData(CommonDataKeys.PROJECT));
    }

    @NotNull
    @Nls
    public String getGroupName() {
        String string = GotoClassPresentationUpdater.getTabTitlePluralized();
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFullGroupName() {
        String res2;
        String string = res2 = String.join((CharSequence)"/", GotoClassPresentationUpdater.getActionTitlePluralized());
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int getSortWeight() {
        return 100;
    }

    @NotNull
    protected FilteringGotoByModel<LanguageRef> createModel(@NotNull Project project) {
        if (project == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        GotoClassModel2 model2 = new GotoClassModel2(project);
        if (this.myFilter != null) {
            model2.setFilterItems(this.myFilter.getSelectedElements());
        }
        GotoClassModel2 gotoClassModel2 = model2;
        if (gotoClassModel2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        return gotoClassModel2;
    }

    @Override
    @Nullable
    protected SearchEverywhereCommandInfo getFilterCommand() {
        return new SearchEverywhereCommandInfo("c", IdeBundle.message((String)"search.everywhere.filter.classes.description", (Object[])new Object[0]), (SearchEverywhereContributor)this);
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        if (onChanged == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        List<AnAction> list2 = this.doGetActions(this.myFilter, new SearchEverywhereFiltersStatisticsCollector.LangFilterCollector(), onChanged);
        if (list2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        if (pattern.indexOf(35) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectMembers);
        }
        if (pattern.indexOf(36) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectAnonymousClasses);
        }
        String string = super.filterControlSymbols(pattern);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        if (searchPattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        return super.getElementPriority(element2, searchPattern) + 5;
    }

    @Override
    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        String path2 = ClassSearchEverywhereContributor.pathToAnonymousClass(searchText);
        if (path2 != null) {
            psiElement = ClassSearchEverywhereContributor.getElement(psiElement, path2);
        }
        return super.preparePsi(psiElement, modifiers, searchText);
    }

    @Override
    @Nullable
    protected Navigatable createExtendedNavigatable(final PsiElement psi, String searchText, int modifiers) {
        Navigatable delegate2;
        Navigatable res2 = super.createExtendedNavigatable(psi, searchText, modifiers);
        if (res2 != null) {
            return res2;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        String memberName = ClassSearchEverywhereContributor.getMemberName(searchText);
        if (file2 != null && memberName != null && (delegate2 = ClassSearchEverywhereContributor.findMember(memberName, searchText, psi, file2)) != null) {
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    NavigationUtil.activateFileWithPsiElement(psi, false);
                    delegate2.navigate(true);
                }

                public boolean canNavigate() {
                    return delegate2.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return delegate2.canNavigateToSource();
                }
            };
        }
        return null;
    }

    private static String pathToAnonymousClass(String searchedText) {
        return ClassSearchEverywhereContributor.pathToAnonymousClass(ourPatternToDetectAnonymousClasses.matcher(searchedText));
    }

    @Nullable
    public static String pathToAnonymousClass(Matcher matcher) {
        String path2;
        if (matcher.matches() && (path2 = matcher.group(2)) != null) {
            if ((path2 = path2.trim()).endsWith("$") && path2.length() >= 2) {
                path2 = path2.substring(0, path2.length() - 2);
            }
            if (!path2.isEmpty()) {
                return path2;
            }
        }
        return null;
    }

    private static String getMemberName(String searchedText) {
        int index2 = searchedText.lastIndexOf(35);
        if (index2 == -1) {
            return null;
        }
        String name2 = searchedText.substring(index2 + 1).trim();
        return StringUtil.isEmpty((String)name2) ? null : name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Navigatable findMember(String memberPattern, String fullPattern, PsiElement psiElement, VirtualFile file2) {
        PsiStructureViewFactory factory2 = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder2 = factory2 == null ? null : factory2.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors2 = FileEditorManager.getInstance((Project)psiElement.getProject()).getEditors(file2);
        if (builder2 == null || editors2.length == 0) {
            return null;
        }
        StructureView view = builder2.createStructureView(editors2[0], psiElement.getProject());
        try {
            StructureViewTreeElement element2 = ClassSearchEverywhereContributor.findElement(view.getTreeModel().getRoot(), psiElement, 4);
            if (element2 == null) {
                Navigatable navigatable2 = null;
                return navigatable2;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)memberPattern).build();
            int max = Integer.MIN_VALUE;
            Object target2 = null;
            for (TreeElement treeElement : element2.getChildren()) {
                int degree;
                if (!(treeElement instanceof StructureViewTreeElement)) continue;
                Object value2 = ((StructureViewTreeElement)treeElement).getValue();
                if (value2 instanceof PsiElement && value2 instanceof Navigatable && fullPattern.equals(CopyReferenceAction.elementToFqn((PsiElement)value2))) {
                    Navigatable navigatable3 = (Navigatable)value2;
                    return navigatable3;
                }
                String presentableText2 = treeElement.getPresentation().getPresentableText();
                if (presentableText2 == null || (degree = matcher.matchingDegree(presentableText2)) <= max) continue;
                max = degree;
                target2 = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable4 = target2 instanceof Navigatable ? (Navigatable)target2 : null;
            return navigatable4;
        }
        finally {
            Disposer.dispose((Disposable)view);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node2, PsiElement element2, int hopes) {
        Object value2 = node2.getValue();
        if (value2 instanceof PsiElement) {
            if (((PsiElement)value2).isEquivalentTo(element2)) {
                return node2;
            }
            if (hopes != 0) {
                for (TreeElement child2 : node2.getChildren()) {
                    StructureViewTreeElement e;
                    if (!(child2 instanceof StructureViewTreeElement) || (e = ClassSearchEverywhereContributor.findElement((StructureViewTreeElement)child2, element2, hopes - 1)) == null) continue;
                    return e;
                }
            }
        }
        return null;
    }

    @NotNull
    public static PsiElement getElement(@NotNull PsiElement element2, @NotNull String path2) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        if (path2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        String[] classes = path2.split("\\$");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String cls : classes) {
            if (cls.isEmpty()) continue;
            try {
                indexes.add(Integer.parseInt(cls) - 1);
            }
            catch (Exception e) {
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    ClassSearchEverywhereContributor.$$$reportNull$$$0(13);
                }
                return psiElement;
            }
        }
        PsiElement current2 = element2;
        Iterator iterator2 = indexes.iterator();
        while (iterator2.hasNext()) {
            int index2 = (Integer)iterator2.next();
            PsiElement[] anonymousClasses = ClassSearchEverywhereContributor.getAnonymousClasses(current2);
            if (index2 >= 0 && index2 < anonymousClasses.length) {
                current2 = anonymousClasses[index2];
                continue;
            }
            PsiElement psiElement = current2;
            if (psiElement == null) {
                ClassSearchEverywhereContributor.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        PsiElement psiElement = current2;
        if (psiElement == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    private static PsiElement @NotNull [] getAnonymousClasses(@NotNull PsiElement element2) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(16);
        }
        for (AnonymousElementProvider provider2 : AnonymousElementProvider.EP_NAME.getExtensionList()) {
            PsiElement[] elements = provider2.getAnonymousElements(element2);
            if (elements.length <= 0) continue;
            if (elements == null) {
                ClassSearchEverywhereContributor.$$$reportNull$$$0(17);
            }
            return elements;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(18);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    static PersistentSearchEverywhereContributorFilter<LanguageRef> createLanguageFilter(@NotNull Project project) {
        if (project == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(19);
        }
        List<LanguageRef> items = LanguageRef.forAllLanguages();
        GotoClassSymbolConfiguration persistentConfig = GotoClassSymbolConfiguration.getInstance(project);
        return new PersistentSearchEverywhereContributorFilter<LanguageRef>(items, persistentConfig, LanguageRef::getDisplayName, LanguageRef::getIcon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullGroupName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousClasses";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            SearchEverywhereContributor<Object> searchEverywhereContributor = PSIPresentationBgRendererWrapper.wrapIfNecessary(new ClassSearchEverywhereContributor(initEvent));
            if (searchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return searchEverywhereContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createContributor";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

