/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersStatisticsCollector;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMlService;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.FileTypeRef;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private static final Logger LOG = Logger.getInstance(FileSearchEverywhereContributor.class);
    private final GotoFileModel myModelForRenderer;
    private final PersistentSearchEverywhereContributorFilter<FileTypeRef> myFilter;

    public FileSearchEverywhereContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        super(event);
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        this.myModelForRenderer = new GotoFileModel(project);
        this.myFilter = FileSearchEverywhereContributor.createFileTypeFilter(project);
    }

    @NotNull
    public String getGroupName() {
        String string = IdeBundle.message((String)"search.everywhere.group.name.files", (Object[])new Object[0]);
        if (string == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getSortWeight() {
        return 200;
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (searchPattern == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        return super.getElementPriority(element2, searchPattern) + 2;
    }

    @NotNull
    protected FilteringGotoByModel<FileTypeRef> createModel(@NotNull Project project) {
        if (project == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        GotoFileModel model2 = new GotoFileModel(project);
        if (this.myFilter != null) {
            model2.setFilterItems(this.myFilter.getSelectedElements());
        }
        GotoFileModel gotoFileModel = model2;
        if (gotoFileModel == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        return gotoFileModel;
    }

    @Override
    @Nullable
    protected SearchEverywhereCommandInfo getFilterCommand() {
        return new SearchEverywhereCommandInfo("f", IdeBundle.message((String)"search.everywhere.filter.files.description", (Object[])new Object[0]), (SearchEverywhereContributor)this);
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        if (onChanged == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        List<AnAction> list2 = this.doGetActions(this.myFilter, new SearchEverywhereFiltersStatisticsCollector.FileTypeFilterCollector(), onChanged);
        if (list2 == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public ListCellRenderer<Object> getElementsRenderer() {
        return new SearchEverywherePsiRenderer((Disposable)this){

            @Override
            @NotNull
            public PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value2) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value2);
                if (!(value2 instanceof PsiFileSystemItem) || FileSearchEverywhereContributor.this.myModelForRenderer == null) {
                    PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
                    if (itemMatchers == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return itemMatchers;
                }
                PsiElementListCellRenderer.ItemMatchers itemMatchers = GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value2, FileSearchEverywhereContributor.this.myModelForRenderer);
                if (itemMatchers == null) {
                    1.$$$reportNull$$$0(3);
                }
                return itemMatchers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemMatchers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemMatchers";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected boolean processElement(@NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2, FilteringGotoByModel<?> model2, Object element2, int degree) {
        double mlWeight;
        if (progressIndicator == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        if (progressIndicator.isCanceled()) {
            return false;
        }
        if (element2 == null) {
            LOG.error("Null returned from " + model2 + " in " + this.getClass().getSimpleName());
            return true;
        }
        SearchEverywhereMlService mlService = SearchEverywhereMlService.getInstance();
        if (mlService != null && mlService.shouldOrderByMl(this.getClass().getSimpleName()) && (mlWeight = mlService.getMlWeight((SearchEverywhereContributor<?>)this, element2, degree)) >= 0.0) {
            return consumer2.process((Object)new FoundItemDescriptor(element2, degree, mlWeight));
        }
        return consumer2.process((Object)new FoundItemDescriptor(element2, degree));
    }

    @Override
    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
        VirtualFile file2;
        if (selected2 == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        if (searchText == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        if (selected2 instanceof PsiFile && (file2 = ((PsiFile)selected2).getVirtualFile()) != null && this.myProject != null) {
            Pair<Integer, Integer> pos = FileSearchEverywhereContributor.getLineAndColumn(searchText);
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, file2, ((Integer)pos.first).intValue(), ((Integer)pos.second).intValue());
            if (descriptor2.canNavigate()) {
                descriptor2.navigate(true);
                if ((Integer)pos.first > 0) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.file.line");
                }
                return true;
            }
        }
        return super.processSelectedItem(selected2, modifiers, searchText);
    }

    @Override
    public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
        if (element2 == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        if (dataId == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(13);
        }
        if (CommonDataKeys.PSI_FILE.is(dataId) && element2 instanceof PsiFile) {
            return element2;
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && (element2 instanceof PsiFile || element2 instanceof PsiDirectory)) {
            String basePath;
            String path2 = ((PsiFileSystemItem)element2).getVirtualFile().getPath();
            path2 = FileUtil.toSystemIndependentName((String)path2);
            if (this.myProject != null && (basePath = this.myProject.getBasePath()) != null) {
                path2 = FileUtil.getRelativePath((String)basePath, (String)path2, (char)'/');
            }
            return path2;
        }
        return super.getDataForItem(element2, dataId);
    }

    @NotNull
    public static PersistentSearchEverywhereContributorFilter<FileTypeRef> createFileTypeFilter(@NotNull Project project) {
        if (project == null) {
            FileSearchEverywhereContributor.$$$reportNull$$$0(14);
        }
        ArrayList<FileTypeRef> items = new ArrayList<FileTypeRef>(FileTypeRef.forAllFileTypes());
        items.add(0, GotoFileModel.DIRECTORY_FILE_TYPE_REF);
        return new PersistentSearchEverywhereContributorFilter<FileTypeRef>(items, GotoFileConfiguration.getInstance(project), FileTypeRef::getName, FileTypeRef::getIcon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFileTypeFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            SearchEverywhereContributor<Object> searchEverywhereContributor = PSIPresentationBgRendererWrapper.wrapIfNecessary(new FileSearchEverywhereContributor(initEvent));
            if (searchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return searchEverywhereContributor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/FileSearchEverywhereContributor$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createContributor";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

