/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\b\u0010%\u001a\u00020&H\u0002J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\u0012\u0010+\u001a\f0,\u00a2\u0006\u0002\b-\u00a2\u0006\u0002\b.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u000f\u00101\u001a\t\u0018\u000102\u00a2\u0006\u0002\b\nH\u0016J\b\u00103\u001a\u000204H\u0016J\u000f\u00105\u001a\t\u0018\u000102\u00a2\u0006\u0002\b\nH\u0016J\u000f\u00106\u001a\t\u0018\u000107\u00a2\u0006\u0002\b\nH\u0016J\n\u00108\u001a\u0004\u0018\u00010,H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010,2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020,H\u0016J\t\u0010<\u001a\u00020\u0012H\u00d6\u0001J\u0014\u0010=\u001a\u00020&2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020(0?J\b\u0010@\u001a\u00020&H\u0002J\t\u0010A\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006B"}, d2={"Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "(Lcom/intellij/ide/bookmark/LineBookmark;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/LineBookmark;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/Nullable;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "layer", "", "getLayer", "()I", "manager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "getManager", "()Lcom/intellij/ide/bookmark/BookmarksManager;", "markup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "getMarkup", "()Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "reference", "Ljava/lang/ref/WeakReference;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "getType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "component1", "copy", "createHighlighter", "", "equals", "", "other", "", "getAccessibleName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getIcon", "Ljavax/swing/Icon;", "getMiddleButtonClickAction", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getShortcut", "mnemonic", "", "getTooltipText", "hashCode", "refreshHighlighter", "release", "Lkotlin/Function0;", "releaseHighlighter", "toString", "intellij.platform.lang.impl"})
public final class GutterLineBookmarkRenderer
extends GutterIconRenderer
implements DumbAware {
    private WeakReference<RangeHighlighter> reference;
    @NotNull
    private final LineBookmark bookmark;

    private final BookmarksManager getManager() {
        return BookmarksManager.getInstance((Project)this.bookmark.getProvider().getProject());
    }

    private final BookmarkType getType() {
        BookmarksManager bookmarksManager = this.getManager();
        if (bookmarksManager == null || (bookmarksManager = bookmarksManager.getType((Bookmark)this.bookmark)) == null) {
            bookmarksManager = BookmarkType.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"manager?.getType(bookmark) ?: BookmarkType.DEFAULT");
        return bookmarksManager;
    }

    private final int getLayer() {
        return 5001;
    }

    private final Document getDocument() {
        return this.bookmark.getLine() < 0 ? null : FileDocumentManager.getInstance().getCachedDocument(this.bookmark.getFile());
    }

    private final MarkupModelEx getMarkup() {
        MarkupModelEx markupModelEx;
        Document document = this.getDocument();
        if (document != null) {
            Document document2 = document;
            boolean bl = false;
            boolean bl2 = false;
            Document it = document2;
            boolean bl3 = false;
            MarkupModel markupModel = DocumentMarkupModel.forDocument(it, this.bookmark.getProvider().getProject(), false);
            if (!(markupModel instanceof MarkupModelEx)) {
                markupModel = null;
            }
            markupModelEx = (MarkupModelEx)markupModel;
        } else {
            markupModelEx = null;
        }
        return markupModelEx;
    }

    private final RangeHighlighter getHighlighter() {
        RangeHighlighter rangeHighlighter;
        block4: {
            rangeHighlighter = this.reference;
            if (rangeHighlighter == null || (rangeHighlighter = (RangeHighlighter)rangeHighlighter.get()) == null) {
                RangeHighlighter[] rangeHighlighterArray = this.getMarkup();
                if (rangeHighlighterArray != null && (rangeHighlighterArray = rangeHighlighterArray.getAllHighlighters()) != null) {
                    RangeHighlighter[] rangeHighlighterArray2 = rangeHighlighterArray;
                    boolean bl = false;
                    RangeHighlighter[] rangeHighlighterArray3 = rangeHighlighterArray2;
                    boolean bl2 = false;
                    RangeHighlighter[] rangeHighlighterArray4 = rangeHighlighterArray3;
                    int n = rangeHighlighterArray4.length;
                    for (int j = 0; j < n; ++j) {
                        RangeHighlighter rangeHighlighter2;
                        RangeHighlighter it = rangeHighlighter2 = rangeHighlighterArray4[j];
                        boolean bl3 = false;
                        RangeHighlighter rangeHighlighter3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter3, (String)"it");
                        if (!Intrinsics.areEqual((Object)rangeHighlighter3.getGutterIconRenderer(), (Object)((Object)this))) continue;
                        rangeHighlighter = rangeHighlighter2;
                        break block4;
                    }
                    rangeHighlighter = null;
                } else {
                    rangeHighlighter = null;
                }
            }
        }
        return rangeHighlighter;
    }

    @NotNull
    public Icon getIcon() {
        return this.getType().getGutterIcon();
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.RIGHT;
    }

    @Nullable
    public AnAction getClickAction() {
        return ActionUtil.getAction((String)"ToggleBookmark");
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return ActionUtil.getAction((String)"EditBookmark");
    }

    @Nullable
    public ActionGroup getPopupMenuActions() {
        return ActionUtil.getActionGroup((String)"popup@BookmarkContextMenu");
    }

    @NotNull
    public String getAccessibleName() {
        String string = BookmarkBundle.message("accessible.name.icon.bookmark.0", this.getType());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"accessible.name.icon.bookmark.0\", type)");
        return string;
    }

    @NotNull
    public String getTooltipText() {
        Object shortcut;
        Object object;
        StringBuilder result2;
        block9: {
            block8: {
                BookmarksManager bookmarksManager;
                String description;
                Character mnemonic;
                result2 = new StringBuilder(BookmarkBundle.message("bookmark.text", new Object[0]));
                Object object2 = this.getType();
                boolean bl = false;
                boolean bl2 = false;
                BookmarkType it = object2;
                boolean bl3 = false;
                Character c = mnemonic = it == BookmarkType.DEFAULT ? null : Character.valueOf(it.getMnemonic());
                if (c != null) {
                    object2 = c;
                    bl = false;
                    bl2 = false;
                    char it2 = ((Character)object2).charValue();
                    boolean bl4 = false;
                    result2.append(" ").append(it2);
                }
                String string = description = (bookmarksManager = this.getManager()) != null && (bookmarksManager = bookmarksManager.getDefaultGroup()) != null ? bookmarksManager.getDescription((Bookmark)this.bookmark) : null;
                if (string != null) {
                    String string2 = string;
                    bl2 = false;
                    boolean bl5 = false;
                    String it3 = string2;
                    boolean bl6 = false;
                    CharSequence charSequence = it3;
                    boolean bl7 = false;
                    if (charSequence.length() > 0) {
                        result2.append(": ").append(StringUtil.escapeXmlEntities((String)it3));
                    }
                }
                if ((object = mnemonic) == null) break block8;
                Character c2 = object;
                boolean bl8 = false;
                boolean bl9 = false;
                char it4 = c2.charValue();
                boolean bl10 = false;
                object = this.getShortcut(it4);
                if (object != null) break block9;
            }
            object = this.getShortcut();
        }
        Object object3 = shortcut = object;
        if (object3 != null) {
            Object object4 = object3;
            boolean bl = false;
            boolean bl11 = false;
            Object it = object4;
            boolean bl12 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl13 = false;
            if (charSequence.length() > 0) {
                result2.append(" (").append((String)it).append(")");
            }
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final String getShortcut() {
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(\"ToggleBookmark\")");
        String toggle = string;
        CharSequence charSequence = toggle;
        boolean bl = false;
        return charSequence.length() > 0 ? BookmarkBundle.message("bookmark.shortcut.to.toggle", toggle) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getShortcut(char mnemonic) {
        String string;
        String string2 = KeymapUtil.getFirstKeyboardShortcutText((String)("ToggleBookmark" + mnemonic));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcut\u2026ToggleBookmark$mnemonic\")");
        String toggle = string2;
        String string3 = KeymapUtil.getFirstKeyboardShortcutText((String)("GotoBookmark" + mnemonic));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFirstKeyboardShortcut\u2026(\"GotoBookmark$mnemonic\")");
        String jump2 = string3;
        CharSequence charSequence = toggle;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = jump2;
            bl = false;
            if (charSequence.length() > 0) {
                string = BookmarkBundle.message("bookmark.shortcut.to.toggle.and.jump", toggle, jump2);
                return string;
            }
        }
        charSequence = toggle;
        bl = false;
        if (charSequence.length() > 0) {
            string = BookmarkBundle.message("bookmark.shortcut.to.toggle", toggle);
            return string;
        }
        charSequence = jump2;
        bl = false;
        if (charSequence.length() <= 0) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        string = BookmarkBundle.message("bookmark.shortcut.to.jump", jump2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void createHighlighter() {
        WeakReference<void> weakReference;
        GutterLineBookmarkRenderer gutterLineBookmarkRenderer = this;
        Object object = this.getMarkup();
        if (object != null && (object = object.addPersistentLineHighlighter(CodeInsightColors.BOOKMARKS_ATTRIBUTES, this.bookmark.getLine(), this.getLayer())) != null) {
            void it;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object object3 = object2;
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer2 = gutterLineBookmarkRenderer;
            boolean bl3 = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            v2.setGutterIconRenderer((GutterIconRenderer)this);
            it.setErrorStripeTooltip((Object)this.getTooltipText());
            WeakReference<void> weakReference2 = new WeakReference<void>(it);
            gutterLineBookmarkRenderer = gutterLineBookmarkRenderer2;
            weakReference = weakReference2;
        } else {
            weakReference = null;
        }
        gutterLineBookmarkRenderer.reference = weakReference;
    }

    private final void releaseHighlighter() {
        RangeHighlighter rangeHighlighter = this.getHighlighter();
        if (rangeHighlighter != null) {
            rangeHighlighter.dispose();
        }
        this.reference = null;
    }

    public final void refreshHighlighter(@NotNull Function0<Boolean> release2) {
        Intrinsics.checkNotNullParameter(release2, (String)"release");
        AppUIUtil.invokeLaterIfProjectAlive(this.bookmark.getProvider().getProject(), new Runnable(this, release2){
            final /* synthetic */ GutterLineBookmarkRenderer this$0;
            final /* synthetic */ Function0 $release;

            public final void run() {
                block3: {
                    RangeHighlighter rangeHighlighter;
                    block4: {
                        block2: {
                            boolean bl = (Boolean)this.$release.invoke();
                            if (!bl) break block2;
                            GutterLineBookmarkRenderer.access$releaseHighlighter(this.this$0);
                            break block3;
                        }
                        rangeHighlighter = GutterLineBookmarkRenderer.access$getHighlighter$p(this.this$0);
                        if (rangeHighlighter == null) break block4;
                        RangeHighlighter rangeHighlighter2 = rangeHighlighter;
                        boolean bl = false;
                        boolean bl2 = false;
                        RangeHighlighter it = rangeHighlighter2;
                        boolean bl3 = false;
                        it.setGutterIconRenderer((GutterIconRenderer)null);
                        it.setGutterIconRenderer((GutterIconRenderer)this.this$0);
                        rangeHighlighter = rangeHighlighter2;
                        if (rangeHighlighter != null) break block3;
                    }
                    GutterLineBookmarkRenderer.access$createHighlighter(this.this$0);
                    rangeHighlighter = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = gutterLineBookmarkRenderer;
                this.$release = function0;
            }
        });
    }

    @NotNull
    public final LineBookmark getBookmark() {
        return this.bookmark;
    }

    public GutterLineBookmarkRenderer(@NotNull LineBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmark = bookmark;
    }

    public static final /* synthetic */ void access$releaseHighlighter(GutterLineBookmarkRenderer $this) {
        $this.releaseHighlighter();
    }

    public static final /* synthetic */ RangeHighlighter access$getHighlighter$p(GutterLineBookmarkRenderer $this) {
        return $this.getHighlighter();
    }

    public static final /* synthetic */ void access$createHighlighter(GutterLineBookmarkRenderer $this) {
        $this.createHighlighter();
    }

    @NotNull
    public final LineBookmark component1() {
        return this.bookmark;
    }

    @NotNull
    public final GutterLineBookmarkRenderer copy(@NotNull LineBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        return new GutterLineBookmarkRenderer(bookmark);
    }

    public static /* synthetic */ GutterLineBookmarkRenderer copy$default(GutterLineBookmarkRenderer gutterLineBookmarkRenderer, LineBookmark lineBookmark, int n, Object object) {
        if ((n & 1) != 0) {
            lineBookmark = gutterLineBookmarkRenderer.bookmark;
        }
        return gutterLineBookmarkRenderer.copy(lineBookmark);
    }

    @NotNull
    public String toString() {
        return "GutterLineBookmarkRenderer(bookmark=" + this.bookmark + ")";
    }

    public int hashCode() {
        LineBookmark lineBookmark = this.bookmark;
        return lineBookmark != null ? lineBookmark.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GutterLineBookmarkRenderer)) break block3;
                GutterLineBookmarkRenderer gutterLineBookmarkRenderer = (GutterLineBookmarkRenderer)((Object)object);
                if (!Intrinsics.areEqual((Object)this.bookmark, (Object)gutterLineBookmarkRenderer.bookmark)) break block3;
            }
            return true;
        }
        return false;
    }
}

