/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.ide.bookmark.actions.GotoBookmarkTypeAction;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.BookmarksViewState;
import com.intellij.ide.bookmark.ui.tree.GroupNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u001c\u0010*\u001a\u00020+*\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020)H\u0000\u001a\u0014\u0010/\u001a\u00020+*\u00020,2\u0006\u0010-\u001a\u00020.H\u0000\"\u001f\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001f\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0012\"\u001a\u0010\u0013\u001a\u0004\u0018\u00010\r*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000f\"\u001a\u0010\u0015\u001a\u0004\u0018\u00010\r*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000f\"\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u0003*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u001a\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00060"}, d2={"bookmarksManager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/ide/bookmark/Bookmark;", "getBookmarksManager", "(Lcom/intellij/ide/bookmark/Bookmark;)Lcom/intellij/ide/bookmark/BookmarksManager;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ide/bookmark/BookmarksManager;", "bookmarksToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getBookmarksToolWindow", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/wm/ToolWindow;", "bookmarksView", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "getBookmarksView", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ide/bookmark/ui/BookmarksView;", "(Lcom/intellij/openapi/wm/ToolWindow;)Lcom/intellij/ide/bookmark/ui/BookmarksView;", "Ljava/awt/Component;", "(Ljava/awt/Component;)Lcom/intellij/ide/bookmark/ui/BookmarksView;", "bookmarksViewFromComponent", "getBookmarksViewFromComponent", "bookmarksViewFromToolWindow", "getBookmarksViewFromToolWindow", "bookmarksViewState", "Lcom/intellij/ide/bookmark/ui/BookmarksViewState;", "getBookmarksViewState", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ide/bookmark/ui/BookmarksViewState;", "contextBookmark", "getContextBookmark", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ide/bookmark/Bookmark;", "firstGroupWithDescription", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "getFirstGroupWithDescription", "(Lcom/intellij/ide/bookmark/Bookmark;)Lcom/intellij/ide/bookmark/BookmarkGroup;", "selectedGroupNode", "Lcom/intellij/ide/bookmark/ui/tree/GroupNode;", "getSelectedGroupNode", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ide/bookmark/ui/tree/GroupNode;", "createBookmarkTypeAction", "Lcom/intellij/ide/bookmark/actions/GotoBookmarkTypeAction;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "registerBookmarkTypeAction", "", "Ljavax/swing/JComponent;", "parent", "Lcom/intellij/openapi/Disposable;", "registerEditSourceAction", "intellij.platform.lang.impl"})
public final class ExtensionsKt {
    @Nullable
    public static final BookmarksManager getBookmarksManager(@NotNull AnActionEvent $this$bookmarksManager) {
        BookmarksManager bookmarksManager;
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksManager, (String)"$this$bookmarksManager");
        Project project = $this$bookmarksManager.getProject();
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            bookmarksManager = BookmarksManager.getInstance((Project)it);
        } else {
            bookmarksManager = null;
        }
        return bookmarksManager;
    }

    @Nullable
    public static final BookmarksViewState getBookmarksViewState(@NotNull AnActionEvent $this$bookmarksViewState) {
        BookmarksViewState bookmarksViewState;
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksViewState, (String)"$this$bookmarksViewState");
        Project project = $this$bookmarksViewState.getProject();
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            Project project3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
            bookmarksViewState = BookmarksViewState.Companion.getInstance(project3);
        } else {
            bookmarksViewState = null;
        }
        return bookmarksViewState;
    }

    @Nullable
    public static final ToolWindow getBookmarksToolWindow(@NotNull AnActionEvent $this$bookmarksToolWindow) {
        ToolWindow toolWindow2;
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksToolWindow, (String)"$this$bookmarksToolWindow");
        Project project = $this$bookmarksToolWindow.getProject();
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            Project project3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
            toolWindow2 = ToolWindowManager.Companion.getInstance(project3).getToolWindow("Bookmarks");
        } else {
            toolWindow2 = null;
        }
        return toolWindow2;
    }

    @Nullable
    public static final BookmarksView getBookmarksViewFromToolWindow(@NotNull AnActionEvent $this$bookmarksViewFromToolWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksViewFromToolWindow, (String)"$this$bookmarksViewFromToolWindow");
        ToolWindow toolWindow2 = (ToolWindow)$this$bookmarksViewFromToolWindow.getDataContext().getData(PlatformDataKeys.TOOL_WINDOW);
        return toolWindow2 != null ? ExtensionsKt.getBookmarksView(toolWindow2) : null;
    }

    @Nullable
    public static final BookmarksView getBookmarksViewFromComponent(@NotNull AnActionEvent $this$bookmarksViewFromComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksViewFromComponent, (String)"$this$bookmarksViewFromComponent");
        Component component2 = (Component)$this$bookmarksViewFromComponent.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT);
        return component2 != null ? ExtensionsKt.getBookmarksView(component2) : null;
    }

    @Nullable
    public static final BookmarksView getBookmarksView(@NotNull AnActionEvent $this$bookmarksView) {
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksView, (String)"$this$bookmarksView");
        BookmarksView bookmarksView = ExtensionsKt.getBookmarksViewFromComponent($this$bookmarksView);
        if (bookmarksView == null) {
            bookmarksView = ExtensionsKt.getBookmarksViewFromToolWindow($this$bookmarksView);
        }
        return bookmarksView;
    }

    @Nullable
    public static final BookmarksView getBookmarksView(@NotNull ToolWindow $this$bookmarksView) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksView, (String)"$this$bookmarksView");
        ContentManager contentManager2 = $this$bookmarksView.getContentManagerIfCreated();
        if (!((contentManager2 != null && (contentManager2 = contentManager2.getSelectedContent()) != null ? contentManager2.getComponent() : (jComponent = null)) instanceof BookmarksView)) {
            jComponent = null;
        }
        return (BookmarksView)((Object)jComponent);
    }

    private static final BookmarksView getBookmarksView(Component $this$bookmarksView) {
        BookmarksView bookmarksView;
        Component component2 = $this$bookmarksView;
        if (!(component2 instanceof BookmarksView)) {
            component2 = null;
        }
        if ((bookmarksView = (BookmarksView)((Object)component2)) == null) {
            Container container = $this$bookmarksView.getParent();
            bookmarksView = container != null ? ExtensionsKt.getBookmarksView(container) : null;
        }
        return bookmarksView;
    }

    @Nullable
    public static final GroupNode getSelectedGroupNode(@NotNull AnActionEvent $this$selectedGroupNode) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedGroupNode, (String)"$this$selectedGroupNode");
        BookmarksView bookmarksView = ExtensionsKt.getBookmarksView($this$selectedGroupNode);
        Object object = bookmarksView != null ? bookmarksView.getSelectedNode() : null;
        if (!(object instanceof GroupNode)) {
            object = null;
        }
        return (GroupNode)((Object)object);
    }

    @Nullable
    public static final Bookmark getContextBookmark(@NotNull AnActionEvent $this$contextBookmark) {
        Bookmark bookmark;
        boolean bl;
        ToolWindow window;
        Editor editor2;
        Editor editor3;
        Intrinsics.checkNotNullParameter((Object)$this$contextBookmark, (String)"$this$contextBookmark");
        Editor editor4 = (Editor)$this$contextBookmark.getData(CommonDataKeys.EDITOR);
        if (editor4 == null) {
            editor4 = (Editor)$this$contextBookmark.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        }
        if ((editor3 = (editor2 = editor4)) == null || (editor3 = editor3.getProject()) == null) {
            editor3 = $this$contextBookmark.getProject();
        }
        if (editor3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor?.project ?: project ?: return null");
        Editor project = editor3;
        if (editor2 != null) {
            LineBookmarkProvider lineBookmarkProvider = LineBookmarkProvider.Companion.find((Project)project);
            if (lineBookmarkProvider == null) {
                return null;
            }
            LineBookmarkProvider provider2 = lineBookmarkProvider;
            Integer line = (Integer)$this$contextBookmark.getData(EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR);
            if (line != null && Intrinsics.areEqual((Object)$this$contextBookmark.getPlace(), (Object)"mouse shortcut")) {
                EditorGutterComponentEx gutter;
                Object object = $this$contextBookmark.getData(PlatformDataKeys.CONTEXT_COMPONENT);
                if (!(object instanceof EditorGutterComponentEx)) {
                    object = null;
                }
                if ((gutter = (EditorGutterComponentEx)object) != null && gutter.isShowing()) {
                    Serializable serializable;
                    InputEvent inputEvent = $this$contextBookmark.getInputEvent();
                    if (!(inputEvent instanceof MouseEvent)) {
                        inputEvent = null;
                    }
                    if ((serializable = (MouseEvent)inputEvent) != null) {
                        MouseEvent mouseEvent = serializable;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        MouseEvent $this$run = mouseEvent;
                        boolean bl4 = false;
                        serializable = $this$run.getLocationOnScreen();
                        if (serializable != null) {
                            mouseEvent = serializable;
                            bl2 = false;
                            bl3 = false;
                            MouseEvent it = mouseEvent;
                            boolean bl5 = false;
                            SwingUtilities.convertPointFromScreen((Point)((Object)it), gutter);
                            serializable = mouseEvent;
                            if (serializable != null) {
                                mouseEvent = serializable;
                                bl2 = false;
                                bl3 = false;
                                it = mouseEvent;
                                boolean bl6 = false;
                                int n = editor2.xyToLogicalPosition((Point)((Object)it)).line;
                                bl2 = false;
                                bl3 = false;
                                int it2 = n;
                                boolean bl7 = false;
                                if (it2 >= 0) {
                                    line = it2;
                                }
                            }
                        }
                    }
                }
            }
            return (Bookmark)provider2.createBookmark(editor2, line);
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)project);
        if (bookmarksManager == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInst\u2026e(project) ?: return null");
        BookmarksManager manager2 = bookmarksManager;
        ToolWindow toolWindow2 = window = (ToolWindow)$this$contextBookmark.getData(PlatformDataKeys.TOOL_WINDOW);
        if (Intrinsics.areEqual((Object)(toolWindow2 != null ? toolWindow2.getId() : null), (Object)"Bookmarks")) {
            return null;
        }
        Component component2 = (Component)$this$contextBookmark.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Boolean bl8 = (Boolean)UIUtil.getClientProperty((Object)component2, (Key)BookmarksManager.ALLOWED);
        if (bl8 != null) {
            bl = bl8;
        } else {
            ToolWindow toolWindow3 = window;
            bl = Intrinsics.areEqual((Object)(toolWindow3 != null ? toolWindow3.getId() : null), (Object)"Project");
        }
        boolean allowed = bl;
        if (!allowed) {
            bookmark = null;
        } else if (component2 instanceof JTree) {
            TreePath path2 = TreeUtil.getSelectedPathIfOne((JTree)((JTree)component2));
            bookmark = manager2.createBookmark((Object)path2);
            if (bookmark == null) {
                Object node2 = TreeUtil.getLastUserObject((TreePath)path2);
                bookmark = node2 instanceof AbstractTreeNode ? manager2.createBookmark(((AbstractTreeNode)node2).getValue()) : (node2 instanceof NodeDescriptor ? manager2.createBookmark(((NodeDescriptor)node2).getElement()) : manager2.createBookmark(node2));
            }
        } else {
            bookmark = manager2.createBookmark($this$contextBookmark.getData(CommonDataKeys.PSI_ELEMENT));
            if (bookmark == null) {
                bookmark = manager2.createBookmark($this$contextBookmark.getData(CommonDataKeys.VIRTUAL_FILE));
            }
        }
        return bookmark;
    }

    @Nullable
    public static final BookmarksManager getBookmarksManager(@NotNull Bookmark $this$bookmarksManager) {
        Intrinsics.checkNotNullParameter((Object)$this$bookmarksManager, (String)"$this$bookmarksManager");
        return BookmarksManager.getInstance((Project)$this$bookmarksManager.getProvider().getProject());
    }

    @Nullable
    public static final BookmarkGroup getFirstGroupWithDescription(@NotNull Bookmark $this$firstGroupWithDescription) {
        BookmarkGroup bookmarkGroup;
        Intrinsics.checkNotNullParameter((Object)$this$firstGroupWithDescription, (String)"$this$firstGroupWithDescription");
        Object object = ExtensionsKt.getBookmarksManager($this$firstGroupWithDescription);
        if (object != null && (object = object.getGroups($this$firstGroupWithDescription)) != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BookmarkGroup it = (BookmarkGroup)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = it.getDescription($this$firstGroupWithDescription);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            bookmarkGroup = v1;
        } else {
            bookmarkGroup = null;
        }
        return bookmarkGroup;
    }

    public static final void registerBookmarkTypeAction(@NotNull JComponent $this$registerBookmarkTypeAction, @NotNull Disposable parent, @NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBookmarkTypeAction, (String)"$this$registerBookmarkTypeAction");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ExtensionsKt.createBookmarkTypeAction(type).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{String.valueOf(type.getMnemonic())}), $this$registerBookmarkTypeAction, parent);
    }

    private static final GotoBookmarkTypeAction createBookmarkTypeAction(BookmarkType type) {
        return new GotoBookmarkTypeAction(type, (Function1<? super AnActionEvent, Boolean>)((Function1)createBookmarkTypeAction.1.INSTANCE));
    }

    public static final void registerEditSourceAction(@NotNull JComponent $this$registerEditSourceAction, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)$this$registerEditSourceAction, (String)"$this$registerEditSourceAction");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LightEditActionFactory.create((Consumer)registerEditSourceAction.1.INSTANCE).registerCustomShortcutSet(CommonShortcuts.getEditSource(), $this$registerEditSourceAction, parent);
    }
}

