/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.InvalidBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.bookmark.ui.tree.LineNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 H2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001HB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J!\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010)J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010*\u001a\u00020\u00102\b\b\u0002\u0010(\u001a\u00020 J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010-\u001a\u00020\u0012H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\"2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u001a\u0010$\u001a\u00020\"2\u0006\u00100\u001a\u0002012\b\b\u0002\u0010(\u001a\u00020 H\u0002J\u001e\u0010$\u001a\u0004\u0018\u00010\"2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020103H\u0016J\u001a\u00104\u001a\u0002052\u0006\u00100\u001a\u0002012\b\b\u0002\u0010(\u001a\u00020 H\u0002J\u001c\u00106\u001a\u0004\u0018\u00010%2\u0006\u00100\u001a\u0002012\b\b\u0002\u0010(\u001a\u00020 H\u0002J\b\u00107\u001a\u00020\u0006H\u0016J\b\u00108\u001a\u00020 H\u0016J\u0014\u00109\u001a\u00020\u00162\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u0017H\u0016J\u0018\u0010>\u001a\u0004\u0018\u00010?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0016J$\u0010C\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030;0A2\u0010\u0010D\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030;0AH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\"2\u0006\u0010F\u001a\u00020\"H\u0002J\b\u0010G\u001a\u00020\u001cH\u0002R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u001a\u00a8\u0006I"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener$Simple;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "VFM", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "Lorg/jetbrains/annotations/NotNull;", "getVFM", "()Lcom/intellij/openapi/vfs/VirtualFileManager;", "validateAlarm", "Lcom/intellij/util/SingleAlarm;", "asVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "Ljavax/swing/tree/TreePath;", "getAsVirtualFile", "(Ljavax/swing/tree/TreePath;)Lcom/intellij/openapi/vfs/VirtualFile;", "isUnexpected", "", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "(Lcom/intellij/openapi/editor/event/EditorMouseEvent;)Z", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "afterDocumentChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "compare", "", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "createBookmark", "Lcom/intellij/ide/bookmark/FileBookmark;", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/ide/bookmark/FileBookmark;", "file", "element", "Lcom/intellij/psi/PsiElement;", "path", "context", "", "url", "", "map", "", "createInvalidBookmark", "Lcom/intellij/ide/bookmark/providers/InvalidBookmark;", "createValidBookmark", "getProject", "getWeight", "isNodeVisible", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "mouseClicked", "event", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "prepareGroup", "nodes", "validate", "bookmark", "validateAndUpdate", "Companion", "intellij.platform.lang.impl"})
public final class LineBookmarkProvider
implements BookmarkProvider,
EditorMouseListener,
BulkAwareDocumentListener.Simple,
AsyncFileListener {
    private final SingleAlarm validateAlarm;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public int getWeight() {
        return Integer.MIN_VALUE;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        Bookmark bookmark = bookmark1;
        if (!(bookmark instanceof FileBookmark)) {
            bookmark = null;
        }
        FileBookmark fileBookmark1 = (FileBookmark)bookmark;
        Bookmark bookmark3 = bookmark2;
        if (!(bookmark3 instanceof FileBookmark)) {
            bookmark3 = null;
        }
        FileBookmark fileBookmark2 = (FileBookmark)bookmark3;
        if (fileBookmark1 == null && fileBookmark2 == null) {
            return 0;
        }
        if (fileBookmark1 == null) {
            return -1;
        }
        if (fileBookmark2 == null) {
            return 1;
        }
        VirtualFile file1 = fileBookmark1.getFile();
        if (Intrinsics.areEqual((Object)file1, (Object)(file2 = fileBookmark2.getFile()))) {
            Bookmark bookmark4 = bookmark1;
            if (!(bookmark4 instanceof LineBookmark)) {
                bookmark4 = null;
            }
            LineBookmark lineBookmark1 = (LineBookmark)bookmark4;
            Bookmark bookmark5 = bookmark2;
            if (!(bookmark5 instanceof LineBookmark)) {
                bookmark5 = null;
            }
            LineBookmark lineBookmark2 = (LineBookmark)bookmark5;
            if (lineBookmark1 == null && lineBookmark2 == null) {
                return 0;
            }
            if (lineBookmark1 == null) {
                return -1;
            }
            if (lineBookmark2 == null) {
                return 1;
            }
            return Intrinsics.compare((int)lineBookmark1.getLine(), (int)lineBookmark2.getLine());
        }
        if (file1.isDirectory() && !file2.isDirectory()) {
            return -1;
        }
        if (!file1.isDirectory() && file2.isDirectory()) {
            return 1;
        }
        return StringUtil.naturalCompare((String)file1.getPresentableName(), (String)file2.getPresentableName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AbstractTreeNode<?>> prepareGroup(@NotNull List<? extends AbstractTreeNode<?>> nodes) {
        Unit unit;
        Object element$iv$iv;
        Object $this$mapNotNullTo$iv$iv;
        Object $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Iterable $this$filter$iv;
        BookmarkNode bookmarkNode;
        boolean bl;
        Iterable $i$f$forEach232;
        Object it;
        block17: {
            Object element$iv22;
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Iterable $this$forEach$iv = nodes;
            boolean $i$f$forEach232 = false;
            for (Object element$iv22 : $this$forEach$iv) {
                it = (AbstractTreeNode)element$iv22;
                boolean bl2 = false;
                AbstractTreeNode abstractTreeNode = it;
                if (!(abstractTreeNode instanceof FileNode)) {
                    abstractTreeNode = null;
                }
                FileNode fileNode = (FileNode)abstractTreeNode;
                if (fileNode == null) continue;
                fileNode.ungroup();
            }
            $i$f$forEach232 = nodes;
            bl = false;
            element$iv22 = $i$f$forEach232.iterator();
            while (element$iv22.hasNext()) {
                Object it2 = it = element$iv22.next();
                boolean bl3 = false;
                Object object = it2;
                if (!(object instanceof LineNode)) {
                    object = null;
                }
                if ((it2 = (LineNode)((Object)object)) == null) continue;
                bookmarkNode = it2;
                break block17;
            }
            bookmarkNode = null;
        }
        if (bookmarkNode == null) {
            $i$f$forEach232 = nodes;
            LineBookmarkProvider lineBookmarkProvider = this;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv2 = iterator2.next();
                AbstractTreeNode p1 = (AbstractTreeNode)element$iv$iv2;
                boolean bl4 = false;
                if (!lineBookmarkProvider.isNodeVisible(p1)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            return (List)destination$iv$iv;
        }
        BookmarkNode node2 = bookmarkNode;
        BookmarksView bookmarksView = node2.getBookmarksView();
        if (bookmarksView == null || (bookmarksView = bookmarksView.getGroupLineBookmarks()) == null || !bookmarksView.isSelected()) {
            $this$filter$iv = nodes;
            LineBookmarkProvider lineBookmarkProvider = this;
            boolean $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv$iv3 = iterator3.next();
                AbstractTreeNode p1 = (AbstractTreeNode)element$iv$iv3;
                boolean bl5 = false;
                if (!lineBookmarkProvider.isNodeVisible(p1)) continue;
                destination$iv$iv.add(element$iv$iv3);
            }
            return (List)destination$iv$iv;
        }
        bl = false;
        Map map2 = new LinkedHashMap();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractTreeNode it3 = (AbstractTreeNode)element$iv;
            boolean bl6 = false;
            AbstractTreeNode element$iv$iv3 = it3;
            if (element$iv$iv3 instanceof LineNode) {
                map2.putIfAbsent(((LineNode)it3).getVirtualFile(), null);
                continue;
            }
            if (!(element$iv$iv3 instanceof FileNode)) continue;
            map2.put(((FileNode)it3).getVirtualFile(), it3);
        }
        Object $this$mapNotNull$iv = map2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach322 = false;
        void var11_38 = $this$forEach$iv$iv$iv;
        boolean bl5 = false;
        for (Map.Entry entry2 : var11_38.entrySet()) {
            VirtualFile virtualFile2;
            element$iv$iv = entry2;
            boolean bl7 = false;
            Map.Entry it4 = element$iv$iv;
            boolean bl8 = false;
            if ((it4.getValue() == null ? (VirtualFile)it4.getKey() : null) == null) continue;
            virtualFile2 = virtualFile2;
            boolean bl2 = false;
            boolean bl3 = false;
            VirtualFile it$iv$iv = virtualFile2;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$apply;
            VirtualFile it5 = (VirtualFile)element$iv;
            boolean bl12 = false;
            FileNode $i$f$forEach322 = new FileNode(this.project, new FileBookmarkImpl(this, it5));
            boolean bl13 = false;
            bl5 = false;
            Object object = $i$f$forEach322;
            VirtualFile virtualFile3 = it5;
            element$iv$iv = map2;
            boolean bl14 = false;
            $this$apply.setBookmarkGroup(node2.getBookmarkGroup());
            $this$apply.setParent(node2.getParent());
            unit = Unit.INSTANCE;
            element$iv$iv.put(virtualFile3, $i$f$forEach322);
        }
        $this$mapNotNull$iv = nodes;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach4 = false;
        Iterator iterator4 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator4.hasNext()) {
            AbstractTreeNode abstractTreeNode;
            Object element$iv$iv$iv;
            Object element$iv$iv4 = element$iv$iv$iv = iterator4.next();
            boolean bl4 = false;
            AbstractTreeNode it6 = (AbstractTreeNode)element$iv$iv4;
            boolean bl16 = false;
            if (!this.isNodeVisible(it6)) {
                abstractTreeNode = null;
            } else if (it6 instanceof LineNode) {
                Object v = map2.get(((LineNode)it6).getVirtualFile());
                Intrinsics.checkNotNull(v);
                abstractTreeNode = (AbstractTreeNode)((FileNode)((Object)v)).grouped(it6);
            } else {
                abstractTreeNode = it6 instanceof FileNode ? (AbstractTreeNode)((FileNode)it6).grouped() : it6;
            }
            if (abstractTreeNode == null) continue;
            unit = abstractTreeNode;
            boolean bl6 = false;
            boolean bl7 = false;
            Unit it$iv$iv = unit;
            boolean bl19 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Bookmark createBookmark(@NotNull Map<String, String> map2) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        String string = map2.get("url");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            bookmark = this.createBookmark(it, StringUtil.parseInt((String)map2.get("line"), (int)-1));
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    @Nullable
    public Bookmark createBookmark(@Nullable Object context2) {
        Object object;
        Object object2 = context2;
        if (object2 instanceof com.intellij.ide.bookmarks.Bookmark) {
            VirtualFile virtualFile2 = ((com.intellij.ide.bookmarks.Bookmark)context2).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"context.file");
            object = (Bookmark)this.createBookmark(virtualFile2, ((com.intellij.ide.bookmarks.Bookmark)context2).getLine());
        } else if (object2 instanceof DirectoryUrl) {
            String string = ((DirectoryUrl)context2).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.url");
            object = LineBookmarkProvider.createBookmark$default(this, string, 0, 2, null);
        } else if (object2 instanceof PsiFileUrl) {
            String string = ((PsiFileUrl)context2).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.url");
            object = LineBookmarkProvider.createBookmark$default(this, string, 0, 2, null);
        } else if (object2 instanceof PsiElement) {
            object = (Bookmark)this.createBookmark((PsiElement)context2);
        } else if (object2 instanceof VirtualFile) {
            object = (Bookmark)this.createBookmark((VirtualFile)context2, -1);
        } else if (object2 instanceof ProjectFileNode) {
            VirtualFile virtualFile3 = ((ProjectFileNode)context2).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"context.virtualFile");
            object = (Bookmark)LineBookmarkProvider.createBookmark$default(this, virtualFile3, 0, 2, null);
        } else {
            object = object2 instanceof TreePath ? (Bookmark)this.createBookmark((TreePath)context2) : null;
        }
        return object;
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return !file2.isValid() || file2 instanceof LightVirtualFile ? null : (line >= 0 ? (FileBookmark)new LineBookmarkImpl(this, file2, line) : (FileBookmark)new FileBookmarkImpl(this, file2));
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, VirtualFile virtualFile2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(virtualFile2, n);
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull Editor editor2, @Nullable Integer line) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"FileDocumentManager.getI\u2026.document) ?: return null");
        VirtualFile file2 = virtualFile2;
        Integer n2 = line;
        if (n2 != null) {
            n = n2;
        } else {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            n = caretModel.getLogicalPosition().line;
        }
        return this.createBookmark(file2, n);
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, Editor editor2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return lineBookmarkProvider.createBookmark(editor2, n);
    }

    private final Bookmark createBookmark(String url, int line) {
        FileBookmark fileBookmark = this.createValidBookmark(url, line);
        return fileBookmark != null ? (Bookmark)fileBookmark : (Bookmark)this.createInvalidBookmark(url, line);
    }

    static /* synthetic */ Bookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(string, n);
    }

    private final FileBookmark createValidBookmark(String url, int line) {
        FileBookmark fileBookmark;
        VirtualFile virtualFile2 = this.getVFM().findFileByUrl(url);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile3;
            boolean bl3 = false;
            VirtualFile virtualFile4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
            fileBookmark = this.createBookmark(virtualFile4, line);
        } else {
            fileBookmark = null;
        }
        return fileBookmark;
    }

    static /* synthetic */ FileBookmark createValidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createValidBookmark(string, n);
    }

    private final InvalidBookmark createInvalidBookmark(String url, int line) {
        return new InvalidBookmark(this, url, line);
    }

    static /* synthetic */ InvalidBookmark createInvalidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createInvalidBookmark(string, n);
    }

    private final FileBookmark createBookmark(PsiElement element2) {
        if (element2 instanceof PsiFileSystemItem) {
            FileBookmark fileBookmark;
            VirtualFile virtualFile2 = ((PsiFileSystemItem)element2).getVirtualFile();
            if (virtualFile2 != null) {
                VirtualFile virtualFile3 = virtualFile2;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile3;
                boolean bl3 = false;
                fileBookmark = LineBookmarkProvider.createBookmark$default(this, it, 0, 2, null);
            } else {
                fileBookmark = null;
            }
            return fileBookmark;
        }
        if (element2 instanceof PsiCompiledElement) {
            return null;
        }
        VirtualFile virtualFile4 = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (virtualFile4 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"PsiUtilCore.getVirtualFile(element) ?: return null");
        VirtualFile file2 = virtualFile4;
        if (file2 instanceof LightVirtualFile) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
        Document document2 = document;
        int offset = element2.getTextOffset();
        int n = offset;
        return 0 <= n && document2.getTextLength() >= n ? this.createBookmark(file2, document2.getLineNumber(offset)) : null;
    }

    private final FileBookmark createBookmark(TreePath path2) {
        VirtualFile virtualFile2 = this.getAsVirtualFile(path2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        TreePath treePath = path2.getParentPath();
        if (treePath == null || (treePath = this.getAsVirtualFile(treePath)) == null) {
            return null;
        }
        TreePath parent = treePath;
        return !parent.isDirectory() || Intrinsics.areEqual((Object)file2.getParent(), (Object)parent) ^ true ? null : LineBookmarkProvider.createBookmark$default(this, file2, 0, 2, null);
    }

    private final VirtualFile getAsVirtualFile(TreePath $this$asVirtualFile) {
        ProjectViewNode projectViewNode = (ProjectViewNode)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)$this$asVirtualFile);
        return projectViewNode != null ? projectViewNode.getVirtualFile() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(MouseEvent $this$isUnexpected) {
        if (!SwingUtilities.isLeftMouseButton($this$isUnexpected)) return true;
        if ($this$isUnexpected.isPopupTrigger()) return true;
        if (SystemInfo.isMac) {
            if ($this$isUnexpected.isMetaDown()) return false;
            return true;
        }
        if ($this$isUnexpected.isControlDown()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(EditorMouseEvent $this$isUnexpected) {
        if ($this$isUnexpected.isConsumed()) return true;
        if (Intrinsics.areEqual((Object)$this$isUnexpected.getArea(), (Object)EditorMouseEventArea.LINE_MARKERS_AREA) ^ true) return true;
        MouseEvent mouseEvent = $this$isUnexpected.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"mouseEvent");
        if (!this.isUnexpected(mouseEvent)) return false;
        return true;
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isUnexpected(event)) {
            return;
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
        if (bookmarksManager == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInstance(project) ?: return");
        BookmarksManager manager2 = bookmarksManager;
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.editor");
        FileBookmark fileBookmark = this.createBookmark(editor2, (Integer)event.getLogicalPosition().line);
        if (fileBookmark == null) {
            return;
        }
        FileBookmark bookmark = fileBookmark;
        BookmarkType bookmarkType = manager2.getType((Bookmark)bookmark);
        if (bookmarkType != null) {
            BookmarkType bookmarkType2 = bookmarkType;
            boolean bl = false;
            boolean bl2 = false;
            BookmarkType it = bookmarkType2;
            boolean bl3 = false;
            manager2.remove((Bookmark)bookmark);
        } else {
            manager2.add((Bookmark)bookmark, BookmarkType.DEFAULT);
        }
        event.consume();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void afterDocumentChange(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        v0 = FileDocumentManager.getInstance().getFile(document);
        if (v0 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
        file = v0;
        if (file instanceof LightVirtualFile) {
            return;
        }
        v1 = BookmarksManager.getInstance((Project)this.project);
        if (v1 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"BookmarksManager.getInstance(project) ?: return");
        manager = v1;
        var5_4 = false;
        map = MapsKt.sortedMapOf((Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LineBookmarkImpl it = (LineBookmarkImpl)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getLine());
                it = (LineBookmarkImpl)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Integer.valueOf(it.getLine());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, (Pair[])new Pair[0]);
        var6_7 = false;
        set = new LinkedHashSet<E>();
        for (Bookmark bookmark : manager.getBookmarks()) {
            if (!(bookmark instanceof LineBookmarkImpl) || !Intrinsics.areEqual((Object)((LineBookmarkImpl)bookmark).getFile(), (Object)file)) continue;
            v2 /* !! */  = ((LineBookmarkImpl)bookmark).getDescriptor().getRangeMarker();
            if (v2 /* !! */  == null) ** GOTO lbl-1000
            var9_15 = v2 /* !! */ ;
            var10_17 = false;
            var11_18 = false;
            it = var9_15;
            $i$a$-let-LineBookmarkProvider$afterDocumentChange$line$1 = false;
            v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            v2 /* !! */  = v3.isValid() != false ? Integer.valueOf(it.getDocument().getLineNumber(it.getStartOffset())) : null;
            if (v2 /* !! */  != null) {
                v4 = v2 /* !! */ .intValue();
            } else lbl-1000:
            // 2 sources

            {
                v4 = -1;
            }
            line = v4;
            var9_14 = ((LineBookmarkImpl)bookmark).getLine();
            if (var9_14 == line) {
                set.add(line);
                continue;
            }
            ((Map)map).put(bookmark, line);
        }
        if (map.isEmpty()) {
            return;
        }
        var7_11 = false;
        bookmarks = new LinkedHashMap<K, V>();
        $this$forEach$iv = map;
        $i$f$forEach = false;
        var9_16 = $this$forEach$iv;
        var10_17 = false;
        var11_19 = var9_16.entrySet().iterator();
        while (var11_19.hasNext()) {
            $dstr$bookmark$line = element$iv = var11_19.next();
            $i$a$-forEach-LineBookmarkProvider$afterDocumentChange$1 = false;
            var15_24 = $dstr$bookmark$line;
            var16_25 = false;
            var17_26 = (LineBookmarkImpl)var15_24.getKey();
            var15_24 = $dstr$bookmark$line;
            var16_25 = false;
            line = (Integer)var15_24.getValue();
            v5 = bookmark;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"bookmark");
            if (line < 0 || set.contains(line)) {
                v6 = null;
            } else {
                v7 = line;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"line");
                set.add(v7);
                v6 = this.createBookmark(file, (int)line);
            }
            bookmarks.put(v5, v6);
        }
        manager.update(bookmarks);
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        boolean update2;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$any$iv = events;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VFileEvent it = (VFileEvent)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof VFileCreateEvent || it instanceof VFileDeleteEvent)) continue;
                    bl = true;
                    break block4;
                }
                bl = update2 = false;
            }
        }
        if (update2) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.validateAlarm, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final void validateAndUpdate() {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
        if (bookmarksManager == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInstance(project) ?: return");
        BookmarksManager manager2 = bookmarksManager;
        boolean bl = false;
        Map bookmarks = new LinkedHashMap();
        List list2 = manager2.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"manager.bookmarks");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark bookmark;
            Bookmark it = (Bookmark)element$iv;
            boolean bl2 = false;
            Bookmark bookmark2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)bookmark2, (String)"it");
            if (this.validate(bookmark2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Bookmark $this$run = bookmark;
            boolean bl5 = false;
            bookmarks.put(it, $this$run);
        }
        manager2.update(bookmarks);
    }

    private final Bookmark validate(Bookmark bookmark) {
        Bookmark bookmark2;
        Bookmark bookmark3 = bookmark;
        if (bookmark3 instanceof InvalidBookmark) {
            bookmark2 = (Bookmark)this.createValidBookmark(((InvalidBookmark)bookmark).getUrl(), ((InvalidBookmark)bookmark).getLine());
        } else if (bookmark3 instanceof FileBookmarkImpl) {
            VirtualFile virtualFile2 = ((FileBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile $this$run = virtualFile2;
            boolean bl3 = false;
            if ($this$run.isValid()) {
                bookmark2 = null;
            } else {
                String string = $this$run.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                bookmark2 = LineBookmarkProvider.createBookmark$default(this, string, 0, 2, null);
            }
        } else if (bookmark3 instanceof LineBookmarkImpl) {
            VirtualFile virtualFile3 = ((LineBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            boolean bl4 = false;
            VirtualFile $this$run = virtualFile3;
            boolean bl5 = false;
            if ($this$run.isValid()) {
                bookmark2 = null;
            } else {
                String string = $this$run.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                bookmark2 = this.createBookmark(string, ((LineBookmarkImpl)bookmark).getLine());
            }
        } else {
            bookmark2 = null;
        }
        return bookmark2;
    }

    private final boolean isNodeVisible(AbstractTreeNode<?> node2) {
        boolean bl;
        Object object = node2.getValue();
        if (!(object instanceof InvalidBookmark)) {
            object = null;
        }
        InvalidBookmark invalidBookmark = (InvalidBookmark)object;
        if (invalidBookmark != null) {
            InvalidBookmark invalidBookmark2 = invalidBookmark;
            boolean bl2 = false;
            boolean bl3 = false;
            InvalidBookmark $this$run = invalidBookmark2;
            boolean bl4 = false;
            bl = $this$run.getLine() < 0;
        } else {
            bl = true;
        }
        return bl;
    }

    private final VirtualFileManager getVFM() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        return virtualFileManager;
    }

    public LineBookmarkProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                LineBookmarkProvider.access$validateAndUpdate((LineBookmarkProvider)this.receiver);
            }
        };
        this.validateAlarm = new SingleAlarm(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, 100, (Disposable)this.project, Alarm.ThreadToUse.POOLED_THREAD, null, 16, null);
        if (!this.project.isDefault()) {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
            EditorEventMulticaster editorEventMulticaster = editorFactory.getEventMulticaster();
            Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"EditorFactory.getInstance().eventMulticaster");
            EditorEventMulticaster multicaster = editorEventMulticaster;
            multicaster.addDocumentListener((DocumentListener)this, (Disposable)this.project);
            multicaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this.project);
            this.getVFM().addAsyncFileListener((AsyncFileListener)this, (Disposable)this.project);
        }
    }

    public static final /* synthetic */ void access$validateAndUpdate(LineBookmarkProvider $this) {
        $this.validateAndUpdate();
    }

    @JvmStatic
    @Nullable
    public static final LineBookmarkProvider find(@NotNull Project project) {
        return Companion.find(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider$Companion;", "", "()V", "find", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "readLineText", "", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final LineBookmarkProvider find(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return project.isDisposed() ? null : (LineBookmarkProvider)BookmarkProvider.EP.findExtension(LineBookmarkProvider.class, (AreaInstance)project);
        }

        @Nullable
        public final String readLineText(@Nullable LineBookmark bookmark) {
            String string;
            LineBookmark lineBookmark = bookmark;
            if (lineBookmark != null) {
                LineBookmark lineBookmark2 = lineBookmark;
                boolean bl = false;
                boolean bl2 = false;
                LineBookmark it = lineBookmark2;
                boolean bl3 = false;
                string = Companion.readLineText(it.getFile(), it.getLine());
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String readLineText(@NotNull VirtualFile file2, int line) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
            Document document2 = document;
            if (line < 0 || document2.getLineCount() <= line) {
                return null;
            }
            int start2 = document2.getLineStartOffset(line);
            if (start2 < 0) {
                return null;
            }
            int end = document2.getLineEndOffset(line);
            if (end < start2) {
                return null;
            }
            return document2.getText(TextRange.create((int)start2, (int)end));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

