/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebBrowsersConfiguration", storages={@Storage(value="web-browsers.xml", roamingType=RoamingType.DISABLED)})
public final class WebBrowserManager
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WebBrowserManager.class);
    private static final UUID PREDEFINED_CHROME_ID = UUID.fromString("98CA6316-2F89-46D9-A9E5-FA9E2B0625B3");
    @ApiStatus.Internal
    public static final UUID PREDEFINED_FIREFOX_ID = UUID.fromString("A7BB68E0-33C0-4D6F-A81A-AAC1FDB870C8");
    private static final UUID PREDEFINED_SAFARI_ID = UUID.fromString("E5120D43-2C3F-47EF-9F26-65E539E05186");
    private static final UUID PREDEFINED_OPERA_ID = UUID.fromString("53E2F627-B1A7-4DFA-BFA7-5B83CC034776");
    private static final UUID PREDEFINED_YANDEX_ID = UUID.fromString("B1B2EC2C-20BD-4EE2-89C4-616DB004BCD4");
    private static final UUID PREDEFINED_EXPLORER_ID = UUID.fromString("16BF23D4-93E0-4FFC-BFD6-CB13575177B0");
    private static final UUID PREDEFINED_OLD_EDGE_ID = UUID.fromString("B2A9DCA7-9D0B-4E1E-98A8-AFB19C1328D2");
    private static final UUID PREDEFINED_EDGE_ID = UUID.fromString("37cae5b9-e8b2-4949-9172-aafa37fbc09c");
    private static final UUID[] PREDEFINED_BROWSER_IDS = new UUID[]{PREDEFINED_CHROME_ID, PREDEFINED_FIREFOX_ID, PREDEFINED_SAFARI_ID, PREDEFINED_OPERA_ID, PREDEFINED_YANDEX_ID, PREDEFINED_EXPLORER_ID, PREDEFINED_EDGE_ID};
    public static final ReloadMode BROWSER_RELOAD_MODE_DEFAULT = ReloadMode.RELOAD_ON_SAVE;
    public static final ReloadMode PREVIEW_RELOAD_MODE_DEFAULT = ReloadMode.RELOAD_ON_SAVE;
    private List<ConfigurableWebBrowser> browsers;
    private boolean showBrowserHover = true;
    private boolean showBrowserHoverXml = false;
    DefaultBrowserPolicy defaultBrowserPolicy = DefaultBrowserPolicy.SYSTEM;
    ReloadMode webServerReloadMode = BROWSER_RELOAD_MODE_DEFAULT;
    ReloadMode webPreviewReloadMode = PREVIEW_RELOAD_MODE_DEFAULT;

    @NotNull
    private static String getEdgeExecutionPath() {
        if (SystemInfo.isWindows) {
            return "msedge";
        }
        if (SystemInfo.isMac) {
            return "Microsoft Edge";
        }
        return "microsoft-edge";
    }

    private static List<ConfigurableWebBrowser> getPredefinedBrowsers() {
        return Arrays.asList(new ConfigurableWebBrowser(PREDEFINED_CHROME_ID, BrowserFamily.CHROME), new ConfigurableWebBrowser(PREDEFINED_FIREFOX_ID, BrowserFamily.FIREFOX), new ConfigurableWebBrowser(PREDEFINED_SAFARI_ID, BrowserFamily.SAFARI, BrowserFamily.SAFARI.getName(), BrowserFamily.SAFARI.getExecutionPath(), SystemInfo.isMac, BrowserFamily.SAFARI.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_OPERA_ID, BrowserFamily.CHROME, "Opera", SystemInfo.isMac ? "Opera" : "opera", false, null), new ConfigurableWebBrowser(PREDEFINED_YANDEX_ID, BrowserFamily.CHROME, "Yandex", SystemInfo.isWindows ? "browser" : (SystemInfo.isMac ? "Yandex" : "yandex"), false, BrowserFamily.CHROME.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_EXPLORER_ID, BrowserFamily.EXPLORER, BrowserFamily.EXPLORER.getName(), BrowserFamily.EXPLORER.getExecutionPath(), false, BrowserFamily.EXPLORER.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_EDGE_ID, BrowserFamily.CHROME, "Edge", WebBrowserManager.getEdgeExecutionPath(), SystemInfo.isWindows, BrowserFamily.CHROME.createBrowserSpecificSettings()));
    }

    public WebBrowserManager() {
        this.browsers = new ArrayList<ConfigurableWebBrowser>(WebBrowserManager.getPredefinedBrowsers());
    }

    public static WebBrowserManager getInstance() {
        return (WebBrowserManager)((Object)ApplicationManager.getApplication().getService(WebBrowserManager.class));
    }

    public static boolean isYandexBrowser(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(0);
        }
        return browser2.getFamily().equals((Object)BrowserFamily.CHROME) && (browser2.getId().equals(PREDEFINED_YANDEX_ID) || WebBrowserManager.checkNameAndPath("Yandex", browser2));
    }

    public static boolean isDartium(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(1);
        }
        return browser2.getFamily().equals((Object)BrowserFamily.CHROME) && WebBrowserManager.checkNameAndPath("Dartium", browser2);
    }

    public static boolean isEdge(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(2);
        }
        return browser2.getFamily() == BrowserFamily.CHROME && (browser2.getId().equals(PREDEFINED_EDGE_ID) || WebBrowserManager.checkNameAndPath(WebBrowserManager.getEdgeExecutionPath(), browser2) || WebBrowserManager.checkNameAndPath("MicrosoftEdge", browser2));
    }

    public static boolean isOpera(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(3);
        }
        return WebBrowserManager.checkNameAndPath("Opera", browser2);
    }

    static boolean checkNameAndPath(@NotNull String what, @NotNull WebBrowser browser2) {
        if (what == null) {
            WebBrowserManager.$$$reportNull$$$0(4);
        }
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(5);
        }
        if (StringUtil.containsIgnoreCase((String)browser2.getName(), (String)what)) {
            return true;
        }
        String path2 = browser2.getPath();
        if (path2 != null) {
            String fileName = PathUtil.getFileName((String)path2);
            if (StringUtil.containsIgnoreCase((String)fileName, (String)what)) {
                return true;
            }
            String parentPath = PathUtil.getParentPath((String)path2);
            String parentPathName = PathUtil.getFileName((String)parentPath);
            if ("bin".equals(parentPathName)) {
                parentPath = PathUtil.getParentPath((String)parentPath);
                parentPathName = PathUtil.getFileName((String)parentPath);
            }
            return StringUtil.containsIgnoreCase((String)parentPathName, (String)what);
        }
        return false;
    }

    boolean isPredefinedBrowser(@NotNull ConfigurableWebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(6);
        }
        UUID id2 = browser2.getId();
        for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            if (!id2.equals(predefinedBrowserId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DefaultBrowserPolicy getDefaultBrowserPolicy() {
        DefaultBrowserPolicy defaultBrowserPolicy = this.defaultBrowserPolicy;
        if (defaultBrowserPolicy == null) {
            WebBrowserManager.$$$reportNull$$$0(7);
        }
        return defaultBrowserPolicy;
    }

    @NotNull
    public ReloadMode getWebServerReloadMode() {
        ReloadMode reloadMode = this.webServerReloadMode;
        if (reloadMode == null) {
            WebBrowserManager.$$$reportNull$$$0(8);
        }
        return reloadMode;
    }

    @NotNull
    public ReloadMode getWebPreviewReloadMode() {
        ReloadMode reloadMode = this.webPreviewReloadMode;
        if (reloadMode == null) {
            WebBrowserManager.$$$reportNull$$$0(9);
        }
        return reloadMode;
    }

    public Element getState() {
        Element state = new Element("state");
        if (this.defaultBrowserPolicy != DefaultBrowserPolicy.SYSTEM) {
            state.setAttribute("default", StringUtil.toLowerCase((String)this.defaultBrowserPolicy.name()));
        }
        if (this.webServerReloadMode != BROWSER_RELOAD_MODE_DEFAULT) {
            state.setAttribute("serverReloadMode", StringUtil.toLowerCase((String)this.webServerReloadMode.name()));
        }
        if (this.webPreviewReloadMode != PREVIEW_RELOAD_MODE_DEFAULT) {
            state.setAttribute("previewReloadMode", StringUtil.toLowerCase((String)this.webPreviewReloadMode.name()));
        }
        if (!this.showBrowserHover) {
            state.setAttribute("showHover", "false");
        }
        if (this.showBrowserHoverXml) {
            state.setAttribute("showHoverXml", "true");
        }
        if (!this.browsers.equals(WebBrowserManager.getPredefinedBrowsers())) {
            for (ConfigurableWebBrowser browser2 : this.browsers) {
                BrowserSpecificSettings specificSettings;
                Element entry2 = new Element("browser");
                entry2.setAttribute("id", browser2.getId().toString());
                entry2.setAttribute("name", browser2.getName());
                entry2.setAttribute("family", browser2.getFamily().name());
                String path2 = browser2.getPath();
                if (path2 != null && !path2.equals(browser2.getFamily().getExecutionPath())) {
                    entry2.setAttribute("path", path2);
                }
                if (!browser2.isActive()) {
                    entry2.setAttribute("active", "false");
                }
                if ((specificSettings = browser2.getSpecificSettings()) != null) {
                    Element settingsElement = new Element("settings");
                    XmlSerializer.serializeInto((Object)specificSettings, (Element)settingsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                    if (!JDOMUtil.isEmpty((Element)settingsElement)) {
                        entry2.addContent(settingsElement);
                    }
                }
                state.addContent(entry2);
            }
        }
        return state;
    }

    @Nullable
    private static BrowserFamily readFamily(String value2) {
        try {
            return "OPERA".equals(value2) ? BrowserFamily.CHROME : BrowserFamily.valueOf((String)value2);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            for (BrowserFamily family : BrowserFamily.values()) {
                if (!family.getName().equalsIgnoreCase(value2)) continue;
                return family;
            }
            return null;
        }
    }

    @Nullable
    private static UUID readId(String value2, @NotNull BrowserFamily family, @NotNull List<ConfigurableWebBrowser> existingBrowsers) {
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(10);
        }
        if (existingBrowsers == null) {
            WebBrowserManager.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((String)value2)) {
            UUID id2;
            switch (family) {
                case CHROME: {
                    id2 = PREDEFINED_CHROME_ID;
                    break;
                }
                case EXPLORER: {
                    id2 = PREDEFINED_EXPLORER_ID;
                    break;
                }
                case FIREFOX: {
                    id2 = PREDEFINED_FIREFOX_ID;
                    break;
                }
                case SAFARI: {
                    id2 = PREDEFINED_SAFARI_ID;
                    break;
                }
                default: {
                    return null;
                }
            }
            for (ConfigurableWebBrowser browser2 : existingBrowsers) {
                if (browser2.getId() != id2) continue;
                return null;
            }
            return id2;
        }
        try {
            return UUID.fromString(value2);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            WebBrowserManager.$$$reportNull$$$0(12);
        }
        try {
            String previewReload;
            Object serverReload;
            String defaultValue = element2.getAttributeValue("default");
            if (!StringUtil.isEmpty((String)defaultValue)) {
                this.defaultBrowserPolicy = DefaultBrowserPolicy.valueOf(StringUtil.toUpperCase((String)defaultValue));
            }
            if (!StringUtil.isEmpty((String)(serverReload = element2.getAttributeValue("serverReloadMode")))) {
                this.webServerReloadMode = ReloadMode.valueOf((String)StringUtil.toUpperCase((String)serverReload));
            }
            if (!StringUtil.isEmpty((String)(previewReload = element2.getAttributeValue("previewReloadMode")))) {
                this.webPreviewReloadMode = ReloadMode.valueOf((String)StringUtil.toUpperCase((String)previewReload));
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Throwable)e);
        }
        this.showBrowserHover = !"false".equals(element2.getAttributeValue("showHover"));
        ArrayList<ConfigurableWebBrowser> list2 = new ArrayList<ConfigurableWebBrowser>();
        for (Element child2 : element2.getChildren("browser")) {
            UUID id2;
            BrowserFamily family = WebBrowserManager.readFamily(child2.getAttributeValue("family"));
            if (family == null || (id2 = WebBrowserManager.readId(child2.getAttributeValue("id"), family, list2)) == null || PREDEFINED_OLD_EDGE_ID.equals(id2)) continue;
            Element settingsElement = child2.getChild("settings");
            BrowserSpecificSettings specificSettings = family.createBrowserSpecificSettings();
            if (specificSettings != null && settingsElement != null) {
                try {
                    XmlSerializer.deserializeInto((Object)specificSettings, (Element)settingsElement);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            String activeValue = child2.getAttributeValue("active");
            String path2 = StringUtil.nullize((String)child2.getAttributeValue("path"), (boolean)true);
            if (path2 == null) {
                path2 = family.getExecutionPath();
            }
            list2.add(new ConfigurableWebBrowser(id2, family, StringUtil.notNullize((String)child2.getAttributeValue("name"), (String)family.getName()), path2, activeValue == null || Boolean.parseBoolean(activeValue), specificSettings));
        }
        Map idToBrowser = null;
        int n = list2.size();
        block5: for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            for (int i2 = 0; i2 < n; ++i2) {
                if (((ConfigurableWebBrowser)((Object)list2.get(i2))).getId().equals(predefinedBrowserId)) continue block5;
            }
            if (idToBrowser == null) {
                idToBrowser = ContainerUtil.newMapFromValues(WebBrowserManager.getPredefinedBrowsers().iterator(), it -> it.getId());
            }
            list2.add((ConfigurableWebBrowser)((Object)idToBrowser.get(predefinedBrowserId)));
        }
        this.setList(list2);
    }

    @NotNull
    public List<WebBrowser> getBrowsers() {
        List<WebBrowser> list2 = Collections.unmodifiableList(this.browsers);
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    List<ConfigurableWebBrowser> getList() {
        List<ConfigurableWebBrowser> list2 = this.browsers;
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(14);
        }
        return list2;
    }

    void setList(@NotNull List<ConfigurableWebBrowser> value2) {
        if (value2 == null) {
            WebBrowserManager.$$$reportNull$$$0(15);
        }
        this.browsers = value2;
        this.incModificationCount();
    }

    @NotNull
    public List<WebBrowser> getActiveBrowsers() {
        List<WebBrowser> list2 = this.getBrowsers((Condition<? super WebBrowser>)Conditions.alwaysTrue(), true);
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<? super WebBrowser> condition) {
        if (condition == null) {
            WebBrowserManager.$$$reportNull$$$0(17);
        }
        List<WebBrowser> list2 = this.getBrowsers(condition, true);
        if (list2 == null) {
            WebBrowserManager.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<? super WebBrowser> condition, boolean onlyActive) {
        if (condition == null) {
            WebBrowserManager.$$$reportNull$$$0(19);
        }
        SmartList result2 = new SmartList();
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (onlyActive && !browser2.isActive() || !condition.value((Object)browser2)) continue;
            result2.add(browser2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            WebBrowserManager.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    public void setBrowserSpecificSettings(@NotNull WebBrowser browser2, @NotNull BrowserSpecificSettings specificSettings) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(21);
        }
        if (specificSettings == null) {
            WebBrowserManager.$$$reportNull$$$0(22);
        }
        ((ConfigurableWebBrowser)browser2).setSpecificSettings(specificSettings);
    }

    public void setBrowserPath(@NotNull WebBrowser browser2, @Nullable String path2, boolean isActive) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(23);
        }
        ((ConfigurableWebBrowser)browser2).setPath(path2);
        ((ConfigurableWebBrowser)browser2).setActive(isActive);
        this.incModificationCount();
    }

    public WebBrowser addBrowser(@NotNull UUID id2, @NotNull BrowserFamily family, @NotNull String name2, @Nullable String path2, boolean active2, BrowserSpecificSettings specificSettings) {
        if (id2 == null) {
            WebBrowserManager.$$$reportNull$$$0(24);
        }
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(25);
        }
        if (name2 == null) {
            WebBrowserManager.$$$reportNull$$$0(26);
        }
        ConfigurableWebBrowser browser2 = new ConfigurableWebBrowser(id2, family, name2, path2, active2, specificSettings);
        this.browsers.add(browser2);
        this.incModificationCount();
        return browser2;
    }

    @Nullable
    private static UUID parseUuid(@NotNull String id2) {
        if (id2 == null) {
            WebBrowserManager.$$$reportNull$$$0(27);
        }
        if (id2.indexOf(45) == -1) {
            return null;
        }
        try {
            return UUID.fromString(id2);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public WebBrowser findBrowserById(@Nullable String idOrFamilyName) {
        if (Strings.isEmpty((String)idOrFamilyName)) {
            return null;
        }
        UUID id2 = WebBrowserManager.parseUuid(idOrFamilyName);
        if (id2 == null) {
            for (ConfigurableWebBrowser browser2 : this.browsers) {
                if (!browser2.getFamily().name().equalsIgnoreCase(idOrFamilyName) && !browser2.getFamily().getName().equalsIgnoreCase(idOrFamilyName)) continue;
                return browser2;
            }
            return null;
        }
        for (ConfigurableWebBrowser browser3 : this.browsers) {
            if (!browser3.getId().equals(id2)) continue;
            return browser3;
        }
        return null;
    }

    @Nullable
    public WebBrowser getFirstBrowserOrNull(@NotNull BrowserFamily family) {
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(28);
        }
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!browser2.isActive() || !family.equals((Object)browser2.getFamily())) continue;
            return browser2;
        }
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!family.equals((Object)browser2.getFamily())) continue;
            return browser2;
        }
        return null;
    }

    @NotNull
    public WebBrowser getFirstBrowser(@NotNull BrowserFamily family) {
        WebBrowser result2;
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(29);
        }
        if ((result2 = this.getFirstBrowserOrNull(family)) == null) {
            throw new IllegalStateException("Must be at least one browser per family");
        }
        WebBrowser webBrowser = result2;
        if (webBrowser == null) {
            WebBrowserManager.$$$reportNull$$$0(30);
        }
        return webBrowser;
    }

    public boolean isActive(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(31);
        }
        return !(browser2 instanceof ConfigurableWebBrowser) || ((ConfigurableWebBrowser)browser2).isActive();
    }

    @Nullable
    public WebBrowser getFirstActiveBrowser() {
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!browser2.isActive() || browser2.getPath() == null) continue;
            return browser2;
        }
        return null;
    }

    public void setShowBrowserHover(boolean showBrowserHover) {
        this.showBrowserHover = showBrowserHover;
    }

    public void setShowBrowserHoverXml(boolean showBrowserHover) {
        this.showBrowserHoverXml = showBrowserHover;
    }

    public boolean isShowBrowserHover() {
        return this.showBrowserHover;
    }

    public boolean isShowBrowserHoverXml() {
        return this.showBrowserHoverXml;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/WebBrowserManager";
                break;
            }
            case 10: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingBrowsers";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificSettings";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/WebBrowserManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBrowserPolicy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerReloadMode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebPreviewReloadMode";
                break;
            }
            case 13: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveBrowsers";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isYandexBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDartium";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEdge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOpera";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkNameAndPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedBrowser";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setList";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBrowsers";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserSpecificSettings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserPath";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addBrowser";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseUuid";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBrowserOrNull";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBrowser";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

