/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"chooseUrl", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/util/Url;", "urls", "", "createRequest", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "isForceFileUrlIfNoUrlProvider", "", "intellij.platform.ide.impl"})
public final class BaseOpenInBrowserActionKt {
    private static final OpenInBrowserRequest createRequest(DataContext context2, boolean isForceFileUrlIfNoUrlProvider) {
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context2);
        if (editor2 == null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context2);
            VirtualFile virtualFile2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context2);
            Project project = (Project)CommonDataKeys.PROJECT.getData(context2);
            if (virtualFile2 != null && !virtualFile2.isDirectory() && virtualFile2.isValid() && project != null && project.isInitialized()) {
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            }
            if (psiFile != null) {
                return OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)((PsiElement)psiFile), (boolean)isForceFileUrlIfNoUrlProvider);
            }
        } else {
            Project project = editor2.getProject();
            if (project != null && project.isInitialized()) {
                PsiFile psiFile;
                PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context2);
                if (psiFile2 == null) {
                    psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
                }
                if (psiFile != null) {
                    return new OpenInBrowserRequest(editor2, psiFile, isForceFileUrlIfNoUrlProvider, psiFile, isForceFileUrlIfNoUrlProvider){
                        private final Lazy lazyElement$delegate;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ PsiFile $psiFile;
                        final /* synthetic */ boolean $isForceFileUrlIfNoUrlProvider;

                        private final PsiElement getLazyElement() {
                            Lazy lazy = this.lazyElement$delegate;
                            createRequest.1 var2_2 = this;
                            Object var3_3 = null;
                            boolean bl = false;
                            return (PsiElement)lazy.getValue();
                        }

                        @NotNull
                        public PsiElement getElement() {
                            PsiElement psiElement = this.getLazyElement();
                            if (psiElement == null) {
                                psiElement = (PsiElement)this.getFile();
                            }
                            return psiElement;
                        }
                        {
                            this.$editor = $captured_local_variable$0;
                            this.$psiFile = $captured_local_variable$1;
                            this.$isForceFileUrlIfNoUrlProvider = $captured_local_variable$2;
                            super($super_call_param$3, $super_call_param$4);
                            this.lazyElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiElement>(this){
                                final /* synthetic */ createRequest.1 this$0;

                                @Nullable
                                public final PsiElement invoke() {
                                    PsiFile psiFile = this.this$0.getFile();
                                    CaretModel caretModel = this.this$0.$editor.getCaretModel();
                                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                                    return psiFile.findElementAt(caretModel.getOffset());
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                    };
                }
            }
        }
        return null;
    }

    @NotNull
    public static final Promise<Url> chooseUrl(@NotNull Collection<? extends Url> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        if (urls.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)urls));
        }
        AsyncPromise result2 = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.toMutableList(urls)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((SimpleListCellRenderer.Customizer)chooseUrl.1.INSTANCE)).setTitle(IdeBundle.message((String)"browser.url.popup", (Object[])new Object[0])).setItemChosenCallback(new Consumer(result2){
            final /* synthetic */ AsyncPromise $result;

            public final void consume(Url value2) {
                this.$result.setResult((Object)value2);
            }
            {
                this.$result = asyncPromise;
            }
        }).createPopup().showInFocusCenter();
        return (Promise)result2;
    }

    public static final /* synthetic */ OpenInBrowserRequest access$createRequest(DataContext context2, boolean isForceFileUrlIfNoUrlProvider) {
        return BaseOpenInBrowserActionKt.createRequest(context2, isForceFileUrlIfNoUrlProvider);
    }
}

