/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.ide.browsers.actions.WebPreviewVirtualFile;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.BitUtil;
import com.intellij.util.Url;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class OpenHtmlInEmbeddedBrowserAction
extends DumbAwareAction {
    OpenHtmlInEmbeddedBrowserAction() {
        super(IdeBundle.message((String)"action.open.web.preview.text", (Object[])new Object[0]), null, AppUIUtil.loadSmallApplicationIconForRelease(ScaleContext.create(), 16));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenHtmlInEmbeddedBrowserAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        PsiFile psiFile = (PsiFile)event.getRequiredData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        boolean preferLocalFileUrl = BitUtil.isSet((int)event.getModifiers(), (int)1);
        try {
            OpenInBrowserRequest browserRequest = OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)psiFile, (boolean)false);
            if (browserRequest == null) {
                return;
            }
            browserRequest.setReloadMode(WebBrowserManager.getInstance().getWebPreviewReloadMode());
            Collection urls = WebBrowserService.getInstance().getUrlsToOpen(browserRequest, preferLocalFileUrl);
            if (!urls.isEmpty()) {
                BaseOpenInBrowserActionKt.chooseUrl(urls).onSuccess(url -> {
                    WebPreviewVirtualFile file2 = new WebPreviewVirtualFile(virtualFile2, (Url)url);
                    if (!FileEditorManager.getInstance((Project)project).isFileOpen((VirtualFile)file2)) {
                        OpenInRightSplitAction.Companion.openInRightSplit(project, (VirtualFile)file2, null, false);
                    } else {
                        FileEditorManagerEx.getInstanceEx(project).openFileWithProviders((VirtualFile)file2, false, true);
                    }
                });
            }
        }
        catch (WebBrowserUrlProvider.BrowserException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenHtmlInEmbeddedBrowserAction.$$$reportNull$$$0(1);
        }
        OpenInBrowserRequest request2 = BaseOpenInBrowserAction.doUpdate(e);
        Project project = e.getProject();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        boolean enabled = project != null && psiFile != null && request2 != null && psiFile.getVirtualFile() != null;
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled) {
            return;
        }
        if (WebBrowserXmlService.getInstance().isHtmlFile((PsiElement)request2.getFile()) && "ContextToolbar" == e.getPlace()) {
            Object text2 = this.getTemplateText();
            text2 = (String)text2 + " (" + IdeBundle.message((String)"browser.shortcut", (Object[])new Object[0]) + ")";
            e.getPresentation().setText((String)text2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/browsers/actions/OpenHtmlInEmbeddedBrowserAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

