/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.openapi.extensions.PluginId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IdSet {
    private static final List<@NonNls String> STOP_LIST = List.of("Support", "support", "Integration", "integration");
    @NotNull
    private final Set<PluginId> myPluginIds;
    @Nls
    @NotNull
    private final String myTitle;

    IdSet(@NotNull Set<PluginId> pluginIds2, @Nls @NotNull String title2) {
        if (pluginIds2 == null) {
            IdSet.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            IdSet.$$$reportNull$$$0(1);
        }
        assert (!pluginIds2.isEmpty());
        this.myPluginIds = pluginIds2;
        this.myTitle = IdSet.cleanTitle(title2);
    }

    public String toString() {
        return this.myTitle + ": " + this.myPluginIds.size();
    }

    @NotNull
    public Set<PluginId> getPluginIds() {
        Set<PluginId> set2 = Collections.unmodifiableSet(this.myPluginIds);
        if (set2 == null) {
            IdSet.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @Nls
    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            IdSet.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public List<PluginId> getIds() {
        return new ArrayList<PluginId>(this.myPluginIds);
    }

    @Nls
    @NotNull
    private static String cleanTitle(@Nls @NotNull String title2) {
        if (title2 == null) {
            IdSet.$$$reportNull$$$0(4);
        }
        for (String skipWord : STOP_LIST) {
            title2 = title2.replaceAll(skipWord, "");
        }
        String string = title2.replaceAll(" {2}", " ").trim();
        if (string == null) {
            IdSet.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/customize/IdSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/customize/IdSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginIds";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

