/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCopyPasteUtil {
    private static final Logger LOG = Logger.getInstance(FileCopyPasteUtil.class);

    private FileCopyPasteUtil() {
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType) {
        if (mimeType == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(0);
        }
        return FileCopyPasteUtil.createDataFlavor(mimeType, null, false);
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType, @Nullable Class<?> klass) {
        if (mimeType == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(1);
        }
        return FileCopyPasteUtil.createDataFlavor(mimeType, klass, false);
    }

    public static DataFlavor createDataFlavor(@NotNull String mimeType, @Nullable Class<?> klass, boolean register2) {
        if (mimeType == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(2);
        }
        try {
            FlavorMap map2;
            DataFlavor flavor;
            DataFlavor dataFlavor = flavor = klass != null ? new DataFlavor(mimeType + ";class=" + klass.getName(), null, klass.getClassLoader()) : new DataFlavor(mimeType);
            if (register2 && (map2 = SystemFlavorMap.getDefaultFlavorMap()) instanceof SystemFlavorMap) {
                ((SystemFlavorMap)map2).addUnencodedNativeForFlavor(flavor, mimeType);
            }
            return flavor;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static DataFlavor createJvmDataFlavor(@NotNull Class<?> klass) {
        if (klass == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(3);
        }
        return FileCopyPasteUtil.createDataFlavor("application/x-java-jvm-local-objectref", klass, false);
    }

    public static boolean isFileListFlavorAvailable() {
        return CopyPasteManager.getInstance().areDataFlavorsAvailable(new DataFlavor[]{DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor});
    }

    public static boolean isFileListFlavorAvailable(@NotNull DnDEvent event) {
        if (event == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(4);
        }
        return event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || event.isDataFlavorSupported(LinuxDragAndDropSupport.uriListFlavor) || event.isDataFlavorSupported(LinuxDragAndDropSupport.gnomeFileListFlavor);
    }

    public static boolean isFileListFlavorAvailable(DataFlavor @NotNull [] transferFlavors) {
        if (transferFlavors == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(5);
        }
        for (DataFlavor flavor : transferFlavors) {
            if (flavor == null || !flavor.equals(DataFlavor.javaFileListFlavor) && !flavor.equals(LinuxDragAndDropSupport.uriListFlavor) && !flavor.equals(LinuxDragAndDropSupport.gnomeFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static List<File> getFileList(@NotNull Transferable transferable) {
        if (transferable == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(6);
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                return ContainerUtil.filter((Collection)fileList, file2 -> !Strings.isEmptyOrSpaces((CharSequence)file2.getPath()));
            }
            List<Path> files2 = LinuxDragAndDropSupport.getFiles(transferable);
            return files2 == null ? null : ContainerUtil.map(files2, it -> it.toFile());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static List<Path> getFiles(@NotNull Transferable transferable) {
        if (transferable == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(7);
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                return ContainerUtil.mapNotNull((Collection)fileList, file2 -> Strings.isEmptyOrSpaces((CharSequence)file2.getPath()) ? null : file2.toPath());
            }
            return LinuxDragAndDropSupport.getFiles(transferable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static List<File> getFileListFromAttachedObject(Object attached) {
        List<File> result2 = attached instanceof TransferableWrapper ? ((TransferableWrapper)attached).asFileList() : (attached instanceof DnDNativeTarget.EventInfo ? FileCopyPasteUtil.getFileList(((DnDNativeTarget.EventInfo)attached).getTransferable()) : null);
        List<Object> list2 = result2 == null ? Collections.emptyList() : result2;
        if (list2 == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> getVirtualFileListFromAttachedObject(Object attached) {
        List<VirtualFile> result2;
        List<File> fileList = FileCopyPasteUtil.getFileListFromAttachedObject(attached);
        if (fileList.isEmpty()) {
            result2 = Collections.emptyList();
        } else {
            result2 = new ArrayList(fileList.size());
            for (File file2 : fileList) {
                VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
                if (virtualFile2 == null) continue;
                result2.add(virtualFile2);
                virtualFile2.getFileType();
            }
        }
        List<VirtualFile> list2 = result2;
        if (list2 == null) {
            FileCopyPasteUtil.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferFlavors";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/FileCopyPasteUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/FileCopyPasteUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileListFromAttachedObject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileListFromAttachedObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJvmDataFlavor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileListFlavorAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

