/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class SendToFavoritesAction
extends AnAction
implements DumbAware {
    private final String toName;

    public SendToFavoritesAction(String name2) {
        super(name2);
        this.toName = name2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SendToFavoritesAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoriteTreeNodeDescriptor[] roots2 = FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        if (roots2 == null) {
            return;
        }
        for (FavoriteTreeNodeDescriptor root2 : roots2) {
            FavoriteTreeNodeDescriptor listNode = root2.getFavoritesRoot();
            if (listNode == null || listNode == root2 || !(listNode.getElement() instanceof FavoritesListNode)) continue;
            this.doSend(favoritesManager, new FavoriteTreeNodeDescriptor[]{root2}, listNode.getElement().getName());
        }
    }

    public void doSend(FavoritesManager favoritesManager, FavoriteTreeNodeDescriptor[] roots2, String listName) {
        for (FavoriteTreeNodeDescriptor root2 : roots2) {
            AbstractTreeNode rootElement = root2.getElement();
            String name2 = listName;
            if (name2 == null) {
                name2 = root2.getFavoritesRoot().getName();
            }
            favoritesManager.removeRoot(name2, Collections.singletonList(rootElement));
            favoritesManager.addRoots(this.toName, Collections.singletonList(rootElement));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SendToFavoritesAction.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"ide.favorites.tool.window.applicable", (boolean)false)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabled(SendToFavoritesAction.isEnabled(e));
    }

    static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SendToFavoritesAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return false;
        }
        FavoriteTreeNodeDescriptor[] roots2 = (FavoriteTreeNodeDescriptor[])e.getData(FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY);
        if (roots2 == null || roots2.length == 0) {
            return false;
        }
        for (FavoriteTreeNodeDescriptor root2 : roots2) {
            FavoriteTreeNodeDescriptor listNode = root2.getFavoritesRoot();
            if (listNode != null && listNode != root2 && listNode.getElement() instanceof FavoritesListNode) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/actions/SendToFavoritesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

