/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.feedback;

import com.intellij.icons.AllIcons;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010#\u001a\u00020\u0019*\u00020\u00042\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/intellij/ide/feedback/RatingComponent;", "Ljavax/swing/JComponent;", "()V", "myActiveIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "myFocusActiveIcon", "myFocusInactiveIcon", "myFocusRating", "", "myHoverRating", "myIconCount", "myIconGap", "myIconSize", "myInactiveIcon", "myLeftGap", "myMaxRating", "myMinRating", "myMouseInside", "", "<set-?>", "myRating", "getMyRating", "()I", "createKeyBindings", "", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "paintComponent", "g", "Ljava/awt/Graphics;", "ratingFromPoint", "e", "Ljava/awt/event/MouseEvent;", "paintRatingIcon", "position", "Companion", "intellij.platform.ide.impl"})
public final class RatingComponent
extends JComponent {
    private final int myIconSize;
    private final int myIconGap;
    private final int myLeftGap;
    private final int myIconCount;
    private final Icon myActiveIcon;
    private final Icon myInactiveIcon;
    private final Icon myFocusActiveIcon;
    private final Icon myFocusInactiveIcon;
    private int myHoverRating;
    private boolean myMouseInside;
    private final int myMaxRating;
    private final int myMinRating;
    private int myFocusRating;
    private int myRating;
    @NotNull
    public static final String RATING_PROPERTY = "rating";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getMyRating() {
        return this.myRating;
    }

    private final void createKeyBindings() {
        String leftActionMapKey = "left";
        String rightActionMapKey = "right";
        String oneStarActionMapKey = "1";
        String twoStarActionMapKey = "2";
        String threeStarActionMapKey = "3";
        String fourStarActionMapKey = "4";
        String fiveStarActionMapKey = "5";
        String tabStarActionMapKey = "tab";
        String shiftTabStarActionMapKey = "shiftTab";
        String enterStarActionMapKey = "enter";
        this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), leftActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), rightActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(49, 0), oneStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(50, 0), twoStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(51, 0), threeStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(52, 0), fourStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(53, 0), fiveStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), tabStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 64), shiftTabStarActionMapKey);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), enterStarActionMapKey);
        Action leftAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (RatingComponent.access$getMyFocusRating$p(this.this$0) != RatingComponent.access$getMyMinRating$p(this.this$0)) {
                    RatingComponent ratingComponent = this.this$0;
                    RatingComponent.access$setMyFocusRating$p(ratingComponent, RatingComponent.access$getMyFocusRating$p(ratingComponent) - 1);
                }
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(leftActionMapKey, leftAction2);
        Action rightAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (RatingComponent.access$getMyFocusRating$p(this.this$0) != RatingComponent.access$getMyMaxRating$p(this.this$0)) {
                    RatingComponent ratingComponent = this.this$0;
                    RatingComponent.access$setMyFocusRating$p(ratingComponent, RatingComponent.access$getMyFocusRating$p(ratingComponent) + 1);
                }
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(rightActionMapKey, rightAction2);
        Action oneStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                RatingComponent.access$setMyFocusRating$p(this.this$0, 1);
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(oneStarActionMapKey, oneStarAction2);
        Action twoStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                RatingComponent.access$setMyFocusRating$p(this.this$0, 2);
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(twoStarActionMapKey, twoStarAction2);
        Action threeStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                RatingComponent.access$setMyFocusRating$p(this.this$0, 3);
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(threeStarActionMapKey, threeStarAction2);
        Action fourStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                RatingComponent.access$setMyFocusRating$p(this.this$0, 4);
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(fourStarActionMapKey, fourStarAction2);
        Action fiveStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                RatingComponent.access$setMyFocusRating$p(this.this$0, 5);
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(fiveStarActionMapKey, fiveStarAction2);
        Action tabStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (RatingComponent.access$getMyFocusRating$p(this.this$0) == RatingComponent.access$getMyMaxRating$p(this.this$0)) {
                    this.this$0.transferFocus();
                } else {
                    RatingComponent ratingComponent = this.this$0;
                    RatingComponent.access$setMyFocusRating$p(ratingComponent, RatingComponent.access$getMyFocusRating$p(ratingComponent) + 1);
                }
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(tabStarActionMapKey, tabStarAction2);
        Action shiftTabStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (RatingComponent.access$getMyFocusRating$p(this.this$0) == RatingComponent.access$getMyMinRating$p(this.this$0)) {
                    this.this$0.transferFocusBackward();
                } else {
                    RatingComponent ratingComponent = this.this$0;
                    RatingComponent.access$setMyFocusRating$p(ratingComponent, RatingComponent.access$getMyFocusRating$p(ratingComponent) - 1);
                }
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(shiftTabStarActionMapKey, shiftTabStarAction2);
        Action enterTabStarAction2 = new AbstractAction(this){
            final /* synthetic */ RatingComponent this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                int oldRating = this.this$0.getMyRating();
                if (RatingComponent.access$getMyFocusRating$p(this.this$0) == this.this$0.getMyRating()) {
                    RatingComponent.access$setMyRating$p(this.this$0, 0);
                    this.firePropertyChange("rating", oldRating, this.this$0.getMyRating());
                } else {
                    RatingComponent.access$setMyRating$p(this.this$0, RatingComponent.access$getMyFocusRating$p(this.this$0));
                    this.firePropertyChange("rating", oldRating, this.this$0.getMyRating());
                }
                this.this$0.repaint();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.getActionMap().put(enterStarActionMapKey, enterTabStarAction2);
    }

    private final int ratingFromPoint(MouseEvent e) {
        return RangesKt.coerceAtMost((int)(e.getX() / (this.myIconSize + this.myIconGap) + 1), (int)this.myIconCount);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(this.myIconSize * this.myIconCount + this.myIconGap * (this.myIconCount - 2) + this.myLeftGap, this.myIconSize);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int ratingToShow = this.myMouseInside ? this.myHoverRating : this.myRating;
        boolean isFocusOwner = this.isFocusOwner();
        int n = 1;
        int n2 = this.myIconCount + 1;
        while (n < n2) {
            Icon icon2;
            void i2;
            if (isFocusOwner) {
                icon2 = i2 <= ratingToShow ? (i2 == this.myFocusRating ? this.myFocusActiveIcon : this.myActiveIcon) : (i2 == this.myFocusRating ? this.myFocusInactiveIcon : this.myInactiveIcon);
                this.paintRatingIcon(icon2, (int)i2, g);
            } else {
                icon2 = i2 <= ratingToShow ? this.myActiveIcon : this.myInactiveIcon;
                this.paintRatingIcon(icon2, (int)i2, g);
            }
            ++i2;
        }
    }

    private final void paintRatingIcon(Icon $this$paintRatingIcon, int position, Graphics g) {
        $this$paintRatingIcon.paintIcon(this, g, (position - 1) * this.myIconSize + (position - 2) * this.myIconGap + this.myLeftGap, 0);
    }

    public RatingComponent() {
        this.myIconSize = 32;
        this.myIconGap = 4;
        this.myLeftGap = 5;
        this.myIconCount = 5;
        Icon icon2 = AllIcons.Ide.FeedbackRatingOn;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Ide.FeedbackRatingOn");
        this.myActiveIcon = icon2;
        Icon icon3 = AllIcons.Ide.FeedbackRating;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Ide.FeedbackRating");
        this.myInactiveIcon = icon3;
        Icon icon4 = AllIcons.Ide.FeedbackRatingFocusedOn;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AllIcons.Ide.FeedbackRatingFocusedOn");
        this.myFocusActiveIcon = icon4;
        Icon icon5 = AllIcons.Ide.FeedbackRatingFocused;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"AllIcons.Ide.FeedbackRatingFocused");
        this.myFocusInactiveIcon = icon5;
        this.myMaxRating = 5;
        this.myMinRating = 1;
        this.myFocusRating = 1;
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.createKeyBindings();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                if (this.getMyRating() != 0) {
                    myFocusRating = this.getMyRating();
                }
                this.repaint();
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                myMouseInside = true;
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                myMouseInside = false;
                myHoverRating = 0;
                this.repaint();
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.isFocusOwner()) {
                    this.requestFocusInWindow();
                }
                int oldRating = this.getMyRating();
                myRating = this.ratingFromPoint(e);
                myFocusRating = this.getMyRating();
                if (this.getMyRating() != oldRating) {
                    this.firePropertyChange(RatingComponent.RATING_PROPERTY, oldRating, this.getMyRating());
                } else {
                    myRating = 0;
                    this.firePropertyChange(RatingComponent.RATING_PROPERTY, oldRating, 0);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int newHoverRating = this.ratingFromPoint(e);
                if (newHoverRating != myHoverRating) {
                    myHoverRating = newHoverRating;
                    this.repaint();
                }
            }
        });
    }

    public static final /* synthetic */ int access$getMyFocusRating$p(RatingComponent $this) {
        return $this.myFocusRating;
    }

    public static final /* synthetic */ int access$getMyMinRating$p(RatingComponent $this) {
        return $this.myMinRating;
    }

    public static final /* synthetic */ int access$getMyMaxRating$p(RatingComponent $this) {
        return $this.myMaxRating;
    }

    public static final /* synthetic */ int access$getMyRating$p(RatingComponent $this) {
        return $this.myRating;
    }

    public static final /* synthetic */ boolean access$getMyMouseInside$p(RatingComponent $this) {
        return $this.myMouseInside;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/feedback/RatingComponent$Companion;", "", "()V", "RATING_PROPERTY", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

