/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTemplateBase
implements FileTemplate {
    static final boolean DEFAULT_REFORMAT_CODE_VALUE = true;
    static final boolean DEFAULT_ENABLED_VALUE = true;
    static final String TEMPLATE_CHILDREN_SUFFIX = ".child.";
    @Nullable
    private String myText;
    private boolean myShouldReformatCode = true;
    private boolean myLiveTemplateEnabled;
    private boolean myLiveTemplateEnabledChanged;
    private String myFileName = "";
    private FileTemplate[] myChildren = EMPTY_ARRAY;

    @Override
    public final boolean isReformatCode() {
        return this.myShouldReformatCode;
    }

    @Override
    public final void setReformatCode(boolean reformat) {
        this.myShouldReformatCode = reformat;
    }

    @NotNull
    public final String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    @NotNull
    public static String getQualifiedName(@NonNls @NotNull String name2, @NonNls @NotNull String extension2) {
        if (name2 == null) {
            FileTemplateBase.$$$reportNull$$$0(0);
        }
        if (extension2 == null) {
            FileTemplateBase.$$$reportNull$$$0(1);
        }
        String string = FTManager.encodeFileName(name2, extension2);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getText() {
        String text2 = this.myText;
        String string = text2 != null ? text2 : this.getDefaultText();
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public final void setText(@Nullable String text2) {
        String converted;
        this.myText = text2 == null ? null : ((converted = StringUtil.convertLineSeparators((String)text2)).equals(this.getDefaultText()) ? null : StringUtil.internEmptyString((String)converted));
    }

    @NotNull
    protected String getDefaultText() {
        return "";
    }

    @Override
    @NotNull
    public final String getText(@NotNull Map attributes2) throws IOException {
        if (attributes2 == null) {
            FileTemplateBase.$$$reportNull$$$0(4);
        }
        String string = FileTemplateUtil.mergeTemplate(attributes2, this.getText(), false);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getText(@NotNull Properties attributes2) throws IOException {
        if (attributes2 == null) {
            FileTemplateBase.$$$reportNull$$$0(6);
        }
        String string = FileTemplateUtil.mergeTemplate(attributes2, this.getText(), false);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public final String @NotNull [] getUnsetAttributes(@NotNull Properties properties2, @NotNull Project project) throws ParseException {
        if (properties2 == null) {
            FileTemplateBase.$$$reportNull$$$0(8);
        }
        if (project == null) {
            FileTemplateBase.$$$reportNull$$$0(9);
        }
        Set attributes2 = ContainerUtil.set((Object[])FileTemplateUtil.calculateAttributes(this.getText(), properties2, false, project));
        attributes2.addAll(Arrays.asList(FileTemplateUtil.calculateAttributes(this.getFileName(), properties2, false, project)));
        String[] stringArray = ArrayUtil.toStringArray((Collection)attributes2);
        if (stringArray == null) {
            FileTemplateBase.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public FileTemplateBase clone() {
        FileTemplateBase fileTemplateBase;
        try {
            fileTemplateBase = (FileTemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (fileTemplateBase == null) {
            FileTemplateBase.$$$reportNull$$$0(11);
        }
        return fileTemplateBase;
    }

    @Override
    public boolean isTemplateOfType(@NotNull FileType fType) {
        if (fType == null) {
            FileTemplateBase.$$$reportNull$$$0(12);
        }
        return fType.equals(FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.getExtension()));
    }

    @Override
    public boolean isLiveTemplateEnabled() {
        return this.myLiveTemplateEnabled;
    }

    @Override
    public void setLiveTemplateEnabled(boolean value2) {
        this.myLiveTemplateEnabledChanged |= this.myLiveTemplateEnabled != value2;
        this.myLiveTemplateEnabled = value2;
    }

    public boolean isLiveTemplateEnabledChanged() {
        return this.myLiveTemplateEnabledChanged;
    }

    public boolean isLiveTemplateEnabledByDefault() {
        return false;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public void setFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTemplateBase.$$$reportNull$$$0(14);
        }
        this.myFileName = fileName;
    }

    @Override
    public FileTemplate @NotNull [] getChildren() {
        if (this.myChildren == null) {
            FileTemplateBase.$$$reportNull$$$0(15);
        }
        return this.myChildren;
    }

    @Override
    public void setChildren(FileTemplate @NotNull [] children2) {
        if (children2 == null) {
            FileTemplateBase.$$$reportNull$$$0(16);
        }
        this.myChildren = children2;
    }

    public void addChild(FileTemplate child2) {
        this.myChildren = (FileTemplate[])ArrayUtil.append((Object[])this.getChildren(), (Object)child2);
    }

    public String getChildName(int index2) {
        return this.getQualifiedName() + TEMPLATE_CHILDREN_SUFFIX + index2;
    }

    public void updateChildrenNames() {
        FileTemplate @NotNull [] children2 = this.getChildren();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            children2[i2].setName(this.getChildName(i2));
        }
    }

    public static boolean isChild(@NotNull FileTemplate template) {
        if (template == null) {
            FileTemplateBase.$$$reportNull$$$0(17);
        }
        return template.getName().contains(TEMPLATE_CHILDREN_SUFFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsetAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnsetAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateOfType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setFileName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

