/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NonNls;

public final class Consent
extends ConsentBase {
    @NlsSafe
    private final String myName;
    @NlsSafe
    private final String myText;
    private final boolean myAccepted;
    private final boolean myDeleted;

    public Consent(ConsentAttributes attributes2) {
        this(attributes2.consentId, Version.fromString(attributes2.version), attributes2.printableName, attributes2.text, attributes2.accepted, attributes2.deleted);
    }

    public Consent(String id2, Version version2, @NlsSafe String name2, String text2, boolean isAccepted, boolean deleted) {
        super(id2, version2);
        this.myName = name2;
        this.myText = text2;
        this.myAccepted = isAccepted;
        this.myDeleted = deleted;
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @NlsSafe
    public String getText() {
        return this.myText;
    }

    @Override
    public boolean isAccepted() {
        return this.myAccepted;
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public ConsentAttributes toConsentAttributes() {
        ConsentAttributes attributes2 = new ConsentAttributes();
        attributes2.consentId = this.getId();
        attributes2.version = this.getVersion().toString();
        attributes2.printableName = this.getName();
        attributes2.text = this.getText();
        attributes2.accepted = this.isAccepted();
        attributes2.deleted = this.isDeleted();
        return attributes2;
    }

    @Override
    @NonNls
    public String toString() {
        return "Consent{id='" + this.getId() + "', version='" + this.getVersion() + "', name='" + this.myName + "', accepted=" + this.myAccepted + ", deleted=" + this.myDeleted + "}";
    }

    public Consent derive(boolean accepted) {
        return accepted == this.isAccepted() ? this : new Consent(this.getId(), this.getVersion(), this.getName(), this.getText(), accepted, this.isDeleted());
    }
}

