/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarBorder;
import com.intellij.ide.navigationToolbar.NavBarLeftSideExtension;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class NavBarRootPaneExtension
extends IdeRootPaneNorthExtension {
    @NonNls
    public static final String NAV_BAR = "NavBar";
    private static final Logger LOG = Logger.getInstance(NavBarRootPaneExtension.class);
    private final Project myProject;
    private JComponent myWrapperPanel;
    private NavBarPanel myNavigationBar;
    private JPanel myRunPanel;
    private Boolean myNavToolbarGroupExist;
    private JScrollPane myScrollPane;

    public NavBarRootPaneExtension(@NotNull Project project) {
        if (project == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(UISettingsListener.TOPIC, uiSettings -> this.toggleRunPanel(NavBarRootPaneExtension.isShowToolPanel(uiSettings)));
    }

    public void revalidate() {
        boolean showToolPanel = NavBarRootPaneExtension.isShowToolPanel(UISettings.getInstance());
        LOG.debug("Revalidate in the navbarRootPane, toolbar visible: " + showToolPanel);
        if (showToolPanel) {
            this.toggleRunPanel(true);
        }
    }

    public IdeRootPaneNorthExtension copy() {
        return new NavBarRootPaneExtension(this.myProject);
    }

    private boolean runToolbarExists() {
        if (this.myNavToolbarGroupExist == null) {
            AnAction correctedAction = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
            this.myNavToolbarGroupExist = correctedAction instanceof DefaultActionGroup && ((DefaultActionGroup)correctedAction).getChildrenCount() > 0 || correctedAction instanceof CustomisedActionGroup && ((CustomisedActionGroup)correctedAction).getFirstAction() != null;
        }
        return this.myNavToolbarGroupExist;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new NavBarWrapperPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                }

                @Override
                public Insets getInsets() {
                    return NavBarUIManager.getUI().getWrapperPanelInsets(super.getInsets());
                }

                @Override
                public void addNotify() {
                    super.addNotify();
                }
            };
            this.myWrapperPanel.add((Component)this.buildNavBarPanel(), "Center");
            this.revalidate();
        }
        JComponent jComponent = this.myWrapperPanel;
        if (jComponent == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private void toggleRunPanel(boolean show2) {
        AsyncPromise promise = new AsyncPromise();
        promise.onSuccess(action2 -> SwingUtilities.invokeLater(() -> {
            if (show2 && this.myRunPanel == null && this.runToolbarExists()) {
                if (this.myWrapperPanel != null && this.myRunPanel != null) {
                    this.myWrapperPanel.remove(this.myRunPanel);
                    this.myRunPanel = null;
                }
                ActionManager manager2 = ActionManager.getInstance();
                if (action2 instanceof ActionGroup && this.myWrapperPanel != null) {
                    ActionToolbar actionToolbar = manager2.createActionToolbar("NavBarToolbar", (ActionGroup)action2, true);
                    actionToolbar.setTargetComponent(null);
                    this.myRunPanel = new JPanel(new BorderLayout()){

                        @Override
                        public void doLayout() {
                            NavBarRootPaneExtension.alignVertically(this);
                        }
                    };
                    this.myRunPanel.setOpaque(false);
                    this.myRunPanel.add((Component)actionToolbar.getComponent(), "Center");
                    boolean needGap = NavBarRootPaneExtension.isNeedGap(action2);
                    this.myRunPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)(needGap ? 5 : 1)));
                    NavBarLeftSideExtension.EP_NAME.forEachExtensionSafe(extension2 -> extension2.process(this.myWrapperPanel));
                    this.myWrapperPanel.add((Component)this.myRunPanel, "East");
                }
            } else if (!show2 && this.myRunPanel != null) {
                this.myWrapperPanel.remove(this.myRunPanel);
                this.myRunPanel = null;
            }
        }));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            AnAction toolbarRunGroup = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
            promise.setResult((Object)toolbarRunGroup);
        });
    }

    private JComponent buildNavBarPanel() {
        this.myNavigationBar = new NavBarPanel(this.myProject, true);
        this.myWrapperPanel.putClientProperty("NavBarPanel", this.myNavigationBar);
        this.myNavigationBar.getModel().setFixedComponent(true);
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myNavigationBar);
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Insets insets = this.getInsets();
                Rectangle r = navBar.getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(r.x, r.y);
                g2d.dispose();
            }

            @Override
            public void doLayout() {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                int x = insets.left;
                if (NavBarRootPaneExtension.this.myScrollPane == null) {
                    return;
                }
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Dimension preferredSize = ((Component)navBar).getPreferredSize();
                navBar.setBounds(x, (r.height - preferredSize.height) / 2, r.width - insets.left - insets.right, preferredSize.height);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setOpaque(true);
                if (NavBarRootPaneExtension.this.myScrollPane == null || NavBarRootPaneExtension.this.myNavigationBar == null) {
                    return;
                }
                NavBarRootPaneExtension.this.myScrollPane.setVerticalScrollBarPolicy(21);
                NavBarRootPaneExtension.this.myScrollPane.setHorizontalScrollBar(null);
                NavBarRootPaneExtension.this.myScrollPane.setBorder(new NavBarBorder());
                NavBarRootPaneExtension.this.myScrollPane.setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.getViewport().setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.setViewportBorder(null);
                NavBarRootPaneExtension.this.myNavigationBar.setBorder(null);
            }
        };
        panel2.add((Component)this.myScrollPane, "Center");
        panel2.updateUI();
        return panel2;
    }

    public void uiSettingsChanged(@NotNull UISettings settings) {
        Component c;
        if (settings == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(2);
        }
        if (this.myNavigationBar == null) {
            return;
        }
        this.myNavigationBar.updateState(settings.getShowNavigationBar());
        this.myWrapperPanel.setVisible(settings.getShowNavigationBar() && !settings.getPresentationMode());
        this.myWrapperPanel.revalidate();
        this.myNavigationBar.revalidate();
        this.myWrapperPanel.repaint();
        if (this.myWrapperPanel.getComponentCount() > 0 && (c = this.myWrapperPanel.getComponent(0)) instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
    }

    @NotNull
    public String getKey() {
        return NAV_BAR;
    }

    private static boolean isShowToolPanel(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(3);
        }
        return uiSettings.getShowNavigationBar() && !uiSettings.getShowMainToolbar() && !uiSettings.getPresentationMode() && (!ToolbarSettings.getInstance().isVisible() || !ToolbarSettings.getInstance().isEnabled());
    }

    private static void alignVertically(Container container) {
        if (container.getComponentCount() == 1) {
            Component c = container.getComponent(0);
            Insets insets = container.getInsets();
            Dimension d = c.getPreferredSize();
            Rectangle r = container.getBounds();
            c.setBounds(insets.left, (r.height - d.height - insets.top - insets.bottom) / 2 + insets.top, r.width - insets.left - insets.right, d.height);
        }
    }

    private static boolean isNeedGap(AnAction group2) {
        AnAction firstAction = NavBarRootPaneExtension.getFirstAction(group2);
        return firstAction instanceof ComboBoxAction;
    }

    @Nullable
    private static AnAction getFirstAction(AnAction group2) {
        if (group2 instanceof DefaultActionGroup) {
            AnAction firstAction = null;
            for (AnAction action2 : ((DefaultActionGroup)group2).getChildActionsOrStubs()) {
                if (!(action2 instanceof DefaultActionGroup)) {
                    if (action2 instanceof Separator || action2 instanceof ActionGroup) continue;
                    firstAction = action2;
                    break;
                }
                firstAction = NavBarRootPaneExtension.getFirstAction(action2);
                if (firstAction != null) break;
            }
            return firstAction;
        }
        if (group2 instanceof CustomisedActionGroup) {
            return ((CustomisedActionGroup)group2).getFirstAction();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarRootPaneExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarRootPaneExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShowToolPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NavBarWrapperPanel
    extends JPanel {
        public NavBarWrapperPanel(LayoutManager layout) {
            super(layout);
            this.setName("navbar");
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
        }
    }
}

