/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0004J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J!\u0010\u001f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b 2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\u001a\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0017\u0010'\u001a\u00020\u00142\r\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b(H\u0014J\b\u0010)\u001a\u00020\u0014H\u0016J(\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020,0/H\u0016J&\u00100\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020,0/H\u0002R\u001e\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lcom/intellij/ide/navigationToolbar/StructureAwareNavBarModelExtension;", "Lcom/intellij/ide/navigationToolbar/AbstractNavBarModelExtension;", "()V", "applicableNodeProviders", "", "Lcom/intellij/ide/util/treeView/smartTree/NodeProvider;", "getApplicableNodeProviders", "()Ljava/util/List;", "currentFile", "Lcom/intellij/reference/SoftReference;", "Lcom/intellij/psi/PsiFile;", "currentFileModCount", "", "currentFileStructure", "Lcom/intellij/ide/structureView/StructureViewModel;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "acceptParentFromModel", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "buildStructureViewModel", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "childrenFromNodeAndProviders", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "parent", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "createModel", "Lorg/jetbrains/annotations/NotNull;", "findParentInModel", "root", "getLeafElement", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getParent", "isAcceptableLanguage", "Lorg/jetbrains/annotations/Nullable;", "normalizeChildren", "processChildren", "object", "", "rootElement", "processor", "Lcom/intellij/util/Processor;", "processStructureViewChildren", "Companion", "intellij.platform.lang.impl"})
public abstract class StructureAwareNavBarModelExtension
extends AbstractNavBarModelExtension {
    private SoftReference<PsiFile> currentFile;
    private SoftReference<StructureViewModel> currentFileStructure;
    private long currentFileModCount = -1L;
    @NotNull
    private final List<NodeProvider<?>> applicableNodeProviders = CollectionsKt.emptyList();
    @NotNull
    private static final Key<SoftReference<StructureViewModel>> MODEL;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected abstract Language getLanguage();

    @Override
    @Nullable
    public PsiElement getLeafElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (psiFile == null || !psiFile.isValid() || editor2 == null) {
                return null;
            }
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            PsiElement psiElement = psiFile.findElementAt(caretModel.getOffset());
            if (this.isAcceptableLanguage(psiElement)) {
                try {
                    StructureViewModel structureViewModel = this.buildStructureViewModel(psiFile, editor2);
                    if (structureViewModel != null) {
                        StructureViewModel structureViewModel2 = structureViewModel;
                        boolean bl = false;
                        boolean bl2 = false;
                        StructureViewModel model2 = structureViewModel2;
                        boolean bl3 = false;
                        Object object = model2.getCurrentEditorElement();
                        if (!(object instanceof PsiElement)) {
                            object = null;
                        }
                        PsiElement psiElement2 = (PsiElement)object;
                        return psiElement2 != null ? psiElement2.getOriginalElement() : null;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected boolean isAcceptableLanguage(@Nullable PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        return Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getLanguage() : null), (Object)this.getLanguage());
    }

    @Override
    public boolean processChildren(@NotNull Object object, @Nullable Object rootElement, @NotNull Processor<Object> processor2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
            Object object2 = object;
            if (!(object2 instanceof PsiElement)) {
                object2 = null;
            }
            PsiElement psiElement = (PsiElement)object2;
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement psiElement3 = psiElement2;
                boolean bl3 = false;
                if (this.isAcceptableLanguage(psiElement3)) {
                    PsiFile psiFile = psiElement3.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiElement.containingFile");
                    StructureViewModel structureViewModel = StructureAwareNavBarModelExtension.buildStructureViewModel$default(this, psiFile, null, 2, null);
                    if (structureViewModel != null) {
                        StructureViewModel structureViewModel2 = structureViewModel;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        StructureViewModel model2 = structureViewModel2;
                        boolean bl6 = false;
                        StructureViewTreeElement structureViewTreeElement = model2.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)structureViewTreeElement, (String)"model.root");
                        return this.processStructureViewChildren(structureViewTreeElement, object, processor2);
                    }
                }
            }
        }
        return super.processChildren(object, rootElement, processor2);
    }

    @Override
    @Nullable
    public PsiElement getParent(@Nullable PsiElement psiElement) {
        if (this.isAcceptableLanguage(psiElement)) {
            PsiElement psiElement2 = psiElement;
            if (psiElement2 == null || (psiElement2 = psiElement2.getContainingFile()) == null) {
                return null;
            }
            PsiElement file2 = psiElement2;
            StructureViewModel model2 = StructureAwareNavBarModelExtension.buildStructureViewModel$default(this, (PsiFile)file2, null, 2, null);
            if (model2 != null) {
                StructureViewTreeElement structureViewTreeElement = model2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)structureViewTreeElement, (String)"model.root");
                PsiElement parentInModel = this.findParentInModel(structureViewTreeElement, psiElement);
                if (this.acceptParentFromModel(parentInModel)) {
                    return parentInModel;
                }
            }
        }
        return super.getParent(psiElement);
    }

    protected boolean acceptParentFromModel(@Nullable PsiElement psiElement) {
        return true;
    }

    @Nullable
    protected PsiElement findParentInModel(@NotNull StructureViewTreeElement root2, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Iterator<TreeElement> iterator2 = this.childrenFromNodeAndProviders(root2).iterator();
        while (iterator2.hasNext()) {
            TreeElement child2;
            TreeElement treeElement = child2 = iterator2.next();
            if (treeElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.structureView.StructureViewTreeElement");
            }
            if (Intrinsics.areEqual((Object)((StructureViewTreeElement)treeElement).getValue(), (Object)psiElement)) {
                Object object = root2.getValue();
                if (!(object instanceof PsiElement)) {
                    object = null;
                }
                return (PsiElement)object;
            }
            PsiElement psiElement2 = this.findParentInModel((StructureViewTreeElement)child2, psiElement);
            if (psiElement2 == null) continue;
            PsiElement psiElement3 = psiElement2;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement3;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    @Nullable
    protected final StructureViewModel buildStructureViewModel(@NotNull PsiFile file2, @Nullable Editor editor2) {
        StructureViewModel model2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            SoftReference<PsiFile> softReference = this.currentFile;
            if (Intrinsics.areEqual((Object)(softReference != null ? (PsiFile)softReference.get() : null), (Object)file2) && this.currentFileModCount == file2.getModificationStamp()) {
                if (editor2 == null) {
                    StructureViewModel structureViewModel = this.currentFileStructure;
                    if (structureViewModel != null && (structureViewModel = (StructureViewModel)structureViewModel.get()) != null) {
                        StructureViewModel structureViewModel2 = structureViewModel;
                        boolean bl = false;
                        boolean bl2 = false;
                        StructureViewModel it = structureViewModel2;
                        boolean bl3 = false;
                        return it;
                    }
                } else {
                    SoftReference editorStructure = (SoftReference)editor2.getUserData(MODEL);
                    SoftReference softReference2 = editorStructure;
                    if (softReference2 != null && (softReference2 = (StructureViewModel)softReference2.get()) != null) {
                        SoftReference softReference3 = softReference2;
                        boolean bl = false;
                        boolean bl4 = false;
                        SoftReference it = softReference3;
                        boolean bl5 = false;
                        return it;
                    }
                }
            }
            if ((model2 = this.createModel(file2, editor2)) == null) break block6;
            this.currentFile = new SoftReference((Object)file2);
            this.currentFileStructure = new SoftReference((Object)model2);
            this.currentFileModCount = file2.getModificationStamp();
            Editor editor3 = editor2;
            if (editor3 != null) {
                editor3.putUserData(MODEL, this.currentFileStructure);
            }
        }
        return model2;
    }

    public static /* synthetic */ StructureViewModel buildStructureViewModel$default(StructureAwareNavBarModelExtension structureAwareNavBarModelExtension, PsiFile psiFile, Editor editor2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildStructureViewModel");
        }
        if ((n & 2) != 0) {
            editor2 = null;
        }
        return structureAwareNavBarModelExtension.buildStructureViewModel(psiFile, editor2);
    }

    @Nullable
    protected StructureViewModel createModel(@NotNull PsiFile file2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(file2);
        StructureViewBuilder structureViewBuilder = builder2;
        if (!(structureViewBuilder instanceof TreeBasedStructureViewBuilder)) {
            structureViewBuilder = null;
        }
        TreeBasedStructureViewBuilder treeBasedStructureViewBuilder = (TreeBasedStructureViewBuilder)structureViewBuilder;
        return treeBasedStructureViewBuilder != null ? treeBasedStructureViewBuilder.createStructureViewModel(editor2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processStructureViewChildren(StructureViewTreeElement parent, Object object, Processor<Object> processor2) {
        boolean bl;
        block10: {
            Iterable $this$filterIsInstance$iv;
            if (Intrinsics.areEqual((Object)parent.getValue(), (Object)object)) {
                boolean bl2;
                block9: {
                    void $this$all$iv;
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv2;
                    Iterable iterable = this.childrenFromNodeAndProviders(parent);
                    boolean $i$f$filterIsInstance = false;
                    void var6_8 = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv = iterator2.next();
                        if (!(element$iv$iv instanceof StructureViewTreeElement)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv2 = (List)destination$iv$iv;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            StructureViewTreeElement it = (StructureViewTreeElement)element$iv;
                            boolean bl3 = false;
                            if (processor2.process(it.getValue())) continue;
                            bl2 = false;
                            break block9;
                        }
                        bl2 = true;
                    }
                }
                return bl2;
            }
            Iterable $this$all$iv = this.childrenFromNodeAndProviders(parent);
            boolean $i$f$filterIsInstance = false;
            void $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof StructureViewTreeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StructureViewTreeElement it = (StructureViewTreeElement)element$iv;
                    boolean bl4 = false;
                    if (this.processStructureViewChildren(it, object, processor2)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<TreeElement> childrenFromNodeAndProviders(@NotNull StructureViewTreeElement parent) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (parent instanceof PsiTreeElementBase) {
            List list3 = ((PsiTreeElementBase)parent).getChildrenWithoutCustomRegions();
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"parent.childrenWithoutCustomRegions");
        } else {
            Object[] objectArray = parent.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parent.children");
            list2 = ArraysKt.toList((Object[])objectArray);
        }
        List children2 = list2;
        Iterable iterable = this.getApplicableNodeProviders();
        Collection collection = children2;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NodeProvider it = (NodeProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.provideNodes((TreeElement)parent);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list4 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list4);
    }

    @Override
    public boolean normalizeChildren() {
        return false;
    }

    @NotNull
    protected List<NodeProvider<?>> getApplicableNodeProviders() {
        return this.applicableNodeProviders;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"editor.structure.model");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"editor.structure.model\")");
        MODEL = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/navigationToolbar/StructureAwareNavBarModelExtension$Companion;", "", "()V", "MODEL", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/reference/SoftReference;", "Lcom/intellij/ide/structureView/StructureViewModel;", "getMODEL", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final Key<SoftReference<StructureViewModel>> getMODEL() {
            return MODEL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

