/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.experimental;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.navigationToolbar.experimental.SearchEverywhereNewToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction;", "Lcom/intellij/ide/actions/SearchEverywhereAction;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "clearPosition", "", "firstOpened", "margin", "", "subscribedForDoubleShift", "afterActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "beforeActionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "showHotkey", "update", "Companion", "intellij.platform.lang.impl"})
public final class SearchEverywhereNewToolbarAction
extends SearchEverywhereAction
implements AnActionListener,
DumbAware {
    private final int margin = JBUI.scale((int)4);
    private boolean subscribedForDoubleShift;
    private boolean firstOpened;
    private boolean clearPosition;
    @NotNull
    public static final String SHOW_HOT_KEY_TIP = "com.intellij.ide.navigationToolbar.experimental.showSearchEverywhereHotKeyTip";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void update(@NotNull AnActionEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)event.getPlace(), (Object)"MainToolbar") ^ true) {
                Presentation presentation2 = event.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
                presentation2.setEnabledAndVisible(false);
                return;
            }
            Presentation presentation3 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"event.presentation");
            presentation3.setText(!this.showHotkey() ? ActionsBundle.message((String)"action.SearchEverywhereToolbar.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.SearchEverywhereToolbarHotKey.text", (Object[])new Object[0]));
            Presentation presentation4 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"event.presentation");
            presentation4.setIcon(AllIcons.Actions.Search);
            if (this.subscribedForDoubleShift) break block2;
            Project project = event.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                application.getMessageBus().connect((Disposable)it).subscribe(AnActionListener.TOPIC, (Object)this);
                this.subscribedForDoubleShift = true;
            }
        }
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return new ActionButtonWithText(this, presentation2, place, this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){
            @Nullable
            private SearchEverywhereManager seManager;
            final /* synthetic */ SearchEverywhereNewToolbarAction this$0;
            final /* synthetic */ Presentation $presentation;
            final /* synthetic */ String $place;

            @Nullable
            public final SearchEverywhereManager getSeManager() {
                return this.seManager;
            }

            public final void setSeManager(@Nullable SearchEverywhereManager searchEverywhereManager) {
                this.seManager = searchEverywhereManager;
            }

            protected void updateToolTipText() {
                String shortcutText = SearchEverywhereNewToolbarAction.access$getShortcut$s1869332970();
                String classesTabName = String.join((CharSequence)"/", (Iterable<? extends CharSequence>)GotoClassPresentationUpdater.getActionTitlePluralized());
                if (Registry.is((String)"ide.helptooltip.enabled")) {
                    HelpTooltip.dispose((Component)this);
                    if (this.$presentation.isEnabledAndVisible()) {
                        HelpTooltip helpTooltip = new HelpTooltip();
                        Presentation presentation2 = this.myPresentation;
                        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"myPresentation");
                        helpTooltip.setTitle(presentation2.getText()).setShortcut(shortcutText).setDescription(IdeBundle.message((String)"search.everywhere.action.tooltip.description.text", (Object[])new Object[]{classesTabName})).installOn((JComponent)this);
                    }
                } else if (this.$presentation.isEnabledAndVisible()) {
                    this.setToolTipText(IdeBundle.message((String)"search.everywhere.action.tooltip.text", (Object[])new Object[]{shortcutText, classesTabName}));
                } else {
                    this.setToolTipText("");
                }
            }

            protected void actionPerformed(@NotNull AnActionEvent e) {
                DataContext dataContext;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.seManager = SearchEverywhereManager.getInstance(e.getProject());
                IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
                Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.findInstance()");
                IdeFocusManager focusManager = ideFocusManager;
                Component focusedComponent = focusManager.getFocusOwner();
                Window ideWindow = focusManager.getLastFocusedIdeWindow();
                if (ideWindow == focusedComponent || focusedComponent == focusManager.getLastFocusedFor(ideWindow)) {
                    dataContext = DataManager.getInstance().getDataContext(focusedComponent);
                } else {
                    DataManager dataManager = DataManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
                    dataContext = dataManager.getDataContext();
                }
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"if (ideWindow === focuse\u2026getInstance().dataContext");
                DataContext dataContext2 = dataContext;
                if (!SearchEverywhereNewToolbarAction.access$getFirstOpened$p(this.this$0)) {
                    super.actionPerformed(new AnActionEvent(e.getInputEvent(), dataContext2, "RunToolbarLeftSide", this.this$0.getTemplatePresentation(), ActionManager.getInstance(), 0));
                    SearchEverywhereNewToolbarAction.access$setFirstOpened$p(this.this$0, true);
                } else {
                    super.actionPerformed(new AnActionEvent(e.getInputEvent(), dataContext2, "keyboard shortcut", this.this$0.getTemplatePresentation(), ActionManager.getInstance(), 0));
                }
            }

            public int getPopState() {
                return 0;
            }

            public void paint(@Nullable Graphics g) {
                Container container = this.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"parent");
                int n = container.getBounds().width;
                Container container2 = this.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)container2, (String)"parent");
                if (n < container2.getPreferredSize().width) {
                    if (this.$presentation.isEnabledAndVisible()) {
                        this.$presentation.setEnabledAndVisible(false);
                        this.updateToolTipText();
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    return;
                }
                if (!this.$presentation.isEnabledAndVisible()) {
                    this.$presentation.setEnabledAndVisible(true);
                    this.updateToolTipText();
                    this.setCursor(Cursor.getPredefinedCursor(2));
                }
                this.setForeground(JBUI.CurrentTheme.TabbedPane.DISABLED_TEXT_COLOR);
                this.setBackground(JBUI.CurrentTheme.BigPopup.searchFieldBackground());
                super.paint(g);
            }

            protected int iconTextSpace() {
                return super.iconTextSpace() + SearchEverywhereNewToolbarAction.access$getMargin$p(this.this$0);
            }

            public void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                UISettings.Companion.setupAntialiasing(g);
                FontMetrics fm = this.getFontMetrics(this.getFont());
                Rectangle viewRect = this.getButtonRect();
                Rectangle iconRect = new Rectangle();
                Rectangle textRect = new Rectangle();
                String text2 = SwingUtilities.layoutCompoundLabel(this, fm, this.$presentation.getText(true), this.getIcon(), 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
                if (this.seManager != null) {
                    SearchEverywhereManager searchEverywhereManager = this.seManager;
                    Intrinsics.checkNotNull((Object)searchEverywhereManager);
                    if (searchEverywhereManager.isShown()) {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        this.setOpaque(false);
                        this.setBorder(null);
                        String string = ActionsBundle.message((String)"action.SearchEverywhereToolbar.searching.text", (Object[])new Object[0]);
                        int n = this.getMnemonicCharIndex(text2);
                        int n2 = textRect.x;
                        int n3 = textRect.y;
                        FontMetrics fontMetrics = fm;
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                        BasicGraphicsUtils.drawStringUnderlineCharAt(g, string, n, n2, n3 + fontMetrics.getAscent());
                        return;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(2));
                Icon icon2 = this.getIcon();
                JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getInsets());
                JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getMargins());
                iconRect.x = SearchEverywhereNewToolbarAction.access$getMargin$p(this.this$0);
                ActionButtonLook look = this.getButtonLook();
                look.paintBackground(g, (JComponent)this);
                look.paintIcon(g, this, icon2, iconRect.x, iconRect.y);
                look.paintBorder(g, (JComponent)this);
                g.setColor(this.$presentation.isEnabled() ? this.getForeground() : this.getInactiveTextColor());
                int n = this.getMnemonicCharIndex(text2);
                int n4 = textRect.x;
                int n5 = textRect.y;
                FontMetrics fontMetrics = fm;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text2, n, n4, n5 + fontMetrics.getAscent());
            }
            {
                this.this$0 = this$0;
                this.$presentation = $captured_local_variable$1;
                this.$place = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                FocusManager.getCurrentManager().addPropertyChangeListener(new PropertyChangeListener(this){
                    final /* synthetic */ createCustomComponent.1 this$0;

                    public final void propertyChange(PropertyChangeEvent it) {
                        this.this$0.repaint();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                this.setHorizontalTextAlignment(2);
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        };
    }

    private final boolean showHotkey() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_HOT_KEY_TIP, true) && !AdvancedSettings.Companion.getBoolean("ide.suppress.double.click.handler");
    }

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (action2 instanceof SearchEverywhereAction && this.showHotkey() && event.getInputEvent() instanceof KeyEvent) {
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.event.KeyEvent");
            }
            if (((KeyEvent)inputEvent).getKeyCode() == 16) {
                PropertiesComponent.getInstance().setValue(SHOW_HOT_KEY_TIP, false, true);
            }
        }
        if (action2 instanceof SearchEverywhereNewToolbarAction && Intrinsics.areEqual((Object)event.getPlace(), (Object)"MainToolbar")) {
            this.clearPosition = true;
        }
    }

    public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual(action2.getClass(), SearchEverywhereAction.class) && this.clearPosition) {
            Project project = event.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl = false;
                boolean bl2 = false;
                Project it = project2;
                boolean bl3 = false;
                WindowStateService.getInstance((Project)it).putLocation("search.everywhere.popup", null);
            }
            this.clearPosition = false;
        }
    }

    public static final /* synthetic */ String access$getShortcut$s1869332970() {
        return SearchEverywhereAction.getShortcut();
    }

    public static final /* synthetic */ boolean access$getFirstOpened$p(SearchEverywhereNewToolbarAction $this) {
        return $this.firstOpened;
    }

    public static final /* synthetic */ void access$setFirstOpened$p(SearchEverywhereNewToolbarAction $this, boolean bl) {
        $this.firstOpened = bl;
    }

    public static final /* synthetic */ int access$getMargin$p(SearchEverywhereNewToolbarAction $this) {
        return $this.margin;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/navigationToolbar/experimental/SearchEverywhereNewToolbarAction$Companion;", "", "()V", "SHOW_HOT_KEY_TIP", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

