/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.memory;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.ide.passwordSafe.impl.PasswordSafeTimed;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.util.registry.Registry;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2021.3")
public class MemoryPasswordSafe
implements PasswordStorage {
    private final transient AtomicReference<byte[]> key = new AtomicReference();
    private final transient PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>> database = new PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>>(){

        @Override
        protected Map<ByteArrayWrapper, byte[]> compute() {
            return Collections.synchronizedMap(new HashMap());
        }

        @Override
        protected int getMinutesToLive() {
            return MemoryPasswordSafe.this.getMinutesToLive();
        }
    };

    protected int getMinutesToLive() {
        return Registry.intValue((String)"passwordSafe.memorySafe.ttl");
    }

    protected byte @NotNull [] key() {
        if (this.key.get() == null) {
            byte[] rnd = new byte[256];
            new SecureRandom().nextBytes(rnd);
            this.key.compareAndSet(null, EncryptionUtil.genKey(EncryptionUtil.hash(new byte[][]{rnd})));
        }
        byte[] byArray = this.key.get();
        if (byArray == null) {
            MemoryPasswordSafe.$$$reportNull$$$0(0);
        }
        return byArray;
    }

    protected byte[] getEncryptedPassword(byte @NotNull [] key) {
        if (key == null) {
            MemoryPasswordSafe.$$$reportNull$$$0(1);
        }
        return this.database.get().get(new ByteArrayWrapper(key));
    }

    protected void removeEncryptedPassword(byte[] key) {
        this.database.get().remove(new ByteArrayWrapper(key));
    }

    protected void storeEncryptedPassword(byte[] key, byte[] encryptedPassword) {
        this.database.get().put(new ByteArrayWrapper(key), encryptedPassword);
    }

    public void clear() {
        this.database.get().clear();
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes2) {
        byte[] masterKey;
        byte[] encryptedPassword;
        if (attributes2 == null) {
            MemoryPasswordSafe.$$$reportNull$$$0(2);
        }
        OneTimeString password = (encryptedPassword = this.getEncryptedPassword(EncryptionUtil.encryptKey(masterKey = this.key(), EncryptionUtil.rawKey(attributes2)))) == null ? null : EncryptionUtil.decryptText(masterKey, encryptedPassword);
        return password == null ? null : new Credentials(attributes2.getUserName(), password);
    }

    public final void set(@NotNull CredentialAttributes attributes2, @Nullable Credentials value2) {
        if (attributes2 == null) {
            MemoryPasswordSafe.$$$reportNull$$$0(3);
        }
        byte[] key = EncryptionUtil.encryptKey(this.key(), EncryptionUtil.rawKey(attributes2));
        if (value2 == null || value2.getPassword() == null) {
            this.removeEncryptedPassword(key);
        } else {
            this.storeEncryptedPassword(key, EncryptionUtil.encryptText(this.key(), value2.getPassword()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/passwordSafe/impl/providers/memory/MemoryPasswordSafe";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/passwordSafe/impl/providers/memory/MemoryPasswordSafe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEncryptedPassword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

