/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.ide.plugins.marketplace.GuessFileParameters;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadServiceKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a*\u0010\u0018\u001a\u00020\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a*\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"BLOCKMAP_FILENAME", "", "BLOCKMAP_ZIP_SUFFIX", "FILENAME", "HASH_FILENAME_SUFFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAXIMUM_DOWNLOAD_PERCENT", "", "downloadPercent", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "getPluginFileUrl", "connection", "Ljava/net/URLConnection;", "getPluginFileUrlAndGuessFileParameters", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/marketplace/GuessFileParameters;", "pluginUrl", "getPrevPluginArchive", "Ljava/nio/file/Path;", "prevPlugin", "guessFileName", "contentDisposition", "usedURL", "file", "Ljava/io/File;", "guessPluginFile", "url", "intellij.platform.ide.impl"})
public final class MarketplacePluginDownloadServiceKt {
    private static final Logger LOG;
    private static final String BLOCKMAP_ZIP_SUFFIX = ".blockmap.zip";
    private static final String BLOCKMAP_FILENAME = "blockmap.json";
    private static final String HASH_FILENAME_SUFFIX = ".hash.json";
    private static final String FILENAME = "filename=";
    private static final double MAXIMUM_DOWNLOAD_PERCENT = 0.65;

    private static final File guessPluginFile(String contentDisposition, String url, File file2, String pluginUrl) {
        String fileName = MarketplacePluginDownloadServiceKt.guessFileName(contentDisposition, url, file2, pluginUrl);
        File newFile = new File(file2.getParentFile(), fileName);
        FileUtil.rename((File)file2, (File)newFile);
        return newFile;
    }

    private static final String guessFileName(String contentDisposition, String usedURL, File file2, String pluginUrl) throws IOException {
        String fileName = null;
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && StringsKt.contains$default((CharSequence)contentDisposition, (CharSequence)FILENAME, (boolean)false, (int)2, null)) {
            int startIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (String)FILENAME, (int)0, (boolean)false, (int)6, null);
            int endIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (char)';', (int)startIdx, (boolean)false, (int)4, null);
            String string = contentDisposition;
            int n = startIdx + FILENAME.length();
            int n2 = endIdx > 0 ? endIdx : contentDisposition.length();
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            fileName = string2;
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                string = fileName;
                n = 1;
                n2 = fileName.length() - 1;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                fileName = string4;
            }
        }
        if (fileName == null) {
            LOG.debug("url: " + usedURL);
            CharSequence charSequence = usedURL;
            int n = StringsKt.lastIndexOf$default((CharSequence)usedURL, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            fileName = string5;
            charSequence = fileName;
            n = 0;
            if (charSequence.length() == 0 || StringsKt.contains$default((CharSequence)fileName, (CharSequence)"?", (boolean)false, (int)2, null)) {
                charSequence = pluginUrl;
                n = StringsKt.lastIndexOf$default((CharSequence)pluginUrl, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                fileName = string6;
            }
        }
        if (!PathUtil.isValidFileName((String)fileName)) {
            LOG.debug("fileName: " + fileName);
            FileUtil.delete((File)file2);
            throw (Throwable)new IOException("Invalid filename returned by a server");
        }
        return fileName;
    }

    /*
     * WARNING - void declaration
     */
    private static final double downloadPercent(BlockMap oldBlockMap, BlockMap newBlockMap2) {
        int n;
        Chunk chunk;
        void $this$filterTo$iv$iv;
        Set oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable $this$filter$iv = newBlockMap2.getChunks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk2 = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!oldSet.contains(chunk2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newChunks = (List)destination$iv$iv;
        Iterable $this$sumBy$iv = newChunks;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            Chunk chunk3 = (Chunk)element$iv;
            int n2 = sum$iv;
            boolean bl = false;
            int n3 = chunk.getLength();
            sum$iv = n2 + n3;
        }
        $this$sumBy$iv = newBlockMap2.getChunks();
        double d = sum$iv;
        $i$f$sumBy = false;
        sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            chunk = (Chunk)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n4 = chunk.getLength();
            sum$iv = n + n4;
        }
        n = sum$iv;
        return d / (double)n;
    }

    private static final String getPluginFileUrl(URLConnection connection) {
        URL url;
        URL uRL = url = connection.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
        int port = uRL.getPort();
        return port == -1 ? url.getProtocol() + "://" + url.getHost() + url.getPath() : url.getProtocol() + "://" + url.getHost() + ':' + port + url.getPath();
    }

    private static final Pair<String, GuessFileParameters> getPluginFileUrlAndGuessFileParameters(String pluginUrl) {
        Object object = HttpRequests.request((String)pluginUrl).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)getPluginFileUrlAndGuessFileParameters.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(plu\u2026tion.url.toString()))\n  }");
        return (Pair)object;
    }

    private static final Path getPrevPluginArchive(Path prevPlugin) {
        String suffix = prevPlugin.endsWith(".jar") ? "" : ".zip";
        Path path2 = Paths.get(PathManager.getPluginTempPath(), new String[0]).resolve(prevPlugin.getFileName() + suffix);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(PathManager.ge\u2026Plugin.fileName}$suffix\")");
        return path2;
    }

    static {
        Logger logger = Logger.getInstance(MarketplacePluginDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Marke\u2026nloadService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ String access$getPluginFileUrl(URLConnection connection) {
        return MarketplacePluginDownloadServiceKt.getPluginFileUrl(connection);
    }

    public static final /* synthetic */ File access$guessPluginFile(String contentDisposition, String url, File file2, String pluginUrl) {
        return MarketplacePluginDownloadServiceKt.guessPluginFile(contentDisposition, url, file2, pluginUrl);
    }

    public static final /* synthetic */ Path access$getPrevPluginArchive(Path prevPlugin) {
        return MarketplacePluginDownloadServiceKt.getPrevPluginArchive(prevPlugin);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Pair access$getPluginFileUrlAndGuessFileParameters(String pluginUrl) {
        return MarketplacePluginDownloadServiceKt.getPluginFileUrlAndGuessFileParameters(pluginUrl);
    }

    public static final /* synthetic */ double access$downloadPercent(BlockMap oldBlockMap, BlockMap newBlockMap2) {
        return MarketplacePluginDownloadServiceKt.downloadPercent(oldBlockMap, newBlockMap2);
    }
}

