/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginInfoProvider;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.CompatibleUpdateForModuleRequest;
import com.intellij.ide.plugins.marketplace.CompatibleUpdateRequest;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.IntellijUpdateMetadata;
import com.intellij.ide.plugins.marketplace.MarketplaceBrokenPlugin;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests$deserializeJetBrainsPluginsIds$2;
import com.intellij.ide.plugins.marketplace.MarketplaceRequestsKt;
import com.intellij.ide.plugins.marketplace.MarketplaceSearchPluginData;
import com.intellij.ide.plugins.marketplace.RepositoryContentHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresNoReadLock;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.IoErrorText;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 @2\u00020\u0001:\u0001@B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0014\u001a\u00020\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\fJ \u0010!\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u000b2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020\u0004J#\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\f2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b+J \u0010'\u001a\b\u0012\u0004\u0012\u00020(0\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bJ*\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\"2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010$2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J*\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00102\u001a\u00020\u00042\n\b\u0002\u0010/\u001a\u0004\u0018\u00010$2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\"0\u00102\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J\u0010\u00104\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u0010H\u0016J\u0006\u00105\u001a\u00020\u001bJ\u0006\u00106\u001a\u00020\u001bJ\u001e\u00107\u001a\u0004\u0018\u00010-2\u0006\u00108\u001a\u00020-2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J\u001e\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00100:2\b\u00100\u001a\u0004\u0018\u000101H\u0016J$\u0010;\u001a\u0016\u0012\u0004\u0012\u00020\" <*\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u00100\u00102\u0006\u0010=\u001a\u00020>H\u0002J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020-0\f2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f\u0018\u00010\u000b2\u001a\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR.\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00102\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006A"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "Lcom/intellij/ide/plugins/PluginInfoProvider;", "()V", "IDE_BUILD_FOR_REQUEST", "", "Lorg/jetbrains/annotations/NotNull;", "IDE_EXTENSIONS_URL", "Lcom/intellij/util/Url;", "JETBRAINS_PLUGINS_URL", "MARKETPLACE_ORGANIZATIONS_URL", "<set-?>", "", "", "extensionsForIdes", "getExtensionsForIdes", "()Ljava/util/Map;", "", "jetBrainsPluginsIds", "getJetBrainsPluginsIds", "()Ljava/util/Set;", "createFeatureUrl", "param", "createSearchUrl", "query", "count", "", "deserializeExtensionsForIdes", "", "stream", "Ljava/io/InputStream;", "deserializeJetBrainsPluginsIds", "getAllPluginsTags", "getAllPluginsVendors", "getBrokenPlugins", "Lcom/intellij/openapi/extensions/PluginId;", "currentBuild", "Lcom/intellij/openapi/util/BuildNumber;", "getCompatibleUpdateByModule", "module", "getFeatures", "Lcom/intellij/ide/plugins/marketplace/FeatureImpl;", "featureType", "implementationName", "getFeatures$intellij_platform_ide_impl", "getLastCompatiblePluginUpdate", "Lcom/intellij/ide/plugins/PluginNode;", "pluginId", "buildNumber", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "id", "getMarketplacePlugins", "loadCachedPlugins", "loadExtensionsForIdes", "loadJetBrainsPluginsIds", "loadPluginDetails", "pluginNode", "loadPlugins", "Ljava/util/concurrent/Future;", "parseXmlIds", "kotlin.jvm.PlatformType", "reader", "Ljava/io/Reader;", "searchPlugins", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class MarketplaceRequests
implements PluginInfoProvider {
    private final String IDE_BUILD_FOR_REQUEST;
    private final Url MARKETPLACE_ORGANIZATIONS_URL;
    private final Url JETBRAINS_PLUGINS_URL;
    private final Url IDE_EXTENSIONS_URL;
    @Nullable
    private Set<String> jetBrainsPluginsIds;
    @Nullable
    private Map<String, ? extends List<String>> extensionsForIdes;
    private static final Lazy objectMapper$delegate;
    private static final String PLUGIN_MANAGER_URL;
    private static final String COMPATIBLE_UPDATE_URL;
    @NotNull
    public static final Companion Companion;

    private final Url createSearchUrl(String query2, int count) {
        return Urls.newFromEncoded((String)(PLUGIN_MANAGER_URL + "/api/search/plugins?" + query2 + "&build=" + this.IDE_BUILD_FOR_REQUEST + "&max=" + count));
    }

    private final Url createFeatureUrl(Map<String, String> param) {
        Url url = Urls.newFromEncoded((String)(PLUGIN_MANAGER_URL + "/feature/getImplementations")).addParameters(param);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"Urls.newFromEncoded(\"${P\u2026ns\").addParameters(param)");
        return url;
    }

    @NotNull
    public final List<FeatureImpl> getFeatures(@NotNull Map<String, String> param) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        if (param.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        try {
            Object object = HttpRequests.request((Url)this.createFeatureUrl(param)).throwStatusCodeException(false).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)getFeatures.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026 {}\n          )\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get features from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final List<FeatureImpl> getFeatures$intellij_platform_ide_impl(@NotNull String featureType, @NotNull String implementationName) {
        Intrinsics.checkNotNullParameter((Object)featureType, (String)"featureType");
        Intrinsics.checkNotNullParameter((Object)implementationName, (String)"implementationName");
        Map param = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"featureType", (Object)featureType), TuplesKt.to((Object)"implementationName", (Object)implementationName), TuplesKt.to((Object)"build", (Object)MarketplaceRequests.Companion.getApplicationInfo().getPluginsCompatibleBuild())});
        return this.getFeatures(param);
    }

    @RequiresBackgroundThread
    @JvmOverloads
    @NotNull
    public final Set<PluginId> getMarketplacePlugins(@Nullable ProgressIndicator indicator2) throws IOException {
        Path path2 = Paths.get(PathManager.getPluginTempPath(), "pluginsXMLIds.json");
        String string = PLUGIN_MANAGER_URL + "/files/pluginsXMLIds.json";
        String string2 = IdeBundle.message((String)"progress.downloading.available.plugins", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"progr\u2026ading.available.plugins\")");
        Object t = Companion.readOrUpdateFile(path2, string, indicator2, string2, (Function1)new Function1<Reader, Set<? extends PluginId>>(this){

            public final Set<PluginId> invoke(@NotNull Reader p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return MarketplaceRequests.access$parseXmlIds((MarketplaceRequests)this.receiver, p1);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"readOrUpdateFile(\n      \u2026     ::parseXmlIds,\n    )");
        return (Set)t;
    }

    public static /* synthetic */ Set getMarketplacePlugins$default(MarketplaceRequests marketplaceRequests, ProgressIndicator progressIndicator, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.getMarketplacePlugins(progressIndicator);
    }

    @RequiresBackgroundThread
    @JvmOverloads
    @NotNull
    public final Set<PluginId> getMarketplacePlugins() throws IOException {
        return MarketplaceRequests.getMarketplacePlugins$default(this, null, 1, null);
    }

    @NotNull
    public Future<Set<PluginId>> loadPlugins(@Nullable ProgressIndicator indicator2) {
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Callable(this, indicator2){
            final /* synthetic */ MarketplaceRequests this$0;
            final /* synthetic */ ProgressIndicator $indicator;

            public final Set<PluginId> call() {
                Set set2;
                try {
                    set2 = this.this$0.getMarketplacePlugins(this.$indicator);
                }
                catch (IOException e) {
                    MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Cannot get plugins from Marketplace", e);
                    set2 = SetsKt.emptySet();
                }
                return set2;
            }
            {
                this.this$0 = marketplaceRequests;
                this.$indicator = progressIndicator;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"ApplicationManager.getAp\u2026emptySet()\n      }\n    })");
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<PluginId> loadCachedPlugins() {
        block7: {
            Path pluginXmlIdsFile = Paths.get(PathManager.getPluginTempPath(), "pluginsXMLIds.json");
            try {
                Set<PluginId> set2;
                if (Files.size(pluginXmlIdsFile) <= 0L) break block7;
                Closeable closeable = Files.newBufferedReader(pluginXmlIdsFile);
                MarketplaceRequests marketplaceRequests = this;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Reader p1 = (Reader)closeable;
                    boolean bl3 = false;
                    set2 = marketplaceRequests.parseXmlIds(p1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return set2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginNode> searchPlugins(@NotNull String query2, int count) throws IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MarketplaceSearchPluginData it;
        void $this$filterTo$iv$iv;
        List marketplaceSearchPluginData2;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        List list2 = marketplaceSearchPluginData2 = (List)HttpRequests.request((Url)this.createSearchUrl(query2, count)).throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)searchPlugins.marketplaceSearchPluginData.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"marketplaceSearchPluginData");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MarketplaceSearchPluginData)element$iv$iv;
            boolean bl = false;
            if (!(it.getExternalUpdateId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MarketplaceSearchPluginData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PluginNode pluginNode = it.toPluginNode();
            collection.add(pluginNode);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> getAllPluginsVendors() {
        try {
            Object object = HttpRequests.request((Url)this.MARKETPLACE_ORGANIZATIONS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)getAllPluginsVendors.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026s.keys.toList()\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get organizations from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final Map<PluginId, Set<String>> getBrokenPlugins(@NotNull BuildNumber currentBuild) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)currentBuild, (String)"currentBuild");
        try {
            list2 = (List)Companion.readOrUpdateFile(Paths.get(PathManager.getPluginTempPath(), "brokenPlugins.json"), PLUGIN_MANAGER_URL + "/files/brokenPlugins.json", null, "", getBrokenPlugins.brokenPlugins.1.INSTANCE);
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get broken plugins file from Marketplace", e);
            return MapsKt.emptyMap();
        }
        List brokenPlugins2 = list2;
        HashMap brokenPluginsMap = new HashMap();
        List list3 = brokenPlugins2;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"brokenPlugins");
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MarketplaceBrokenPlugin record = (MarketplaceBrokenPlugin)element$iv;
            boolean bl = false;
            try {
                String string;
                boolean bl2;
                String parsedOriginalUntil;
                String string2;
                if (record.getOriginalUntil() != null) {
                    String string3;
                    boolean bl3 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                } else {
                    string2 = parsedOriginalUntil = null;
                }
                if (record.getOriginalSince() != null) {
                    String string5;
                    bl2 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                } else {
                    string = null;
                }
                String parsedOriginalSince = string;
                CharSequence charSequence = parsedOriginalUntil;
                bl2 = false;
                boolean bl4 = false;
                if (charSequence == null || charSequence.length() == 0) continue;
                charSequence = parsedOriginalSince;
                bl2 = false;
                bl4 = false;
                if (charSequence == null || charSequence.length() == 0) continue;
                BuildNumber buildNumber = BuildNumber.fromString((String)parsedOriginalUntil, (String)record.getId(), null);
                if (buildNumber == null) {
                    buildNumber = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(p\u2026id, null) ?: currentBuild");
                BuildNumber originalUntil = buildNumber;
                BuildNumber buildNumber2 = BuildNumber.fromString((String)parsedOriginalSince, (String)record.getId(), null);
                if (buildNumber2 == null) {
                    buildNumber2 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"BuildNumber.fromString(p\u2026id, null) ?: currentBuild");
                BuildNumber originalSince = buildNumber2;
                BuildNumber buildNumber3 = BuildNumber.fromString((String)record.getUntil());
                if (buildNumber3 == null) {
                    buildNumber3 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber3, (String)"BuildNumber.fromString(r\u2026rd.until) ?: currentBuild");
                BuildNumber until = buildNumber3;
                BuildNumber buildNumber4 = BuildNumber.fromString((String)record.getSince());
                if (buildNumber4 == null) {
                    buildNumber4 = currentBuild;
                }
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber4, (String)"BuildNumber.fromString(r\u2026rd.since) ?: currentBuild");
                BuildNumber since = buildNumber4;
                Comparable comparable = (Comparable)currentBuild;
                if (comparable.compareTo((Comparable)originalSince) < 0 || comparable.compareTo((Comparable)originalUntil) > 0 || (comparable = (Comparable)currentBuild).compareTo((Comparable)since) >= 0 && comparable.compareTo((Comparable)until) <= 0) continue;
                ((Set)brokenPluginsMap.computeIfAbsent(PluginId.getId((String)record.getId()), getBrokenPlugins.1.1.INSTANCE)).add(record.getVersion());
            }
            catch (Exception e) {
                MarketplaceRequestsKt.access$getLOG$p().error("cannot parse " + record, (Throwable)e);
            }
        }
        return brokenPluginsMap;
    }

    @NotNull
    public final List<String> getAllPluginsTags() {
        try {
            Object object = HttpRequests.request((Url)Urls.newFromEncoded((String)(PLUGIN_MANAGER_URL + "/api/search/aggregation/tags")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)))).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)getAllPluginsTags.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026s.keys.toList()\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get tags from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode loadPluginDetails(@NotNull PluginNode pluginNode, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)pluginNode, (String)"pluginNode");
        String string = pluginNode.getExternalPluginId();
        if (string == null) {
            return pluginNode;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginNode.externalPluginId ?: return pluginNode");
        String externalPluginId = string;
        String string2 = pluginNode.getExternalUpdateId();
        if (string2 == null) {
            return pluginNode;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluginNode.externalUpdateId ?: return pluginNode");
        String externalUpdateId = string2;
        try {
            PluginId pluginId = pluginNode.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginNode.pluginId");
            String string3 = pluginId.getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluginNode.pluginId.idString");
            PluginNode pluginNode2 = Companion.loadPluginDescriptor$intellij_platform_ide_impl(string3, new IdeCompatibleUpdate(externalUpdateId, externalPluginId, null, null, 12, null), indicator2);
            boolean bl = false;
            boolean bl2 = false;
            PluginNode $this$apply = pluginNode2;
            boolean bl3 = false;
            $this$apply.setRating(pluginNode.getRating());
            $this$apply.setDownloads(pluginNode.getDownloads());
            $this$apply.setDate(pluginNode.getDate());
            return pluginNode2;
        }
        catch (IOException e) {
            MarketplaceRequestsKt.access$getLOG$p().error((Throwable)e);
            return null;
        }
    }

    public static /* synthetic */ PluginNode loadPluginDetails$default(MarketplaceRequests marketplaceRequests, PluginNode pluginNode, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.loadPluginDetails(pluginNode, progressIndicator);
    }

    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode loadPluginDetails(@NotNull PluginNode pluginNode) {
        return MarketplaceRequests.loadPluginDetails$default(this, pluginNode, null, 2, null);
    }

    @Deprecated(message="Please use `PluginId`", replaceWith=@ReplaceWith(imports={}, expression="getLastCompatiblePluginUpdate(PluginId.get(id), buildNumber, indicator)"))
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        PluginId pluginId = PluginId.getId((String)id2);
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(id)");
        return this.getLastCompatiblePluginUpdate(pluginId, buildNumber, indicator2);
    }

    public static /* synthetic */ PluginNode getLastCompatiblePluginUpdate$default(MarketplaceRequests marketplaceRequests, String string, BuildNumber buildNumber, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.getLastCompatiblePluginUpdate(string, buildNumber, progressIndicator);
    }

    @Deprecated(message="Please use `PluginId`", replaceWith=@ReplaceWith(imports={}, expression="getLastCompatiblePluginUpdate(PluginId.get(id), buildNumber, indicator)"))
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2, @Nullable BuildNumber buildNumber) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, id2, buildNumber, null, 4, null);
    }

    @Deprecated(message="Please use `PluginId`", replaceWith=@ReplaceWith(imports={}, expression="getLastCompatiblePluginUpdate(PluginId.get(id), buildNumber, indicator)"))
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, id2, null, null, 6, null);
    }

    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull PluginId pluginId, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator2) {
        PluginNode pluginNode;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        IdeCompatibleUpdate ideCompatibleUpdate = (IdeCompatibleUpdate)CollectionsKt.firstOrNull(Companion.getLastCompatiblePluginUpdate(SetsKt.setOf((Object)pluginId), buildNumber));
        if (ideCompatibleUpdate != null) {
            IdeCompatibleUpdate ideCompatibleUpdate2 = ideCompatibleUpdate;
            boolean bl = false;
            boolean bl2 = false;
            IdeCompatibleUpdate it = ideCompatibleUpdate2;
            boolean bl3 = false;
            String string = pluginId.getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginId.idString");
            pluginNode = Companion.loadPluginDescriptor$intellij_platform_ide_impl(string, it, indicator2);
        } else {
            pluginNode = null;
        }
        return pluginNode;
    }

    public static /* synthetic */ PluginNode getLastCompatiblePluginUpdate$default(MarketplaceRequests marketplaceRequests, PluginId pluginId, BuildNumber buildNumber, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.getLastCompatiblePluginUpdate(pluginId, buildNumber, progressIndicator);
    }

    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull PluginId pluginId, @Nullable BuildNumber buildNumber) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, pluginId, buildNumber, null, 4, null);
    }

    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull PluginId pluginId) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, pluginId, null, null, 6, null);
    }

    @Nullable
    public final PluginId getCompatibleUpdateByModule(@NotNull String module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        try {
            PluginId pluginId;
            String data2 = MarketplaceRequests.Companion.getObjectMapper().writeValueAsString((Object)new CompatibleUpdateForModuleRequest(module, null, 2, null));
            Object object = HttpRequests.post((String)Urls.newFromEncoded((String)COMPATIBLE_UPDATE_URL).toExternalForm(), (String)"application/json; charset=utf-8").productNameAsUserAgent().throwStatusCodeException(false).connect(new HttpRequests.RequestProcessor(data2){
                final /* synthetic */ String $data;

                public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.write(this.$data);
                    return (List)com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.access$getObjectMapper$p(MarketplaceRequests.Companion).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                }
                {
                    this.$data = string;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.post(\n     \u2026eUpdate>>() {})\n        }");
            Object object2 = (IdeCompatibleUpdate)CollectionsKt.firstOrNull((List)((List)object));
            if (object2 != null && (object2 = ((IdeCompatibleUpdate)object2).getPluginId()) != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                pluginId = PluginId.getId((String)it);
            } else {
                pluginId = null;
            }
            return pluginId;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get compatible update by module from Marketplace", e);
            return null;
        }
    }

    @Nullable
    public final Set<String> getJetBrainsPluginsIds() {
        return this.jetBrainsPluginsIds;
    }

    public final void loadJetBrainsPluginsIds() {
        if (this.jetBrainsPluginsIds != null) {
            return;
        }
        try {
            HttpRequests.request((Url)this.JETBRAINS_PLUGINS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect(new HttpRequests.RequestProcessor(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final void process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InputStream inputStream2 = it.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"it.inputStream");
                    this.this$0.deserializeJetBrainsPluginsIds(inputStream2);
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get JetBrains plugins' IDs from Marketplace", e);
            this.jetBrainsPluginsIds = null;
        }
    }

    @VisibleForTesting
    public final void deserializeJetBrainsPluginsIds(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Object object = MarketplaceRequests.Companion.getObjectMapper().readValue(stream, (TypeReference)new TypeReference<List<? extends MarketplaceSearchPluginData>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(s\u2026eSearchPluginData>>() {})");
        this.jetBrainsPluginsIds = (Set)SequencesKt.toCollection((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)((Function1)MarketplaceRequests$deserializeJetBrainsPluginsIds$2.INSTANCE)), (Collection)new HashSet());
    }

    @Nullable
    public final Map<String, List<String>> getExtensionsForIdes() {
        return this.extensionsForIdes;
    }

    public final void loadExtensionsForIdes() {
        if (this.extensionsForIdes != null) {
            return;
        }
        try {
            HttpRequests.request((Url)this.IDE_EXTENSIONS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect(new HttpRequests.RequestProcessor(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final void process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InputStream inputStream2 = it.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"it.inputStream");
                    this.this$0.deserializeExtensionsForIdes(inputStream2);
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get supported extensions from Marketplace", e);
            this.extensionsForIdes = null;
        }
    }

    @VisibleForTesting
    public final void deserializeExtensionsForIdes(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.extensionsForIdes = (Map)MarketplaceRequests.Companion.getObjectMapper().readValue(stream, (TypeReference)new TypeReference<Map<String, ? extends List<? extends String>>>(){});
    }

    private final Set<PluginId> parseXmlIds(Reader reader) {
        return (Set)MarketplaceRequests.Companion.getObjectMapper().readValue(reader, (TypeReference)new TypeReference<Set<? extends PluginId>>(){});
    }

    public MarketplaceRequests() {
        String string = URLUtil.encodeURIComponent((String)MarketplaceRequests.Companion.getApplicationInfo().getPluginsCompatibleBuild());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLUtil.encodeURICompone\u2026o.pluginsCompatibleBuild)");
        this.IDE_BUILD_FOR_REQUEST = string;
        Url url = Urls.newFromEncoded((String)(PLUGIN_MANAGER_URL + "/api/search/aggregation/organizations")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"Urls.newFromEncoded(\"${P\u2026o IDE_BUILD_FOR_REQUEST))");
        this.MARKETPLACE_ORGANIZATIONS_URL = url;
        Url url2 = Urls.newFromEncoded((String)(PLUGIN_MANAGER_URL + "/api/search/plugins?organization=JetBrains&max=1000")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"Urls.newFromEncoded(\n   \u2026o IDE_BUILD_FOR_REQUEST))");
        this.JETBRAINS_PLUGINS_URL = url2;
        Url url3 = Urls.newFromEncoded((String)(PLUGIN_MANAGER_URL + "/files/IDE/extensions.json")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"Urls.newFromEncoded(\"${P\u2026o IDE_BUILD_FOR_REQUEST))");
        this.IDE_EXTENSIONS_URL = url3;
    }

    static {
        Companion = new Companion(null);
        objectMapper$delegate = LazyKt.lazy((Function0)Companion.objectMapper.2.INSTANCE);
        String string = MarketplaceRequests.Companion.getApplicationInfo().getPluginManagerUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationInfo.pluginManagerUrl");
        PLUGIN_MANAGER_URL = StringsKt.trimEnd((String)string, (char[])new char[]{'/'});
        COMPATIBLE_UPDATE_URL = PLUGIN_MANAGER_URL + "/api/search/compatibleUpdates";
    }

    public static final /* synthetic */ Set access$parseXmlIds(MarketplaceRequests $this, Reader reader) {
        return $this.parseXmlIds(reader);
    }

    @NotNull
    public static final MarketplaceRequests getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final List<PluginNode> parsePluginList(@NotNull Reader reader) {
        return Companion.parsePluginList(reader);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @NotNull
    public static final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull Set<PluginId> pluginIds2, @Nullable BuildNumber buildNumber) {
        return Companion.loadLastCompatiblePluginDescriptors(pluginIds2, buildNumber);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @NotNull
    public static final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull Set<PluginId> pluginIds2) {
        return com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.loadLastCompatiblePluginDescriptors$default(Companion, pluginIds2, null, 2, null);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @NotNull
    public static final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull Set<PluginId> ids, @Nullable BuildNumber buildNumber) {
        return Companion.getLastCompatiblePluginUpdate(ids, buildNumber);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @NotNull
    public static final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull Set<PluginId> ids) {
        return com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.getLastCompatiblePluginUpdate$default(Companion, ids, null, 2, null);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @NotNull
    public static final PluginNode loadPluginDescriptor$intellij_platform_ide_impl(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate, @Nullable ProgressIndicator indicator2) throws IOException {
        return Companion.loadPluginDescriptor$intellij_platform_ide_impl(xmlId, ideCompatibleUpdate, indicator2);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresNoReadLock
    @JvmOverloads
    @NotNull
    public static final PluginNode loadPluginDescriptor$intellij_platform_ide_impl(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate) throws IOException {
        return com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.loadPluginDescriptor$intellij_platform_ide_impl$default(Companion, xmlId, ideCompatibleUpdate, null, 4, null);
    }

    @JvmStatic
    @JvmName(name="readOrUpdateFile")
    public static final <T> T readOrUpdateFile(@Nullable Path file2, @NotNull String url, @Nullable ProgressIndicator indicator2, @Nls @NotNull String indicatorMessage, @NotNull Function1<? super Reader, ? extends T> parser) throws IOException {
        return Companion.readOrUpdateFile(file2, url, indicator2, indicatorMessage, parser);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J)\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00182\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0001\u00a2\u0006\u0002\b&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010(\u001a\u00020)H\u0007JM\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0001\u0010/\u001a\u00020\u00042\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H+01H\u0001\u00a2\u0006\u0002\u00102R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests$Companion;", "", "()V", "COMPATIBLE_UPDATE_URL", "", "Instance", "Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "getInstance$annotations", "getInstance", "()Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "PLUGIN_MANAGER_URL", "applicationInfo", "Lcom/intellij/openapi/application/impl/ApplicationInfoImpl;", "Lorg/jetbrains/annotations/NotNull;", "getApplicationInfo", "()Lcom/intellij/openapi/application/impl/ApplicationInfoImpl;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "getLastCompatiblePluginUpdate", "", "Lcom/intellij/ide/plugins/marketplace/IdeCompatibleUpdate;", "ids", "", "Lcom/intellij/openapi/extensions/PluginId;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "loadLastCompatiblePluginDescriptors", "Lcom/intellij/ide/plugins/PluginNode;", "pluginIds", "loadPluginDescriptor", "xmlId", "ideCompatibleUpdate", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadPluginDescriptor$intellij_platform_ide_impl", "parsePluginList", "reader", "Ljava/io/Reader;", "readOrUpdateFile", "T", "file", "Ljava/nio/file/Path;", "url", "indicatorMessage", "parser", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final ObjectMapper getObjectMapper() {
            Lazy lazy = objectMapper$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (ObjectMapper)lazy.getValue();
        }

        private final ApplicationInfoImpl getApplicationInfo() {
            ApplicationInfoImpl applicationInfoImpl = ApplicationInfoImpl.getShadowInstanceImpl();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoImpl), (String)"ApplicationInfoImpl.getShadowInstanceImpl()");
            return applicationInfoImpl;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final MarketplaceRequests getInstance() {
            PluginInfoProvider pluginInfoProvider = PluginInfoProvider.getInstance();
            if (pluginInfoProvider == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.plugins.marketplace.MarketplaceRequests");
            }
            return (MarketplaceRequests)pluginInfoProvider;
        }

        @JvmStatic
        @NotNull
        public final List<PluginNode> parsePluginList(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                RepositoryContentHandler handler2 = new RepositoryContentHandler();
                parser.parse(new InputSource(reader), (DefaultHandler)handler2);
                List<PluginNode> list2 = handler2.getPluginsList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"handler.pluginsList");
                return list2;
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof ParserConfigurationException || exception instanceof SAXException || exception instanceof RuntimeException) {
                    throw (Throwable)new IOException(e);
                }
                throw (Throwable)e;
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @RequiresBackgroundThread
        @RequiresNoReadLock
        @JvmOverloads
        @NotNull
        public final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull Set<PluginId> pluginIds2, @Nullable BuildNumber buildNumber) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(pluginIds2, (String)"pluginIds");
            Iterable $this$map$iv = this.getLastCompatiblePluginUpdate(pluginIds2, buildNumber);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdeCompatibleUpdate ideCompatibleUpdate = (IdeCompatibleUpdate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PluginNode pluginNode = Companion.loadPluginDescriptor$intellij_platform_ide_impl(it.getPluginId(), (IdeCompatibleUpdate)it, null);
                collection.add(pluginNode);
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List loadLastCompatiblePluginDescriptors$default(Companion companion, Set set2, BuildNumber buildNumber, int n, Object object) {
            if ((n & 2) != 0) {
                buildNumber = null;
            }
            return companion.loadLastCompatiblePluginDescriptors(set2, buildNumber);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @RequiresNoReadLock
        @JvmOverloads
        @NotNull
        public final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull Set<PluginId> pluginIds2) {
            return com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.loadLastCompatiblePluginDescriptors$default(this, pluginIds2, null, 2, null);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @RequiresNoReadLock
        @JvmOverloads
        @NotNull
        public final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull Set<PluginId> ids, @Nullable BuildNumber buildNumber) {
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            try {
                if (ids.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                String data2 = this.getObjectMapper().writeValueAsString((Object)new CompatibleUpdateRequest(ids, buildNumber));
                Object object = HttpRequests.post((String)Urls.newFromEncoded((String)COMPATIBLE_UPDATE_URL).toExternalForm(), (String)"application/json; charset=utf-8").productNameAsUserAgent().throwStatusCodeException(false).connect(new HttpRequests.RequestProcessor(data2){
                    final /* synthetic */ String $data;

                    public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.write(this.$data);
                        return (List)com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.access$getObjectMapper$p(MarketplaceRequests.Companion).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                    }
                    {
                        this.$data = string;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n          .\u2026pdate>>() {})\n          }");
                return (List)object;
            }
            catch (Exception e) {
                MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get compatible updates from Marketplace", e);
                return CollectionsKt.emptyList();
            }
        }

        public static /* synthetic */ List getLastCompatiblePluginUpdate$default(Companion companion, Set set2, BuildNumber buildNumber, int n, Object object) {
            if ((n & 2) != 0) {
                buildNumber = null;
            }
            return companion.getLastCompatiblePluginUpdate(set2, buildNumber);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @RequiresNoReadLock
        @JvmOverloads
        @NotNull
        public final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull Set<PluginId> ids) {
            return com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.getLastCompatiblePluginUpdate$default(this, ids, null, 2, null);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @RequiresNoReadLock
        @JvmOverloads
        @NotNull
        public final PluginNode loadPluginDescriptor$intellij_platform_ide_impl(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate, @Nullable ProgressIndicator indicator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
            Intrinsics.checkNotNullParameter((Object)ideCompatibleUpdate, (String)"ideCompatibleUpdate");
            Path updateMetadataFile = Paths.get(PathManager.getPluginTempPath(), "meta");
            Path path2 = updateMetadataFile.resolve(ideCompatibleUpdate.getExternalUpdateId() + ".json");
            String string = PLUGIN_MANAGER_URL + "/files/" + ideCompatibleUpdate.getExternalPluginId() + '/' + ideCompatibleUpdate.getExternalUpdateId() + "/meta.json";
            String string2 = IdeBundle.message((String)"progress.downloading.plugins.meta", (Object[])new Object[]{xmlId});
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"progr\u2026ing.plugins.meta\", xmlId)");
            return ((IntellijUpdateMetadata)this.readOrUpdateFile(path2, string, indicator2, string2, loadPluginDescriptor.1.INSTANCE)).toPluginNode();
        }

        public static /* synthetic */ PluginNode loadPluginDescriptor$intellij_platform_ide_impl$default(Companion companion, String string, IdeCompatibleUpdate ideCompatibleUpdate, ProgressIndicator progressIndicator, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                progressIndicator = null;
            }
            return companion.loadPluginDescriptor$intellij_platform_ide_impl(string, ideCompatibleUpdate, progressIndicator);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @RequiresNoReadLock
        @JvmOverloads
        @NotNull
        public final PluginNode loadPluginDescriptor$intellij_platform_ide_impl(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate) throws IOException {
            return com.intellij.ide.plugins.marketplace.MarketplaceRequests$Companion.loadPluginDescriptor$intellij_platform_ide_impl$default(this, xmlId, ideCompatibleUpdate, null, 4, null);
        }

        @JvmStatic
        @JvmName(name="readOrUpdateFile")
        public final <T> T readOrUpdateFile(@Nullable Path file2, @NotNull String url, @Nullable ProgressIndicator indicator2, @Nls @NotNull String indicatorMessage, @NotNull Function1<? super Reader, ? extends T> parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)indicatorMessage, (String)"indicatorMessage");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            String eTag = file2 == null ? null : MarketplaceRequestsKt.access$loadETagForFile(file2);
            return (T)HttpRequests.request((String)url).tuner(new HttpRequests.ConnectionTuner(eTag){
                final /* synthetic */ String $eTag;

                public final void tune(@NotNull URLConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    if (this.$eTag != null) {
                        connection.setRequestProperty("If-None-Match", this.$eTag);
                    }
                }
                {
                    this.$eTag = string;
                }
            }).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor(indicator2, file2, parser, indicatorMessage, url){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Path $file;
                final /* synthetic */ Function1 $parser;
                final /* synthetic */ String $indicatorMessage;
                final /* synthetic */ String $url;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T process(@NotNull HttpRequests.Request request2) {
                    Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                    try {
                        Object object;
                        ProgressIndicator progressIndicator = this.$indicator;
                        if (progressIndicator != null) {
                            progressIndicator.checkCanceled();
                        }
                        URLConnection uRLConnection = request2.getConnection();
                        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"request.connection");
                        URLConnection connection = uRLConnection;
                        if (this.$file != null && MarketplaceRequestsKt.access$isNotModified(connection, this.$file)) {
                            Object object2;
                            Closeable closeable = Files.newBufferedReader(this.$file);
                            Function1 function1 = this.$parser;
                            boolean bl = false;
                            boolean bl2 = false;
                            Throwable throwable = null;
                            try {
                                object2 = function1.invoke((Object)closeable);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            return (T)object2;
                        }
                        if (this.$indicator != null) {
                            this.$indicator.checkCanceled();
                            this.$indicator.setText2(this.$indicatorMessage);
                        }
                        if (this.$file == null) {
                            Object object3;
                            Closeable closeable = request2.getReader();
                            Function1 function1 = this.$parser;
                            boolean bl = false;
                            boolean bl3 = false;
                            Throwable throwable = null;
                            try {
                                object3 = function1.invoke((Object)closeable);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            return (T)object3;
                        }
                        Object object4 = MarketplaceRequests.Companion;
                        boolean bl = false;
                        boolean bl4 = false;
                        synchronized (object4) {
                            Unit unit;
                            boolean bl5 = false;
                            request2.saveToFile(this.$file, this.$indicator);
                            String string = connection.getHeaderField("ETag");
                            if (string != null) {
                                object = string;
                                boolean bl6 = false;
                                boolean bl7 = false;
                                String it = object;
                                boolean bl8 = false;
                                MarketplaceRequestsKt.access$saveETagForFile(this.$file, it);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Unit unit2 = unit;
                        }
                        object4 = Files.newBufferedReader(this.$file);
                        Function1 function1 = this.$parser;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        Throwable throwable = null;
                        try {
                            object = function1.invoke(object4);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
                        }
                        return (T)object;
                    }
                    catch (HttpRequests.HttpStatusException e) {
                        MarketplaceRequestsKt.access$getLOG$p().warnWithDebug("Cannot load data from " + this.$url + " (statusCode=" + e.getStatusCode() + ')', (Throwable)e);
                        throw (Throwable)e;
                    }
                    catch (Exception e) {
                        MarketplaceRequestsKt.access$getLOG$p().warnWithDebug("Error reading Marketplace file: " + e + " (file=" + this.$file + " URL=" + this.$url + ')', (Throwable)e);
                        if (this.$file != null && MarketplaceRequestsKt.access$getLOG$p().isDebugEnabled()) {
                            Companion companion;
                            Object $this$runCatching2;
                            Object object;
                            Companion companion2 = MarketplaceRequests.Companion;
                            StringBuilder stringBuilder = new StringBuilder().append("File content:\n");
                            Logger logger = MarketplaceRequestsKt.access$getLOG$p();
                            boolean bl = false;
                            try {
                                object = Result.Companion;
                                $this$runCatching2 = companion2;
                                boolean bl11 = false;
                                $this$runCatching2 = Files.readString(this.$file);
                                bl11 = false;
                                object = Result.constructor-impl((Object)$this$runCatching2);
                            }
                            catch (Throwable $this$runCatching2) {
                                Result.Companion bl11 = Result.Companion;
                                boolean bl12 = false;
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
                            }
                            Object object5 = object;
                            Logger logger2 = logger;
                            StringBuilder stringBuilder2 = stringBuilder;
                            companion2 = object5;
                            bl = false;
                            boolean bl13 = false;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)companion2);
                            if (throwable == null) {
                                companion = companion2;
                            } else {
                                $this$runCatching2 = throwable;
                                stringBuilder = stringBuilder2;
                                logger = logger2;
                                boolean bl14 = false;
                                object5 = IoErrorText.message((Throwable)e);
                                logger2 = logger;
                                stringBuilder2 = stringBuilder;
                                companion = object5;
                            }
                            logger2.debug(stringBuilder2.append((String)((Object)companion)).toString());
                        }
                        throw (Throwable)e;
                    }
                }
                {
                    this.$indicator = progressIndicator;
                    this.$file = path2;
                    this.$parser = function1;
                    this.$indicatorMessage = string;
                    this.$url = string2;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

