/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.PluginPriceService;
import com.intellij.ide.plugins.newui.Tags;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicensePanel
extends NonOpaquePanel {
    private final JLabel mySubMessage = new JLabel();
    private final JPanel myPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)5))));
    private final JLabel myMessage = new JLabel();
    private final ActionLink myLink = new ActionLink();
    private Runnable myLinkRunnable;

    public LicensePanel(boolean tiny) {
        this.setLayout(new BorderLayout());
        this.add(tiny ? PluginManagerConfigurable.setTinyFont(this.mySubMessage) : this.mySubMessage, "North");
        this.add(this.myPanel);
        this.myPanel.add(tiny ? PluginManagerConfigurable.setTinyFont(this.myMessage) : this.myMessage);
        this.myPanel.add((Component)(tiny ? PluginManagerConfigurable.setTinyFont(this.myLink) : this.myLink));
        this.myLink.addActionListener(e -> this.myLinkRunnable.run());
        this.hideElements();
    }

    public boolean isNotification() {
        return this.myMessage.getIcon() != null || this.myMessage.isForegroundSet();
    }

    @Nullable
    @NlsSafe
    public String getMessage() {
        String text2 = this.myMessage.getText();
        if (this.mySubMessage.isVisible()) {
            return this.mySubMessage.getText() + "\n" + text2;
        }
        if (StringUtil.endsWithChar((CharSequence)text2, (char)'.')) {
            return text2.substring(0, text2.length() - 1);
        }
        return text2;
    }

    public void setText(@NotNull @Nls String text2, boolean warning, boolean errorColor) {
        int separator2;
        if (text2 == null) {
            LicensePanel.$$$reportNull$$$0(0);
        }
        if ((separator2 = text2.indexOf(10)) == -1) {
            this.myMessage.setText(text2);
            this.myMessage.setIcon(warning ? AllIcons.General.Warning : null);
        } else {
            this.mySubMessage.setText(text2.substring(0, separator2));
            this.mySubMessage.setIcon(warning ? AllIcons.General.Warning : null);
            this.mySubMessage.setVisible(true);
            this.myMessage.setText(text2.substring(separator2 + 1));
            this.myMessage.setIcon(warning ? EmptyIcon.ICON_16 : null);
        }
        this.myMessage.setForeground(errorColor ? DialogWrapper.ERROR_FOREGROUND_COLOR : null);
        this.myMessage.setVisible(true);
        this.myPanel.setVisible(true);
    }

    public void setTextFromStamp(@NotNull String stamp, @Nullable Date expirationDate) {
        long days;
        if (stamp == null) {
            LicensePanel.$$$reportNull$$$0(1);
        }
        long l = days = expirationDate == null ? 0L : DateFormatUtil.getDifferenceInDays((Date)new Date(), (Date)expirationDate);
        if (stamp.startsWith("eval:")) {
            if (days <= 0L) {
                this.setText(IdeBundle.message((String)"trial.expired", (Object[])new Object[0]), false, true);
            } else {
                this.setText(IdeBundle.message((String)"plugins.configurable.trial.expires.in.0.days", (Object[])new Object[]{days}), days < 11L, false);
            }
        } else if (expirationDate == null) {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.is.active", (Object[])new Object[0]), false, false);
        } else if (days > 30L) {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.is.active.until.0", (Object[])new Object[]{PluginManagerConfigurable.DATE_FORMAT.format(expirationDate)}), false, false);
        } else if (days <= 0L) {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.expired", (Object[])new Object[0]), false, true);
        } else {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.expires.in.0.days", (Object[])new Object[]{days}), days < 11L, false);
        }
    }

    public void setLink(@NotNull @Nls String text2, @NotNull Runnable action2, boolean external) {
        if (text2 == null) {
            LicensePanel.$$$reportNull$$$0(2);
        }
        if (action2 == null) {
            LicensePanel.$$$reportNull$$$0(3);
        }
        this.myLinkRunnable = action2;
        this.myLink.setText(text2);
        if (external) {
            this.myLink.setExternalLinkIcon();
        } else {
            this.myLink.setIcon(null);
        }
        this.myLink.setVisible(true);
        this.myPanel.setVisible(true);
    }

    public void updateLink(@NotNull @Nls String text2, boolean async) {
        if (text2 == null) {
            LicensePanel.$$$reportNull$$$0(4);
        }
        this.myLink.setText(text2);
        if (async) {
            this.myPanel.doLayout();
        }
    }

    public void hideWithChildren() {
        this.hideElements();
        this.setVisible(false);
    }

    private void hideElements() {
        this.mySubMessage.setVisible(false);
        this.myMessage.setVisible(false);
        this.myLink.setVisible(false);
        this.myPanel.setVisible(false);
    }

    public void showBuyPlugin(@NotNull Supplier<? extends IdeaPluginDescriptor> getPlugin) {
        if (getPlugin == null) {
            LicensePanel.$$$reportNull$$$0(5);
        }
        IdeaPluginDescriptor plugin2 = getPlugin.get();
        this.setLink(IdeBundle.message((String)"plugins.configurable.buy.the.plugin", (Object[])new Object[0]), () -> BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl("https://plugins.jetbrains.com/purchase-link/" + plugin2.getProductCode())), true);
        if (plugin2 instanceof PluginNode) {
            List<String> tags = ((PluginNode)plugin2).getTags();
            if (tags.contains(Tags.Freemium.name())) {
                this.updateLink(IdeBundle.message((String)"plugins.configurable.activate.trial.for.full.access", (Object[])new Object[0]), false);
            }
        } else {
            PluginPriceService.getPrice(plugin2, (Consumer<? super String>)((Consumer)price -> this.updateLink(IdeBundle.message((String)"plugins.configurable.buy.the.plugin.from.0", (Object[])new Object[]{price}), false)), (Consumer<? super String>)((Consumer)price -> {
                if (plugin2 == getPlugin.get()) {
                    this.updateLink(IdeBundle.message((String)"plugins.configurable.buy.the.plugin.from.0", (Object[])new Object[]{price}), true);
                }
            }));
        }
    }

    public static boolean isEA2Product(@Nullable String productCodeOrPluginId) {
        return productCodeOrPluginId != null && LicensingFacade.getInstance() != null && ArrayUtil.contains((String)productCodeOrPluginId, (String[])new String[]{"DPN", "DC", "DPA", "PDB", "PWS", "PGO", "PPS", "PPC", "PRB", "PSW", "Pythonid"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stamp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getPlugin";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/LicensePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTextFromStamp";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showBuyPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

