/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ChangeListTodosPanel
extends TodoPanel {
    private final Alarm myAlarm;

    public ChangeListTodosPanel(Project project, TodoPanelSettings settings, Content content2) {
        super(project, settings, false, content2);
        ChangeListManager.getInstance((Project)project).addChangeListListener((ChangeListListener)new MyChangeListManagerListener(), (Disposable)this);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    @NotNull
    @NlsContexts.TabTitle
    static String getTabName(@NotNull Project project) {
        ChangeListManager changeListManager;
        if (project == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(0);
        }
        if ((changeListManager = ChangeListManager.getInstance((Project)project)).areChangeListsEnabled()) {
            String suffix;
            LocalChangeList list2 = changeListManager.getDefaultChangeList();
            String changelistName = list2.getName().trim();
            Object object = StringUtil.endsWithIgnoreCase((String)changelistName, (String)(suffix = VcsBundle.message((String)"todo.tab.title.changelist.suffix", (Object[])new Object[0]))) ? changelistName : changelistName + " " + suffix;
            if (object == null) {
                ChangeListTodosPanel.$$$reportNull$$$0(1);
            }
            return object;
        }
        String string = VcsBundle.message((String)"todo.tab.title.all.changes", (Object[])new Object[0]);
        if (string == null) {
            ChangeListTodosPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/ChangeListTodosPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/ChangeListTodosPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTabName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyChangeListManagerListener
    extends ChangeListAdapter {
        private MyChangeListManagerListener() {
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
            this.updateTabName();
        }

        public void changeListRenamed(ChangeList list2, String oldName) {
            this.updateTabName();
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
        }

        public void allChangeListsMappingsChanged() {
            this.updateTabName();
        }

        private void updateTabName() {
            AppUIUtil.invokeOnEdt(() -> {
                if (ChangeListTodosPanel.this.myProject != null) {
                    ChangeListTodosPanel.this.setDisplayName(ChangeListTodosPanel.getTabName(ChangeListTodosPanel.this.myProject));
                }
            });
        }
    }
}

