/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.ide.ui.customization.CustomizableActionGroupProvider;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.ide.ui.customization.CustomActionsSchema", storages={@Storage(value="customization.xml")}, category=SettingsCategory.UI)
public final class CustomActionsSchema
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(CustomActionsSchema.class);
    @NonNls
    private static final String ACTIONS_SCHEMA = "custom_actions_schema";
    @NonNls
    private static final String ACTIVE = "active";
    @NonNls
    private static final String ELEMENT_ACTION = "action";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String GROUP = "group";
    private static final Map<String, String> ourAdditionalIdToName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> myIconCustomizations = new HashMap<String, String>();
    private final Map<String, @Nls String> myIdToName = new LinkedHashMap<String, String>();
    private final Map<String, ActionGroup> myIdToActionGroup = new HashMap<String, ActionGroup>();
    private final Set<String> myExtGroupIds = new HashSet<String>();
    private List<ActionUrl> myActions = new ArrayList<ActionUrl>();
    private boolean isFirstLoadState = true;
    private int myModificationStamp = 0;

    public CustomActionsSchema() {
        this.myIdToName.put("MainMenu", ActionsTreeUtil.getMainMenuTitle());
        if (ToolbarSettings.getInstance().isEnabled()) {
            this.myIdToName.put("CenterToolbarSideGroup", ActionsTreeUtil.getExperimentalToolbar());
        }
        this.myIdToName.put("MainToolBar", ActionsTreeUtil.getMainToolbar());
        this.myIdToName.put("EditorPopupMenu", ActionsTreeUtil.getEditorPopup());
        this.myIdToName.put("EditorGutterPopupMenu", ActionsTreeUtil.getEditorGutterPopupMenu());
        this.myIdToName.put("EditorTabPopupMenu", ActionsTreeUtil.getEditorTabPopup());
        this.myIdToName.put("ProjectViewPopupMenu", ActionsTreeUtil.getProjectViewPopup());
        this.myIdToName.put("ScopeViewPopupMenu", ActionsTreeUtil.getScopeViewPopupMenu());
        this.myIdToName.put("FavoritesViewPopupMenu", ActionsTreeUtil.getFavoritesPopup());
        this.myIdToName.put("CommanderPopupMenu", ActionsTreeUtil.getCommanderPopup());
        this.myIdToName.put("J2EEViewPopupMenu", ActionsTreeUtil.getJ2EEPopup());
        this.myIdToName.put("NavbarPopupMenu", ActionsTreeUtil.getNavigationBarPopupMenu());
        this.myIdToName.put("NavBarToolBar", ActionsTreeUtil.getNavigationBarToolbar());
        this.fillExtGroups();
        CustomizableActionGroupProvider.EP_NAME.addChangeListener(this::fillExtGroups, null);
        this.myIdToName.putAll(ourAdditionalIdToName);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void fillExtGroups() {
        for (String id2 : this.myExtGroupIds) {
            this.myIdToName.remove(id2);
        }
        this.myExtGroupIds.clear();
        ArrayList<@Nls E> extList = new ArrayList();
        CustomizableActionGroupProvider.CustomizableActionGroupRegistrar registrar = (groupId2, groupTitle) -> extList.add(Pair.create((Object)groupId2, (Object)groupTitle));
        for (CustomizableActionGroupProvider provider2 : (CustomizableActionGroupProvider[])CustomizableActionGroupProvider.EP_NAME.getExtensions()) {
            provider2.registerGroups(registrar);
        }
        extList.sort((o1, o2) -> StringUtil.naturalCompare((String)((String)o1.second), (String)((String)o2.second)));
        for (Pair couple : extList) {
            this.myExtGroupIds.add((String)couple.first);
            this.myIdToName.put((String)couple.first, (String)couple.second);
        }
    }

    public static void addSettingsGroup(@NotNull String itemId, @Nls @NotNull String itemName) {
        if (itemId == null) {
            CustomActionsSchema.$$$reportNull$$$0(0);
        }
        if (itemName == null) {
            CustomActionsSchema.$$$reportNull$$$0(1);
        }
        ourAdditionalIdToName.put(itemId, itemName);
        CustomActionsSchema customActionSchema = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
        if (customActionSchema != null) {
            customActionSchema.myIdToName.put(itemId, itemName);
        }
    }

    public static void removeSettingsGroup(@NotNull String itemId) {
        if (itemId == null) {
            CustomActionsSchema.$$$reportNull$$$0(2);
        }
        ourAdditionalIdToName.remove(itemId);
        CustomActionsSchema customActionSchema = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
        if (customActionSchema != null) {
            customActionSchema.myIdToName.remove(itemId);
        }
    }

    public static CustomActionsSchema getInstance() {
        return (CustomActionsSchema)ApplicationManager.getApplication().getService(CustomActionsSchema.class);
    }

    public void addAction(ActionUrl url) {
        this.myActions.add(url);
        this.resortActions();
    }

    @NotNull
    public List<ActionUrl> getActions() {
        List<ActionUrl> list2 = this.myActions;
        if (list2 == null) {
            CustomActionsSchema.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void setActions(@NotNull List<ActionUrl> actions2) {
        if (actions2 == null) {
            CustomActionsSchema.$$$reportNull$$$0(4);
        }
        this.myActions = actions2;
        this.resortActions();
    }

    public void copyFrom(CustomActionsSchema result2) {
        this.myIdToActionGroup.clear();
        this.myActions.clear();
        this.myIconCustomizations.clear();
        for (ActionUrl actionUrl : result2.myActions) {
            ActionUrl url = new ActionUrl(new ArrayList<String>(actionUrl.getGroupPath()), actionUrl.getComponent(), actionUrl.getActionType(), actionUrl.getAbsolutePosition());
            url.setInitialPosition(actionUrl.getInitialPosition());
            this.myActions.add(url);
        }
        this.resortActions();
        this.myIconCustomizations.putAll(result2.myIconCustomizations);
    }

    private void resortActions() {
        this.myActions.sort(ActionUrlComparator.INSTANCE);
    }

    public boolean isModified(CustomActionsSchema schema2) {
        List<ActionUrl> storedActions = schema2.getActions();
        if (ApplicationManager.getApplication().isUnitTestMode() && !storedActions.isEmpty()) {
            LOG.error(IdeBundle.message((String)"custom.action.stored", (Object[])new Object[]{storedActions}));
            LOG.error(IdeBundle.message((String)"custom.action.actual", (Object[])new Object[]{this.getActions()}));
        }
        if (storedActions.size() != this.getActions().size()) {
            return true;
        }
        for (int i2 = 0; i2 < this.getActions().size(); ++i2) {
            if (this.getActions().get(i2).equals(storedActions.get(i2))) continue;
            return true;
        }
        if (schema2.myIconCustomizations.size() != this.myIconCustomizations.size()) {
            return true;
        }
        for (String actionId : this.myIconCustomizations.keySet()) {
            if (Comparing.strEqual((String)schema2.getIconPath(actionId), (String)this.getIconPath(actionId))) continue;
            return true;
        }
        return false;
    }

    public void loadState(@NotNull Element element2) {
        boolean reload2;
        if (element2 == null) {
            CustomActionsSchema.$$$reportNull$$$0(5);
        }
        this.myIdToActionGroup.clear();
        this.myActions.clear();
        this.myIconCustomizations.clear();
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
        Element schElement = element2;
        String activeName = element2.getAttributeValue(ACTIVE);
        if (activeName != null) {
            block0: for (Element toolbarElement : element2.getChildren(ACTIONS_SCHEMA)) {
                for (Element o : toolbarElement.getChildren("option")) {
                    if (!Comparing.strEqual((String)o.getAttributeValue("name"), (String)"myName") || !Comparing.strEqual((String)o.getAttributeValue("value"), (String)activeName)) continue;
                    schElement = toolbarElement;
                    continue block0;
                }
            }
        }
        for (Element groupElement : schElement.getChildren(GROUP)) {
            ActionUrl url = new ActionUrl();
            url.readExternal(groupElement);
            this.myActions.add(url);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(IdeBundle.message((String)"custom.option.testmode", (Object[])new Object[]{this.myActions.toString()}));
        }
        for (Element action2 : element2.getChildren(ELEMENT_ACTION)) {
            String actionId = action2.getAttributeValue(ATTRIBUTE_ID);
            String iconPath = action2.getAttributeValue(ATTRIBUTE_ICON);
            if (actionId == null) continue;
            this.myIconCustomizations.put(actionId, iconPath);
        }
        boolean bl = reload2 = !this.isFirstLoadState;
        if (this.isFirstLoadState) {
            this.isFirstLoadState = false;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.initActionIcons();
            if (reload2) {
                CustomActionsSchema.setCustomizationSchemaForCurrentProjects();
            }
        });
    }

    public void clearFirstLoadState() {
        this.isFirstLoadState = false;
    }

    public static void setCustomizationSchemaForCurrentProjects() {
        CustomActionsSchema.getInstance().incrementModificationStamp();
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectFrameHelper frame = windowManager.getFrameHelper(project);
            if (frame == null) continue;
            frame.updateView();
        }
        ProjectFrameHelper frame = windowManager.getFrameHelper(null);
        if (frame != null) {
            frame.updateView();
        }
    }

    public void incrementModificationStamp() {
        ++this.myModificationStamp;
    }

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    public Element getState() {
        Element element2 = new Element("state");
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element2);
        for (ActionUrl group2 : this.myActions) {
            Element groupElement = new Element(GROUP);
            group2.writeExternal(groupElement);
            element2.addContent(groupElement);
        }
        this.writeIcons(element2);
        return element2;
    }

    @Nullable
    public AnAction getCorrectedAction(String id2) {
        if (!this.myIdToName.containsKey(id2)) {
            return ActionManager.getInstance().getAction(id2);
        }
        ActionGroup existing = this.myIdToActionGroup.get(id2);
        if (existing != null) {
            return existing;
        }
        ActionGroup actionGroup2 = (ActionGroup)ActionManager.getInstance().getAction(id2);
        if (actionGroup2 != null) {
            String name2 = this.myIdToName.get(id2);
            ActionGroup corrected = CustomizationUtil.correctActionGroup(actionGroup2, this, name2, name2, true);
            this.myIdToActionGroup.put(id2, corrected);
            return corrected;
        }
        return null;
    }

    public void invalidateCustomizedActionGroup(String groupId2) {
        ActionGroup group2 = this.myIdToActionGroup.get(groupId2);
        if (group2 instanceof CustomisedActionGroup) {
            ((CustomisedActionGroup)group2).resetChildren();
        }
    }

    public void fillCorrectedActionGroups(@NotNull DefaultMutableTreeNode root2) {
        if (root2 == null) {
            CustomActionsSchema.$$$reportNull$$$0(6);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ArrayList path2 = ContainerUtil.newArrayList((Object[])new String[]{"root"});
        for (Map.Entry<String, String> entry2 : this.myIdToName.entrySet()) {
            ActionGroup actionGroup2 = (ActionGroup)actionManager.getAction(entry2.getKey());
            if (actionGroup2 == null) continue;
            root2.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createCorrectedGroup(actionGroup2, entry2.getValue(), path2, this.myActions)));
        }
    }

    public void fillActionGroups(DefaultMutableTreeNode root2) {
        ActionManager actionManager = ActionManager.getInstance();
        for (String id2 : this.myIdToName.keySet()) {
            ActionGroup actionGroup2 = (ActionGroup)actionManager.getAction(id2);
            if (actionGroup2 == null) continue;
            root2.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createGroup(actionGroup2, this.myIdToName.get(id2), null, null, true, null, false)));
        }
    }

    public boolean isCorrectActionGroup(ActionGroup group2, String defaultGroupName) {
        if (this.myActions.isEmpty()) {
            return false;
        }
        String text2 = group2.getTemplatePresentation().getText();
        if (!StringUtil.isEmpty((String)text2)) {
            for (ActionUrl url : this.myActions) {
                String id2;
                if (url.getGroupPath().contains(text2) || url.getGroupPath().contains(defaultGroupName)) {
                    return true;
                }
                if (!(url.getComponent() instanceof Group)) continue;
                Group urlGroup = (Group)url.getComponent();
                String string = id2 = urlGroup.getName() != null ? urlGroup.getName() : urlGroup.getId();
                if (id2 != null && !id2.equals(text2) && !id2.equals(defaultGroupName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public List<ActionUrl> getChildActions(ActionUrl url) {
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = url.getGroupPath();
        for (ActionUrl actionUrl : this.myActions) {
            int index2;
            if (groupPath.size() > actionUrl.getGroupPath().size()) continue;
            for (index2 = 0; index2 < groupPath.size() && Objects.equals(groupPath.get(index2), actionUrl.getGroupPath().get(index2)); ++index2) {
            }
            if (index2 != groupPath.size()) continue;
            result2.add(actionUrl);
        }
        ArrayList<ActionUrl> arrayList = result2;
        if (arrayList == null) {
            CustomActionsSchema.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void removeIconCustomization(String actionId) {
        this.myIconCustomizations.remove(actionId);
    }

    public void addIconCustomization(String actionId, String iconPath) {
        this.myIconCustomizations.put(actionId, iconPath != null ? FileUtil.toSystemIndependentName((String)iconPath) : null);
    }

    public String getIconPath(String actionId) {
        String path2 = this.myIconCustomizations.get(actionId);
        return path2 == null ? "" : path2;
    }

    private void writeIcons(Element parent) {
        for (String actionId : this.myIconCustomizations.keySet()) {
            Element action2 = new Element(ELEMENT_ACTION);
            action2.setAttribute(ATTRIBUTE_ID, actionId);
            String icon2 = this.myIconCustomizations.get(actionId);
            if (icon2 != null) {
                action2.setAttribute(ATTRIBUTE_ICON, icon2);
            }
            parent.addContent(action2);
        }
    }

    private void initActionIcons() {
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : this.myIconCustomizations.keySet()) {
            File f;
            AnAction anAction2 = actionManager.getAction(actionId);
            if (anAction2 == null) continue;
            Icon icon2 = AllIcons.Toolbar.Unknown;
            String iconPath = this.myIconCustomizations.get(actionId);
            if (iconPath != null && (f = new File(FileUtil.toSystemDependentName((String)iconPath))).exists()) {
                Image image = null;
                try {
                    image = ImageLoader.loadCustomIcon((File)f);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                if (image != null) {
                    icon2 = new JBImageIcon(image);
                }
            }
            anAction2.getTemplatePresentation().setIcon(icon2);
            anAction2.getTemplatePresentation().setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon2));
            anAction2.setDefaultIcon(false);
        }
        ProjectFrameHelper frame = WindowManagerEx.getInstanceEx().getFrameHelper(null);
        if (frame != null) {
            frame.updateView();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/CustomActionsSchema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/CustomActionsSchema";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsGroup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeSettingsGroup";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillCorrectedActionGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionUrlComparator
    implements Comparator<ActionUrl> {
        static final ActionUrlComparator INSTANCE = new ActionUrlComparator();
        static int DELETED = 1;

        private ActionUrlComparator() {
        }

        @Override
        public int compare(ActionUrl u1, ActionUrl u2) {
            int w2;
            int w1 = ActionUrlComparator.getEquivalenceClass(u1);
            if (w1 != (w2 = ActionUrlComparator.getEquivalenceClass(u2))) {
                return w1 - w2;
            }
            if (w1 == DELETED) {
                return u2.getAbsolutePosition() - u1.getAbsolutePosition();
            }
            return u1.getAbsolutePosition() - u2.getAbsolutePosition();
        }

        private static int getEquivalenceClass(ActionUrl url) {
            switch (url.getActionType()) {
                case -1: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 3;
        }
    }
}

