/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.PopupMenuPreloader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomizationUtil {
    private static final Logger LOG = Logger.getInstance(CustomizationUtil.class);

    private CustomizationUtil() {
    }

    public static ActionGroup correctActionGroup(ActionGroup group2, CustomActionsSchema schema2, String defaultGroupName, String rootGroupName, boolean force) {
        if (!force && !schema2.isCorrectActionGroup(group2, defaultGroupName)) {
            return group2;
        }
        String text2 = group2.getTemplatePresentation().getText();
        int mnemonic = group2.getTemplatePresentation().getMnemonic();
        if (text2 != null) {
            for (int i2 = 0; i2 < text2.length(); ++i2) {
                if (Character.toUpperCase(text2.charAt(i2)) != mnemonic) continue;
                text2 = text2.replaceFirst(String.valueOf(text2.charAt(i2)), "_" + text2.charAt(i2));
                break;
            }
        }
        return new CustomisedActionGroup(text2, group2, schema2, defaultGroupName, rootGroupName);
    }

    static AnAction[] getReordableChildren(ActionGroup group2, CustomActionsSchema schema2, String defaultGroupName, String rootGroupName, AnActionEvent e) {
        String text2 = group2.getTemplatePresentation().getText();
        ActionManager actionManager = ActionManager.getInstance();
        ArrayList<Object> reorderedChildren = new ArrayList<Object>();
        ContainerUtil.addAll(reorderedChildren, (Object[])group2.getChildren(e));
        List<ActionUrl> actions2 = schema2.getActions();
        for (ActionUrl actionUrl : actions2) {
            AnAction anAction2;
            AnAction componentAction;
            if (!actionUrl.getParentGroup().equals(text2) && !actionUrl.getParentGroup().equals(defaultGroupName) && (!actionUrl.getParentGroup().equals(actionManager.getId((AnAction)group2)) || !actionUrl.getRootGroup().equals(rootGroupName)) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (componentAction == group2) {
                    LOG.error("Attempt to add group to itself; group ID=" + actionManager.getId((AnAction)group2));
                    continue;
                }
                if (reorderedChildren.size() > actionUrl.getAbsolutePosition()) {
                    reorderedChildren.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                reorderedChildren.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || reorderedChildren.size() <= actionUrl.getAbsolutePosition() || ((anAction2 = (AnAction)reorderedChildren.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction2.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            reorderedChildren.remove(actionUrl.getAbsolutePosition());
        }
        for (int i2 = 0; i2 < reorderedChildren.size(); ++i2) {
            if (!(reorderedChildren.get(i2) instanceof ActionGroup)) continue;
            ActionGroup groupToCorrect = (ActionGroup)reorderedChildren.get(i2);
            ActionGroup correctedAction = CustomizationUtil.correctActionGroup(groupToCorrect, schema2, "", rootGroupName, false);
            reorderedChildren.set(i2, correctedAction);
        }
        return reorderedChildren.toArray(AnAction.EMPTY_ARRAY);
    }

    public static void optimizeSchema(JTree tree, CustomActionsSchema schema2) {
        Group rootGroup = new Group("root", null, null);
        DefaultMutableTreeNode root2 = new DefaultMutableTreeNode(rootGroup);
        root2.removeAllChildren();
        schema2.fillActionGroups(root2);
        Tree defaultTree = new Tree((TreeModel)new DefaultTreeModel(root2));
        ArrayList<ActionUrl> actions2 = new ArrayList<ActionUrl>();
        TreeUtil.traverseDepth((TreeNode)((TreeNode)tree.getModel().getRoot()), arg_0 -> CustomizationUtil.lambda$optimizeSchema$0((JTree)defaultTree, actions2, schema2, arg_0));
        schema2.setActions(actions2);
    }

    private static void computeDiff(ActionUrl[] defaultUserObjects, ActionUrl[] currentUserObjects, @NotNull List<? super ActionUrl> actions2) {
        if (actions2 == null) {
            CustomizationUtil.$$$reportNull$$$0(0);
        }
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])defaultUserObjects, (Object[])currentUserObjects);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
        }
        while (change != null) {
            ActionUrl currentUserObject;
            int idx;
            int i2;
            for (i2 = 0; i2 < change.deleted; ++i2) {
                idx = change.line0 + i2;
                currentUserObject = defaultUserObjects[idx];
                currentUserObject.setActionType(-1);
                currentUserObject.setAbsolutePosition(idx);
                actions2.add(currentUserObject);
            }
            for (i2 = 0; i2 < change.inserted; ++i2) {
                idx = change.line1 + i2;
                currentUserObject = currentUserObjects[idx];
                currentUserObject.setActionType(1);
                currentUserObject.setAbsolutePosition(idx);
                actions2.add(currentUserObject);
            }
            change = change.link;
        }
    }

    public static TreePath getPathByUserObjects(JTree tree, TreePath treePath) {
        ArrayList<String> path2 = new ArrayList<String>();
        for (int i2 = 0; i2 < treePath.getPath().length; ++i2) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o instanceof Group)) continue;
            path2.add(((Group)o).getName());
        }
        return CustomizationUtil.getTreePath(0, path2, tree.getModel().getRoot());
    }

    public static ActionUrl getActionUrl(TreePath treePath, int actionType) {
        ActionUrl url = new ActionUrl();
        for (int i2 = 0; i2 < treePath.getPath().length - 1; ++i2) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o instanceof Group)) continue;
            url.getGroupPath().add(((Group)o).getName());
        }
        DefaultMutableTreeNode component2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        url.setComponent(component2.getUserObject());
        TreeNode parent = component2.getParent();
        url.setAbsolutePosition(parent != null ? parent.getIndex(component2) : 0);
        url.setActionType(actionType);
        return url;
    }

    public static TreePath getTreePath(JTree tree, ActionUrl url) {
        return CustomizationUtil.getTreePath(0, url.getGroupPath(), tree.getModel().getRoot());
    }

    @Nullable
    private static TreePath getTreePath(int positionInPath, List<String> path2, Object root2) {
        TreeNode child2;
        if (!(root2 instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode2 = (DefaultMutableTreeNode)root2;
        Object userObject = treeNode2.getUserObject();
        if (path2.size() <= positionInPath) {
            return null;
        }
        String pathElement = path2.get(positionInPath);
        if (pathElement == null) {
            return null;
        }
        if (!(userObject instanceof Group)) {
            return null;
        }
        if (!pathElement.equals(((Group)userObject).getName())) {
            return null;
        }
        TreePath currentPath = new TreePath(treeNode2.getPath());
        if (positionInPath == path2.size() - 1) {
            return currentPath;
        }
        for (int j = 0; j < treeNode2.getChildCount() && (currentPath = CustomizationUtil.getTreePath(positionInPath + 1, path2, child2 = treeNode2.getChildAt(j))) == null; ++j) {
        }
        return currentPath;
    }

    private static ActionUrl[] getChildUserObjects(DefaultMutableTreeNode node2, ActionUrl parent) {
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = new ArrayList<String>(parent.getGroupPath());
        for (int i2 = 0; i2 < node2.getChildCount(); ++i2) {
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)node2.getChildAt(i2);
            ActionUrl url = new ActionUrl();
            url.setGroupPath(groupPath);
            Object userObject = child2.getUserObject();
            url.setComponent(userObject instanceof Pair ? ((Pair)userObject).first : userObject);
            result2.add(url);
        }
        return result2.toArray(new ActionUrl[0]);
    }

    @NotNull
    public static MouseListener installPopupHandler(@NotNull JComponent component2, @NotNull String groupId2, @NotNull String place) {
        if (component2 == null) {
            CustomizationUtil.$$$reportNull$$$0(1);
        }
        if (groupId2 == null) {
            CustomizationUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            CustomizationUtil.$$$reportNull$$$0(3);
        }
        final Supplier<ActionGroup> actionGroupSupplier = () -> (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId2);
        PopupHandler popupHandler2 = PopupHandler.installPopupMenu((JComponent)component2, (ActionGroup)new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                ActionGroup group2 = (ActionGroup)actionGroupSupplier.get();
                AnAction[] anActionArray = group2 == null ? EMPTY_ARRAY : group2.getChildren(e);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/customization/CustomizationUtil$1", "getChildren"));
            }
        }, (String)place);
        PopupMenuPreloader.install(component2, place, popupHandler2, actionGroupSupplier);
        PopupHandler popupHandler3 = popupHandler2;
        if (popupHandler3 == null) {
            CustomizationUtil.$$$reportNull$$$0(4);
        }
        return popupHandler3;
    }

    private static /* synthetic */ boolean lambda$optimizeSchema$0(JTree defaultTree, List actions2, CustomActionsSchema schema2, Object node2) {
        DefaultMutableTreeNode treeNode2 = (DefaultMutableTreeNode)node2;
        Object userObject = treeNode2.getUserObject();
        if (treeNode2.isLeaf() && !(userObject instanceof Group)) {
            return true;
        }
        ActionUrl url = CustomizationUtil.getActionUrl(new TreePath(treeNode2.getPath()), 0);
        String groupName = ((Group)userObject).getName();
        url.getGroupPath().add(groupName);
        TreePath treePath = CustomizationUtil.getTreePath(defaultTree, url);
        if (treePath != null) {
            DefaultMutableTreeNode visited = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ActionUrl[] defaultUserObjects = CustomizationUtil.getChildUserObjects(visited, url);
            ActionUrl[] currentUserObjects = CustomizationUtil.getChildUserObjects(treeNode2, url);
            CustomizationUtil.computeDiff(defaultUserObjects, currentUserObjects, actions2);
        } else {
            url.getGroupPath().remove(url.getParentGroup());
            if (actions2.contains(url)) {
                url.getGroupPath().add(groupName);
                actions2.addAll(schema2.getChildActions(url));
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "installPopupHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeDiff";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

