/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.experimental.toolbar;

import com.intellij.application.options.RegistryManager;
import com.intellij.ide.ui.ExperimentalToolbarSettingsState;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="ToolbarSettingsService", storages={@Storage(value="other.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0002\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings;", "Lcom/intellij/ide/ui/ToolbarSettings;", "Lcom/intellij/openapi/Disposable;", "()V", "value", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "isVisible", "setVisible", "toolbarState", "Lcom/intellij/ide/ui/ExperimentalToolbarSettingsState;", "dispose", "", "getState", "loadState", "state", "Companion", "ToolbarRegistryListener", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
public final class ExperimentalToolbarSettings
implements ToolbarSettings,
Disposable {
    private ExperimentalToolbarSettingsState toolbarState = new ExperimentalToolbarSettingsState();
    private static final Logger logger;
    private static RegistryValue newToolbarEnabled;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ExperimentalToolbarSettingsState getState() {
        return this.toolbarState;
    }

    public void loadState(@NotNull ExperimentalToolbarSettingsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.toolbarState = state;
        if (this.isEnabled()) {
            logger.info("Loaded state: " + state);
        }
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return newToolbarEnabled.asBoolean();
    }

    public void setEnabled(boolean value2) {
        newToolbarEnabled.setValue(value2);
    }

    public boolean isVisible() {
        return this.toolbarState.getShowNewMainToolbar() && this.isEnabled();
    }

    public void setVisible(boolean value2) {
        this.toolbarState.setShowNewMainToolbar(value2);
        UISettingsState uiSettingState = UISettings.Companion.getInstance().getState();
        uiSettingState.setShowMainToolbar(!value2 && uiSettingState.getShowMainToolbar());
        if (value2) {
            uiSettingState.setShowNavigationBar(false);
        }
    }

    private ExperimentalToolbarSettings() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isDisposed()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)extensionNotApplicableException), (String)"ExtensionNotApplicableException.INSTANCE");
            throw (Throwable)extensionNotApplicableException;
        }
        Disposer.register((Disposable)((Disposable)application), (Disposable)this);
        newToolbarEnabled.addListener((RegistryValueListener)new ToolbarRegistryListener(), (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExperimentalToolbarSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        ExperimentalToolbarSettings.logger = logger;
        RegistryValue registryValue = RegistryManager.getInstance().get("ide.widget.toolbar");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"RegistryManager.getInsta\u2026get(\"ide.widget.toolbar\")");
        newToolbarEnabled = registryValue;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings$ToolbarRegistryListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "(Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings;)V", "afterValueChanged", "", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.platform.ide.impl"})
    private final class ToolbarRegistryListener
    implements RegistryValueListener {
        public void afterValueChanged(@NotNull RegistryValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            boolean booleanValue = value2.asBoolean();
            logger.info("New registry value: " + booleanValue);
            ExperimentalToolbarSettings.this.setVisible(booleanValue);
            UISettings uiSettings = UISettings.Companion.getInstance();
            UISettingsState uiSettingsState = uiSettings.getState();
            uiSettingsState.setShowNavigationBar(!booleanValue);
            uiSettings.fireUISettingsChanged();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "newToolbarEnabled", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

